/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import com.google.common.base.Throwables;
import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.unsafe.ContextUtils;
import java.util.concurrent.Callable;

final class CurrentSpanUtils {
    private CurrentSpanUtils() {
    }

    static Span getCurrentSpan() {
        return (Span)ContextUtils.CONTEXT_SPAN_KEY.get();
    }

    static Scope withSpan(Span span, boolean endSpan) {
        return new ScopeInSpan(span, endSpan);
    }

    static Runnable withSpan(Span span, boolean endSpan, Runnable runnable) {
        return new RunnableInSpan(span, runnable, endSpan);
    }

    static <C> Callable<C> withSpan(Span span, boolean endSpan, Callable<C> callable) {
        return new CallableInSpan(span, callable, endSpan);
    }

    private static void setErrorStatus(Span span, Throwable t) {
        span.setStatus(Status.UNKNOWN.withDescription(t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage()));
    }

    private static final class CallableInSpan<V>
    implements Callable<V> {
        private final Span span;
        private final Callable<V> callable;
        private final boolean endSpan;

        private CallableInSpan(Span span, Callable<V> callable, boolean endSpan) {
            this.span = span;
            this.callable = callable;
            this.endSpan = endSpan;
        }

        @Override
        public V call() throws Exception {
            Context origContext = Context.current().withValue(ContextUtils.CONTEXT_SPAN_KEY, (Object)this.span).attach();
            try {
                V v = this.callable.call();
                return v;
            }
            catch (Exception e) {
                CurrentSpanUtils.setErrorStatus(this.span, e);
                throw e;
            }
            catch (Throwable t) {
                CurrentSpanUtils.setErrorStatus(this.span, t);
                Throwables.propagateIfPossible((Throwable)t);
                throw new RuntimeException("unexpected", t);
            }
            finally {
                Context.current().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class RunnableInSpan
    implements Runnable {
        private final Span span;
        private final Runnable runnable;
        private final boolean endSpan;

        private RunnableInSpan(Span span, Runnable runnable, boolean endSpan) {
            this.span = span;
            this.runnable = runnable;
            this.endSpan = endSpan;
        }

        @Override
        public void run() {
            Context origContext = Context.current().withValue(ContextUtils.CONTEXT_SPAN_KEY, (Object)this.span).attach();
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                CurrentSpanUtils.setErrorStatus(this.span, t);
                Throwables.propagateIfPossible((Throwable)t);
                throw new RuntimeException("unexpected", t);
            }
            finally {
                Context.current().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class ScopeInSpan
    implements Scope {
        private final Context origContext;
        private final Span span;
        private boolean endSpan;

        private ScopeInSpan(Span span, boolean endSpan) {
            this.span = span;
            this.endSpan = endSpan;
            this.origContext = Context.current().withValue(ContextUtils.CONTEXT_SPAN_KEY, (Object)span).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
            if (this.endSpan) {
                this.span.end();
            }
        }
    }
}

