/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassGraphBuilder {
    final Map<String, ClassInfo> classNameToClassInfo;
    private final ScanSpec scanSpec;
    private final Set<ClassInfo> allClassInfo;
    private final Map<String, ClassLoader[]> classNameToClassLoaders = new HashMap<String, ClassLoader[]>();

    ClassGraphBuilder(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo) {
        this.scanSpec = scanSpec;
        this.classNameToClassInfo = classNameToClassInfo;
        this.allClassInfo = new HashSet<ClassInfo>(classNameToClassInfo.values());
        for (ClassInfo classInfo : this.allClassInfo) {
            ClassLoader[] classLoaders = classInfo.getClassLoaders();
            if (classLoaders == null) continue;
            this.classNameToClassLoaders.put(classInfo.getClassName(), classLoaders);
        }
    }

    Map<String, ClassInfo> getClassNameToClassInfo() {
        return this.classNameToClassInfo;
    }

    public Map<String, ClassLoader[]> getClassNameToClassLoaders() {
        return this.classNameToClassLoaders;
    }

    List<String> getNamesOfAllClasses() {
        return ClassInfo.getNamesOfAllClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfAllStandardClasses() {
        return ClassInfo.getNamesOfAllStandardClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfSubclassesOf(String className) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSubclasses();
    }

    List<String> getNamesOfSuperclassesOf(String className) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSuperclasses();
    }

    List<String> getNamesOfClassesWithMethodAnnotation(String annotationName) {
        return ClassInfo.getNamesOfClassesWithMethodAnnotation(annotationName, this.allClassInfo);
    }

    List<String> getNamesOfClassesWithFieldAnnotation(String annotationName) {
        return ClassInfo.getNamesOfClassesWithFieldAnnotation(annotationName, this.allClassInfo);
    }

    List<String> getNamesOfAllInterfaceClasses() {
        return ClassInfo.getNamesOfAllInterfaceClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSubinterfaces();
    }

    List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSuperinterfaces();
    }

    List<String> getNamesOfClassesImplementing(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfClassesImplementing();
    }

    List<String> getNamesOfAllAnnotationClasses() {
        return ClassInfo.getNamesOfAllAnnotationClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfClassesWithAnnotation();
    }

    List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceOrAnnotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(classOrInterfaceOrAnnotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfAnnotations();
    }

    List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfMetaAnnotations();
    }

    List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(metaAnnotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfAnnotationsWithMetaAnnotation();
    }

    private static String label(ClassInfo node) {
        String className = node.getClassName();
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return className;
        }
        return className.substring(0, dotIdx + 1) + "\\n" + className.substring(dotIdx + 1);
    }

    private List<ClassInfo> lookup(Set<String> classNames) {
        ArrayList<ClassInfo> classInfoNodes = new ArrayList<ClassInfo>();
        for (String className : classNames) {
            ClassInfo classInfo = this.classNameToClassInfo.get(className);
            if (classInfo == null) continue;
            classInfoNodes.add(classInfo);
        }
        return classInfoNodes;
    }

    String generateClassGraphDotFile(float sizeX, float sizeY) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        Set<ClassInfo> standardClassNodes = ClassInfo.filterClassInfo(this.allClassInfo, true, this.scanSpec, ClassInfo.ClassType.STANDARD_CLASS);
        Set<ClassInfo> interfaceNodes = ClassInfo.filterClassInfo(this.allClassInfo, true, this.scanSpec, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
        Set<ClassInfo> annotationNodes = ClassInfo.filterClassInfo(this.allClassInfo, true, this.scanSpec, ClassInfo.ClassType.ANNOTATION);
        buf.append("\nnode[shape=box,style=filled,fillcolor=\"#fff2b6\"];\n");
        for (ClassInfo node : standardClassNodes) {
            if (node.getClassName().equals("java.lang.Object")) continue;
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=diamond,style=filled,fillcolor=\"#b6e7ff\"];\n");
        for (ClassInfo node : interfaceNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=oval,style=filled,fillcolor=\"#f3c9ff\"];\n");
        for (ClassInfo node : annotationNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\n");
        for (ClassInfo classNode : standardClassNodes) {
            ClassInfo directSuperclassNode = classNode.getDirectSuperclass();
            if (directSuperclassNode != null && !directSuperclassNode.getClassName().equals("java.lang.Object")) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(directSuperclassNode) + "\"\n");
            }
            for (ClassInfo implementedInterfaceNode : classNode.getDirectlyImplementedInterfaces()) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(implementedInterfaceNode) + "\" [arrowhead=diamond]\n");
            }
            for (ClassInfo fieldTypeNode : this.lookup(classNode.getClassNamesReferencedInFieldTypeDescriptors())) {
                buf.append("  \"" + ClassGraphBuilder.label(fieldTypeNode) + "\" -> \"" + ClassGraphBuilder.label(classNode) + "\" [arrowtail=obox, dir=back]\n");
            }
            for (ClassInfo fieldTypeNode : this.lookup(classNode.getClassNamesReferencedInMethodTypeDescriptors())) {
                buf.append("  \"" + ClassGraphBuilder.label(fieldTypeNode) + "\" -> \"" + ClassGraphBuilder.label(classNode) + "\" [arrowtail=box, dir=back]\n");
            }
        }
        for (ClassInfo interfaceNode : interfaceNodes) {
            for (ClassInfo superinterfaceNode : interfaceNode.getDirectSuperinterfaces()) {
                buf.append("  \"" + ClassGraphBuilder.label(interfaceNode) + "\" -> \"" + ClassGraphBuilder.label(superinterfaceNode) + "\" [arrowhead=diamond]\n");
            }
        }
        for (ClassInfo annotationNode : annotationNodes) {
            for (ClassInfo annotatedClassNode : annotationNode.getClassesWithDirectAnnotation()) {
                buf.append("  \"" + ClassGraphBuilder.label(annotatedClassNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=dot]\n");
            }
            for (ClassInfo annotatedClassNode : annotationNode.getAnnotationsWithDirectMetaAnnotation()) {
                buf.append("  \"" + ClassGraphBuilder.label(annotatedClassNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=dot]\n");
            }
            for (ClassInfo classWithMethodAnnotationNode : annotationNode.getClassesWithDirectMethodAnnotation()) {
                buf.append("  \"" + ClassGraphBuilder.label(classWithMethodAnnotationNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=odot]\n");
            }
            for (ClassInfo classWithMethodAnnotationNode : annotationNode.getClassesWithFieldAnnotation()) {
                buf.append("  \"" + ClassGraphBuilder.label(classWithMethodAnnotationNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=odot]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

