/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.nativekey;

public enum AndroidKey {
    UNKNOWN(0),
    SOFT_LEFT(1),
    SOFT_RIGHT(2),
    HOME(3),
    BACK(4),
    CALL(5),
    ENDCALL(6),
    DIGIT_0(7),
    DIGIT_1(8),
    DIGIT_2(9),
    DIGIT_3(10),
    DIGIT_4(11),
    DIGIT_5(12),
    DIGIT_6(13),
    DIGIT_7(14),
    DIGIT_8(15),
    DIGIT_9(16),
    STAR(17),
    POUND(18),
    DPAD_UP(19),
    DPAD_DOWN(20),
    DPAD_LEFT(21),
    DPAD_RIGHT(22),
    DPAD_CENTER(23),
    VOLUME_UP(24),
    VOLUME_DOWN(25),
    POWER(26),
    CAMERA(27),
    CLEAR(28),
    A(29),
    B(30),
    C(31),
    D(32),
    E(33),
    F(34),
    G(35),
    H(36),
    I(37),
    J(38),
    K(39),
    L(40),
    M(41),
    N(42),
    O(43),
    P(44),
    Q(45),
    R(46),
    S(47),
    T(48),
    U(49),
    V(50),
    W(51),
    X(52),
    Y(53),
    Z(54),
    COMMA(55),
    PERIOD(56),
    ALT_LEFT(57),
    ALT_RIGHT(58),
    SHIFT_LEFT(59),
    SHIFT_RIGHT(60),
    TAB(61),
    SPACE(62),
    SYM(63),
    EXPLORER(64),
    ENVELOPE(65),
    ENTER(66),
    DEL(67),
    GRAVE(68),
    MINUS(69),
    EQUALS(70),
    LEFT_BRACKET(71),
    RIGHT_BRACKET(72),
    BACKSLASH(73),
    SEMICOLON(74),
    APOSTROPHE(75),
    SLASH(76),
    AT(77),
    NUM(78),
    HEADSETHOOK(79),
    FOCUS(80),
    PLUS(81),
    MENU(82),
    NOTIFICATION(83),
    SEARCH(84),
    MEDIA_PLAY_PAUSE(85),
    MEDIA_STOP(86),
    MEDIA_NEXT(87),
    MEDIA_PREVIOUS(88),
    MEDIA_REWIND(89),
    MEDIA_FAST_FORWARD(90),
    MUTE(91),
    PAGE_UP(92),
    PAGE_DOWN(93),
    PICTSYMBOLS(94),
    SWITCH_CHARSET(95),
    BUTTON_A(96),
    BUTTON_B(97),
    BUTTON_C(98),
    BUTTON_X(99),
    BUTTON_Y(100),
    BUTTON_Z(101),
    BUTTON_L1(102),
    BUTTON_R1(103),
    BUTTON_L2(104),
    BUTTON_R2(105),
    BUTTON_THUMBL(106),
    BUTTON_THUMBR(107),
    BUTTON_START(108),
    BUTTON_SELECT(109),
    BUTTON_MODE(110),
    ESCAPE(111),
    FORWARD_DEL(112),
    CTRL_LEFT(113),
    CTRL_RIGHT(114),
    CAPS_LOCK(115),
    SCROLL_LOCK(116),
    META_LEFT(117),
    META_RIGHT(118),
    FUNCTION(119),
    SYSRQ(120),
    BREAK(121),
    MOVE_HOME(122),
    MOVE_END(123),
    INSERT(124),
    FORWARD(125),
    MEDIA_PLAY(126),
    MEDIA_PAUSE(127),
    MEDIA_CLOSE(128),
    MEDIA_EJECT(129),
    MEDIA_RECORD(130),
    F1(131),
    F2(132),
    F3(133),
    F4(134),
    F5(135),
    F6(136),
    F7(137),
    F8(138),
    F9(139),
    F10(140),
    F11(141),
    F12(142),
    NUM_LOCK(143),
    NUMPAD_0(144),
    NUMPAD_1(145),
    NUMPAD_2(146),
    NUMPAD_3(147),
    NUMPAD_4(148),
    NUMPAD_5(149),
    NUMPAD_6(150),
    NUMPAD_7(151),
    NUMPAD_8(152),
    NUMPAD_9(153),
    NUMPAD_DIVIDE(154),
    NUMPAD_MULTIPLY(155),
    NUMPAD_SUBTRACT(156),
    NUMPAD_ADD(157),
    NUMPAD_DOT(158),
    NUMPAD_COMMA(159),
    NUMPAD_ENTER(160),
    NUMPAD_EQUALS(161),
    NUMPAD_LEFT_PAREN(162),
    NUMPAD_RIGHT_PAREN(163),
    VOLUME_MUTE(164),
    INFO(165),
    CHANNEL_UP(166),
    CHANNEL_DOWN(167),
    KEYCODE_ZOOM_IN(168),
    KEYCODE_ZOOM_OUT(169),
    TV(170),
    WINDOW(171),
    GUIDE(172),
    DVR(173),
    BOOKMARK(174),
    CAPTIONS(175),
    SETTINGS(176),
    TV_POWER(177),
    TV_INPUT(178),
    STB_POWER(179),
    STB_INPUT(180),
    AVR_POWER(181),
    AVR_INPUT(182),
    PROG_RED(183),
    PROG_GREEN(184),
    PROG_YELLOW(185),
    PROG_BLUE(186),
    APP_SWITCH(187),
    BUTTON_1(188),
    BUTTON_2(189),
    BUTTON_3(190),
    BUTTON_4(191),
    BUTTON_5(192),
    BUTTON_6(193),
    BUTTON_7(194),
    BUTTON_8(195),
    BUTTON_9(196),
    BUTTON_10(197),
    BUTTON_11(198),
    BUTTON_12(199),
    BUTTON_13(200),
    BUTTON_14(201),
    BUTTON_15(202),
    BUTTON_16(203),
    LANGUAGE_SWITCH(204),
    MANNER_MODE(205),
    MODE_3D(206),
    CONTACTS(207),
    CALENDAR(208),
    MUSIC(209),
    CALCULATOR(210),
    ZENKAKU_HANKAKU(211),
    EISU(212),
    MUHENKAN(213),
    HENKAN(214),
    KATAKANA_HIRAGANA(215),
    YEN(216),
    RO(217),
    KANA(218),
    ASSIST(219),
    BRIGHTNESS_DOWN(220),
    BRIGHTNESS_UP(221),
    MEDIA_AUDIO_TRACK(222),
    SLEEP(223),
    WAKEUP(224),
    PAIRING(225),
    MEDIA_TOP_MENU(226),
    KEY_11(227),
    KEY_12(228),
    LAST_CHANNEL(229),
    TV_DATA_SERVICE(230),
    VOICE_ASSIST(231),
    TV_RADIO_SERVICE(232),
    TV_TELETEXT(233),
    TV_NUMBER_ENTRY(234),
    TV_TERRESTRIAL_ANALOG(235),
    TV_TERRESTRIAL_DIGITAL(236),
    TV_SATELLITE(237),
    TV_SATELLITE_BS(238),
    TV_SATELLITE_CS(239),
    TV_SATELLITE_SERVICE(240),
    TV_NETWORK(241),
    TV_ANTENNA_CABLE(242),
    TV_INPUT_HDMI_1(243),
    TV_INPUT_HDMI_2(244),
    TV_INPUT_HDMI_3(245),
    TV_INPUT_HDMI_4(246),
    TV_INPUT_COMPOSITE_1(247),
    TV_INPUT_COMPOSITE_2(248),
    TV_INPUT_COMPONENT_1(249),
    TV_INPUT_COMPONENT_2(250),
    TV_INPUT_VGA_1(251),
    TV_AUDIO_DESCRIPTION(252),
    TV_AUDIO_DESCRIPTION_MIX_UP(253),
    TV_AUDIO_DESCRIPTION_MIX_DOWN(254),
    TV_ZOOM_MODE(255),
    TV_CONTENTS_MENU(256),
    TV_MEDIA_CONTEXT_MENU(257),
    TV_TIMER_PROGRAMMING(258),
    HELP(259),
    NAVIGATE_PREVIOUS(260),
    NAVIGATE_NEXT(261),
    NAVIGATE_IN(262),
    NAVIGATE_OUT(263),
    STEM_PRIMARY(264),
    STEM_1(265),
    STEM_2(266),
    STEM_3(267),
    DPAD_UP_LEFT(268),
    DPAD_DOWN_LEFT(269),
    DPAD_UP_RIGHT(270),
    DPAD_DOWN_RIGHT(271),
    MEDIA_SKIP_FORWARD(272),
    MEDIA_SKIP_BACKWARD(273),
    MEDIA_STEP_FORWARD(274),
    MEDIA_STEP_BACKWARD(275),
    SOFT_SLEEP(276),
    CUT(277),
    COPY(278),
    PASTE(279);

    private final int code;

    private AndroidKey(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isGamepadButton() {
        switch (this) {
            case BUTTON_A: 
            case BUTTON_B: 
            case BUTTON_C: 
            case BUTTON_X: 
            case BUTTON_Y: 
            case BUTTON_Z: 
            case BUTTON_L1: 
            case BUTTON_R1: 
            case BUTTON_L2: 
            case BUTTON_R2: 
            case BUTTON_THUMBL: 
            case BUTTON_THUMBR: 
            case BUTTON_START: 
            case BUTTON_SELECT: 
            case BUTTON_MODE: 
            case BUTTON_1: 
            case BUTTON_2: 
            case BUTTON_3: 
            case BUTTON_4: 
            case BUTTON_5: 
            case BUTTON_6: 
            case BUTTON_7: 
            case BUTTON_8: 
            case BUTTON_9: 
            case BUTTON_10: 
            case BUTTON_11: 
            case BUTTON_12: 
            case BUTTON_13: 
            case BUTTON_14: 
            case BUTTON_15: 
            case BUTTON_16: {
                return true;
            }
        }
        return false;
    }

    public boolean isConfirmKey() {
        switch (this) {
            case DPAD_CENTER: 
            case SPACE: 
            case ENTER: 
            case NUMPAD_ENTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isMediaKey() {
        switch (this) {
            case HEADSETHOOK: 
            case MEDIA_PLAY_PAUSE: 
            case MEDIA_STOP: 
            case MEDIA_NEXT: 
            case MEDIA_PREVIOUS: 
            case MEDIA_REWIND: 
            case MEDIA_FAST_FORWARD: 
            case MUTE: 
            case MEDIA_PLAY: 
            case MEDIA_PAUSE: 
            case MEDIA_RECORD: {
                return true;
            }
        }
        return false;
    }

    public boolean isSystemKey() {
        switch (this) {
            case SOFT_RIGHT: 
            case HOME: 
            case BACK: 
            case CALL: 
            case ENDCALL: 
            case VOLUME_UP: 
            case VOLUME_DOWN: 
            case POWER: 
            case CAMERA: 
            case HEADSETHOOK: 
            case FOCUS: 
            case MENU: 
            case SEARCH: 
            case MEDIA_PLAY_PAUSE: 
            case MEDIA_STOP: 
            case MEDIA_NEXT: 
            case MEDIA_PREVIOUS: 
            case MEDIA_REWIND: 
            case MEDIA_FAST_FORWARD: 
            case MUTE: 
            case MEDIA_PLAY: 
            case MEDIA_PAUSE: 
            case MEDIA_RECORD: 
            case VOLUME_MUTE: 
            case BRIGHTNESS_DOWN: 
            case BRIGHTNESS_UP: 
            case MEDIA_AUDIO_TRACK: {
                return true;
            }
        }
        return false;
    }

    public boolean isWakeKey() {
        switch (this) {
            case BACK: 
            case MENU: 
            case WAKEUP: 
            case PAIRING: 
            case STEM_1: 
            case STEM_2: 
            case STEM_3: {
                return true;
            }
        }
        return false;
    }
}

