/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.clipboard.ClipboardContentType;
import io.appium.java_client.clipboard.HasClipboard;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;

public interface HasAndroidClipboard
extends HasClipboard {
    default public void setClipboard(String label, ClipboardContentType contentType, byte[] base64Content) {
        String[] parameters = new String[]{"content", "contentType", "label"};
        Object[] values = new Object[]{new String((byte[])Preconditions.checkNotNull((Object)base64Content), StandardCharsets.UTF_8), contentType.name().toLowerCase(), Preconditions.checkNotNull((Object)label)};
        CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(MobileCommand.SET_CLIPBOARD, MobileCommand.prepareArguments(parameters, values)));
    }

    default public void setClipboardText(String label, String text) {
        this.setClipboard(label, ClipboardContentType.PLAINTEXT, Base64.getEncoder().encode(text.getBytes(StandardCharsets.UTF_8)));
    }
}

