/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.IntegrityHmac;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Logger log = Logger.getLogger(SignatureAlgorithm.class.getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    static ThreadLocal instancesSigning = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal instancesVerify = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal keysSigning = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal keysVerify = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    private String algorithmURI;

    public SignatureAlgorithm(Document document, String string) throws XMLSecurityException {
        super(document, string);
        this.algorithmURI = string;
    }

    private void initializeAlgorithm(boolean bl) throws XMLSignatureException {
        if (this._signatureAlgorithm != null) {
            return;
        }
        this._signatureAlgorithm = bl ? SignatureAlgorithm.getInstanceForSigning(this.algorithmURI) : SignatureAlgorithm.getInstanceForVerify(this.algorithmURI);
        this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
    }

    private static SignatureAlgorithmSpi getInstanceForSigning(String string) throws XMLSignatureException {
        SignatureAlgorithmSpi signatureAlgorithmSpi = (SignatureAlgorithmSpi)((Map)instancesSigning.get()).get(string);
        if (signatureAlgorithmSpi != null) {
            signatureAlgorithmSpi.reset();
            return signatureAlgorithmSpi;
        }
        signatureAlgorithmSpi = SignatureAlgorithm.buildSigner(string, signatureAlgorithmSpi);
        ((Map)instancesSigning.get()).put(string, signatureAlgorithmSpi);
        return signatureAlgorithmSpi;
    }

    private static SignatureAlgorithmSpi getInstanceForVerify(String string) throws XMLSignatureException {
        SignatureAlgorithmSpi signatureAlgorithmSpi = (SignatureAlgorithmSpi)((Map)instancesVerify.get()).get(string);
        if (signatureAlgorithmSpi != null) {
            signatureAlgorithmSpi.reset();
            return signatureAlgorithmSpi;
        }
        signatureAlgorithmSpi = SignatureAlgorithm.buildSigner(string, signatureAlgorithmSpi);
        ((Map)instancesVerify.get()).put(string, signatureAlgorithmSpi);
        return signatureAlgorithmSpi;
    }

    private static SignatureAlgorithmSpi buildSigner(String string, SignatureAlgorithmSpi signatureAlgorithmSpi) throws XMLSignatureException {
        try {
            Class clazz = SignatureAlgorithm.getImplementingClass(string);
            log.log(Level.FINE, "Create URI \"" + string + "\" class \"" + clazz + "\"");
            signatureAlgorithmSpi = (SignatureAlgorithmSpi)clazz.newInstance();
            return signatureAlgorithmSpi;
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public SignatureAlgorithm(Document document, String string, int n) throws XMLSecurityException {
        this(document, string);
        this.algorithmURI = string;
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineSetHMACOutputLength(n);
        ((IntegrityHmac)this._signatureAlgorithm).engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String string) throws XMLSecurityException {
        super(element, string);
        this.algorithmURI = this.getURI();
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        try {
            return SignatureAlgorithm.getInstanceForVerify(this.algorithmURI).engineGetJCEAlgorithmString();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public String getJCEProviderName() {
        try {
            return SignatureAlgorithm.getInstanceForVerify(this.algorithmURI).engineGetJCEProviderName();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray);
    }

    public void update(byte by) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray, n, n2);
    }

    public void initSign(Key key) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        Map map = (Map)keysSigning.get();
        if (map.get(this.algorithmURI) == key) {
            return;
        }
        map.put(this.algorithmURI, key);
        this._signatureAlgorithm.engineInitSign(key);
    }

    public void initSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineInitSign(key, secureRandom);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineInitSign(key, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(algorithmParameterSpec);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        this.initializeAlgorithm(false);
        Map map = (Map)keysVerify.get();
        if (map.get(this.algorithmURI) == key) {
            return;
        }
        map.put(this.algorithmURI, key);
        this._signatureAlgorithm.engineInitVerify(key);
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(byArray);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (log == null) {
            log = Logger.getLogger(SignatureAlgorithm.class.getName());
        }
        log.log(Level.FINE, "Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException, XMLSignatureException {
        String string3;
        log.log(Level.FINE, "Try to register " + string + " " + string2);
        Class clazz = SignatureAlgorithm.getImplementingClass(string);
        if (clazz != null && (string3 = clazz.getName()) != null && string3.length() != 0) {
            Object[] objectArray = new Object[]{string, string3};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _algorithmHash.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    private static Class getImplementingClass(String string) {
        if (_algorithmHash == null) {
            return null;
        }
        return (Class)_algorithmHash.get(string);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }
}

