/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider;
import com.sun.xml.wss.provider.wsit.WSITServerAuthContext;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;

public class WSITServerAuthConfig
implements ServerAuthConfig {
    private String layer = null;
    private String appContext = null;
    private CallbackHandler callbackHandler = null;
    private WSITServerAuthContext serverAuthContext = null;
    private PolicyMap policyMap = null;
    private String secDisabled = null;
    private ReentrantReadWriteLock rwLock;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public WSITServerAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) {
        this.layer = layer;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAuthContext getAuthContext(String operation, Subject subject, Map map) throws AuthException {
        PolicyMap pMap = (PolicyMap)map.get("POLICY");
        WSDLPort port = (WSDLPort)map.get("WSDL_MODEL");
        if (pMap == null || pMap.isEmpty()) {
            return null;
        }
        if (this.secDisabled == null || this.policyMap != pMap) {
            this.wLock.lock();
            try {
                if (this.secDisabled == null || this.policyMap != pMap) {
                    if (!WSITAuthConfigProvider.isSecurityEnabled(pMap, port)) {
                        this.secDisabled = TRUE;
                        ServerAuthContext serverAuthContext = null;
                        return serverAuthContext;
                    }
                    this.secDisabled = FALSE;
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
        if (this.secDisabled == TRUE) {
            return null;
        }
        this.rLock.lock();
        try {
            if (this.serverAuthContext != null && this.policyMap == pMap) {
                WSITServerAuthContext wSITServerAuthContext = this.serverAuthContext;
                return wSITServerAuthContext;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            if (this.serverAuthContext == null || this.policyMap != pMap) {
                this.serverAuthContext = new WSITServerAuthContext(operation, subject, map, this.callbackHandler);
                this.policyMap = pMap;
            }
            WSITServerAuthContext wSITServerAuthContext = this.serverAuthContext;
            return wSITServerAuthContext;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getOperation(MessageInfo messageInfo) {
        return null;
    }

    public void refresh() {
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return null;
    }

    public boolean isProtected() {
        return true;
    }
}

