/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.tx.Participant;
import com.sun.xml.ws.api.tx.Protocol;
import com.sun.xml.ws.api.tx.TXException;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.at.LocalizationMessages;
import com.sun.xml.ws.tx.common.AddressManager;
import com.sun.xml.ws.tx.common.StatefulWebserviceFactory;
import com.sun.xml.ws.tx.common.StatefulWebserviceFactoryFactory;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import com.sun.xml.ws.tx.coordinator.Registrant;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortTypeImpl;
import com.sun.xml.ws.tx.webservice.member.at.ParticipantPortType;
import com.sun.xml.ws.tx.webservice.member.at.ParticipantPortTypeImpl;
import com.sun.xml.ws.tx.webservice.member.coord.RegisterType;
import java.net.URI;
import java.util.logging.Level;
import javax.transaction.xa.Xid;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

public class ATParticipant
extends Registrant {
    public static final URI LOCAL_PPS_URI = AddressManager.getPreferredAddress(ParticipantPortType.class);
    protected STATE state = STATE.NONE;
    protected Xid xid;
    private Participant participant = null;
    private final boolean remoteParticipant;
    private static TxLogger logger = TxLogger.getATLogger(ATParticipant.class);
    static final String WSAT_COORDINATOR = "WSATCoordinator";
    private EndpointReference localParticipantProtocolService = null;

    private EndpointReference exportCoordinatorProtocolServiceForATParticipant(Coordinator coord) {
        return StatefulWebserviceFactoryFactory.getInstance().createService(WSAT_COORDINATOR, "Coordinator", ATCoordinator.localCoordinationProtocolServiceURI, AddressingVersion.MEMBER, coord.getIdValue(), this.getIdValue(), coord.getExpires());
    }

    public ATParticipant(Coordinator parent, Participant participant) {
        super(parent, participant.getProtocol());
        this.participant = participant;
        this.remoteParticipant = false;
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("ATParticipant", this.getCoordIdPartId());
        }
    }

    public ATParticipant(Coordinator parent, RegisterType registerRequest) {
        super(parent, registerRequest);
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("Remote ATParticipant", this.getCoordIdPartId());
        }
        this.participant = null;
        this.setCoordinatorProtocolService(this.exportCoordinatorProtocolServiceForATParticipant(parent));
        this.remoteParticipant = true;
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("Remote ATParticipant:", this.getCoordIdPartId() + " CPS:" + this.getCoordinatorProtocolService());
        }
    }

    public ParticipantPortType getParticipantPort(EndpointReference epr) {
        return ATCoordinator.getWSATCoordinatorService().getParticipant(epr, new WebServiceFeature[0]);
    }

    public boolean isVolatile() {
        return this.getProtocol() == Protocol.VOLATILE;
    }

    public boolean isDurable() {
        return this.getProtocol() == Protocol.DURABLE;
    }

    public void forget() {
        CoordinatorPortTypeImpl cpti;
        ParticipantPortTypeImpl ppti;
        if (this.isRemoteCPS() && this.localParticipantProtocolService != null && (ppti = (ParticipantPortTypeImpl)ParticipantPortTypeImpl.getManager().resolve(this.localParticipantProtocolService)) != null) {
            ParticipantPortTypeImpl.getManager().unexport((Object)ppti);
        }
        this.localParticipantProtocolService = null;
        if (this.remoteParticipant && (cpti = (CoordinatorPortTypeImpl)CoordinatorPortTypeImpl.getManager().resolve(this.getCoordinatorProtocolService())) != null) {
            CoordinatorPortTypeImpl.getManager().unexport((Object)cpti);
        }
        this.getATCoordinator().forget(this);
    }

    private CoordinatorPortType getATCoordinatorWS(boolean nonterminalNotify) {
        if (this.getCoordinatorProtocolService() == null && !this.isRegistrationCompleted()) {
            logger.warning("getATCoordinatorWS", LocalizationMessages.NO_REG_RESP_0014(this.getATCoordinator().getContext().getRootRegistrationService().toString(), this.getCoordIdPartId()));
        }
        return ATParticipant.getATCoordinatorWS(this.getCoordinatorProtocolService(), this.getParticipantProtocolService(), nonterminalNotify);
    }

    public static CoordinatorPortType getATCoordinatorWS(EndpointReference toCPS, EndpointReference replyToPPS, boolean nonterminalNotify) {
        OneWayFeature owf = new OneWayFeature();
        WSEndpointReference wsepr = null;
        if (nonterminalNotify && replyToPPS != null) {
            try {
                wsepr = new WSEndpointReference(replyToPPS);
            }
            catch (Exception xse) {
                logger.severe("getATCoordinatorWS", LocalizationMessages.REPLYTOPPS_EPR_EXCEPTION_0015(replyToPPS.toString(), xse.getLocalizedMessage()));
            }
            if (wsepr != null) {
                owf.setReplyTo(wsepr);
            } else {
                logger.warning("getATCoordinatorWS", LocalizationMessages.NULL_PPS_EPR_WARNING_0016());
            }
        }
        assert (toCPS != null);
        return ATCoordinator.getWSATCoordinatorService().getCoordinator(toCPS, new WebServiceFeature[]{owf});
    }

    private ParticipantPortType getATParticipantWS(boolean nonterminalNotification) {
        return ATParticipant.getATParticipantWS(this.getParticipantProtocolService(), this.getCoordinatorProtocolService(), nonterminalNotification);
    }

    public static ParticipantPortType getATParticipantWS(EndpointReference toPPS, EndpointReference replyToCPS, boolean nonterminalNotification) {
        OneWayFeature owf = new OneWayFeature();
        WSEndpointReference wsepr = null;
        if (nonterminalNotification && replyToCPS != null) {
            try {
                wsepr = new WSEndpointReference(replyToCPS);
            }
            catch (Exception xse) {
                logger.severe("getATCoordinatorWS", LocalizationMessages.REPLYTOPPS_EPR_EXCEPTION_0015(replyToCPS.toString(), xse.getLocalizedMessage()));
            }
            if (wsepr != null) {
                owf.setReplyTo(wsepr);
            } else {
                logger.warning("getATParticipantWS", LocalizationMessages.NULL_CPS_EPR_WARNING_0018());
            }
        }
        assert (toPPS != null);
        return ATCoordinator.getWSATCoordinatorService().getParticipant(toPPS, new WebServiceFeature[]{owf});
    }

    public ATCoordinator getATCoordinator() {
        return (ATCoordinator)this.getCoordinator();
    }

    public STATE getState() {
        return this.state;
    }

    protected Xid getXid() {
        return this.xid;
    }

    public void prepare() throws TXException {
        String METHOD_NAME = "prepare";
        if (logger.isLogging(Level.FINER)) {
            logger.entering("prepare", "coordId=" + this.getCoordinator().getIdValue() + " partId=" + this.getIdValue());
        }
        switch (this.getState()) {
            case NONE: 
            case ABORTING: {
                this.abort();
                throw new TXException("Rollback");
            }
            case ACTIVE: {
                this.internalPrepare();
                break;
            }
            case PREPARED_SUCCESS: {
                if (this.isRemoteCPS()) {
                    try {
                        this.getATCoordinatorWS(true).preparedOperation(null);
                        break;
                    }
                    catch (WebServiceException wse) {
                        logger.warning("prepare", LocalizationMessages.PREPARE_FAILED_0010(wse.getLocalizedMessage()));
                        throw wse;
                    }
                    catch (Exception e) {
                        logger.severe("prepare", LocalizationMessages.PREPARE_FAILED_0010(e.getLocalizedMessage()));
                        break;
                    }
                }
                this.getATCoordinator().prepared(this.getIdValue());
                break;
            }
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("prepare", "coordId=" + this.getCoordinator().getIdValue() + " partId=" + this.getIdValue());
        }
    }

    private void internalPrepare() throws TXException {
        if (this.remoteParticipant) {
            this.remotePrepare();
        } else {
            this.localPrepare();
        }
    }

    private void remotePrepare() {
        this.state = STATE.PREPARING;
        try {
            this.getATParticipantWS(true).prepareOperation(null);
        }
        catch (WebServiceException wse) {
            logger.warning("remotePrepare", LocalizationMessages.PREPARE_FAILED_0010(wse.getLocalizedMessage()));
            throw wse;
        }
        catch (Exception e) {
            logger.severe("remotePrepare", LocalizationMessages.PREPARE_FAILED_0010(e.getLocalizedMessage()));
        }
    }

    private void localPrepare() throws TXException {
        String METHOD_NAME = "localPrepare";
        if (logger.isLogging(Level.FINER)) {
            logger.entering("localPrepare", this.getCoordIdPartId());
        }
        Participant.STATE result = null;
        this.state = STATE.PREPARING;
        try {
            result = this.participant.prepare();
        }
        catch (TXException e) {
            this.participant = null;
            this.abort();
            throw new TXException("Rollback");
        }
        catch (Exception e) {
            this.participant = null;
            this.abort();
            throw new TXException("Rollback");
        }
        switch (result) {
            case P_OK: {
                this.state = STATE.PREPARED;
                if (this.isRemoteCPS()) {
                    if (logger.isLogging(Level.FINEST)) {
                        logger.finest("localPrepare", "send prepared to remote coordinator" + this.getIdValue());
                    }
                    try {
                        this.getATCoordinatorWS(true).preparedOperation(null);
                    }
                    catch (WebServiceException wse) {
                        logger.warning("localPrepare", LocalizationMessages.PREPARE_FAILED_0010(wse.getLocalizedMessage()));
                        throw wse;
                    }
                } else {
                    if (logger.isLogging(Level.FINEST)) {
                        logger.finest("localPrepare", "send prepared to local coordinator" + this.getIdValue());
                    }
                    this.getATCoordinator().prepared(this.getIdValue());
                }
                this.state = STATE.PREPARED_SUCCESS;
                break;
            }
            case P_READONLY: {
                this.state = STATE.READONLY;
                if (this.isRemoteCPS()) {
                    if (logger.isLogging(Level.FINEST)) {
                        logger.finest("localPrepare", "send readonly to remote coordinator for participant id" + this.getIdValue());
                    }
                    try {
                        this.getATCoordinatorWS(false).readOnlyOperation(null);
                    }
                    catch (WebServiceException wse) {
                        logger.warning("localPrepare", "readonly to web service failed. " + wse.getLocalizedMessage());
                        throw wse;
                    }
                } else {
                    if (logger.isLogging(Level.FINEST)) {
                        logger.finest("localPrepare", "send readonly to remote coordinator for participant id" + this.getIdValue());
                    }
                    this.getATCoordinator().readonly(this.getIdValue());
                }
                if (logger.isLogging(Level.FINE)) {
                    logger.fine("localPrepare", "readonly " + this.getCoordIdPartId());
                }
                this.forget();
            }
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("ATParticipant.localPrepare");
        }
    }

    private void remoteCommit() {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("remoteCommit()", this.getIdValue());
        }
        this.getATParticipantWS(true).commitOperation(null);
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("remoteCommit");
        }
    }

    public void commit() throws TXException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("commit" + this.getCoordIdPartId());
        }
        if (this.remoteParticipant) {
            this.remoteCommit();
        } else {
            this.localCommit();
        }
        if (logger.isLogging(Level.FINER)) {
            logger.entering("commit" + this.getCoordIdPartId());
        }
    }

    private void localCommit() {
        String METHOD_NAME = "localCommit";
        switch (this.getState()) {
            case NONE: {
                break;
            }
            case ABORTING: {
                logger.warning("localCommit", LocalizationMessages.INCONSISTENT_STATE_0020((Object)this.getState(), this.getCoordIdPartId()));
                this.abort();
                break;
            }
            case ACTIVE: 
            case PREPARING: 
            case PREPARED: {
                logger.warning("localCommit", LocalizationMessages.INCONSISTENT_STATE_0020((Object)this.getState(), this.getCoordIdPartId()));
                this.abort();
                break;
            }
            case PREPARED_SUCCESS: {
                this.state = STATE.COMMITTING;
                this.participant.commit();
                this.participant = null;
                if (logger.isLogging(Level.FINE)) {
                    logger.fine("localCommit", "committed " + this.getCoordIdPartId());
                }
                if (this.isRemoteCPS()) {
                    try {
                        this.getATCoordinatorWS(false).committedOperation(null);
                    }
                    catch (WebServiceException wse) {
                        logger.warning("localCommit", LocalizationMessages.COMMITTED_FAILED_0021(wse.getLocalizedMessage()));
                        throw wse;
                    }
                } else {
                    this.getATCoordinator().committed(this.getIdValue());
                }
                this.forget();
                break;
            }
            case COMMITTING: {
                if (this.isRemoteCPS()) {
                    this.getATCoordinatorWS(false).committedOperation(null);
                } else {
                    this.getATCoordinator().committed(this.getIdValue());
                }
                this.forget();
            }
        }
    }

    public void abort() {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("abort", this.getCoordIdPartId());
        }
        this.state = STATE.ABORTING;
        if (this.participant != null) {
            this.participant.abort();
            this.participant = null;
        }
        if (this.remoteParticipant) {
            this.remoteRollback();
        } else {
            this.localRollback();
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("abort", this.getCoordIdPartId());
        }
    }

    private void localRollback() {
        if (this.isRemoteCPS()) {
            try {
                this.getATCoordinatorWS(false).abortedOperation(null);
            }
            catch (WebServiceException wse) {
                logger.warning("localRollback", LocalizationMessages.PREPARED_FAILED_0019(wse.getLocalizedMessage()));
                throw wse;
            }
        } else {
            this.getATCoordinator().aborted(this.getIdValue());
        }
        if (logger.isLogging(Level.FINE)) {
            logger.fine("abort", this.getCoordIdPartId());
        }
        this.forget();
    }

    private void remoteRollback() {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("remoteRollack", this.getCoordIdPartId());
        }
        this.getATParticipantWS(true).rollbackOperation(null);
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("remoteRollback", this.getCoordIdPartId());
        }
    }

    public void setCoordinatorProtocolService(EndpointReference cps) {
        super.setCoordinatorProtocolService(cps);
        if (cps != null) {
            this.state = STATE.ACTIVE;
        }
    }

    void prepared() {
        this.state = STATE.PREPARED_SUCCESS;
        if (logger.isLogging(Level.FINE)) {
            logger.fine("prepared", this.getCoordIdPartId() + " STATE=" + this.state.toString());
        }
    }

    void committed() {
        this.state = STATE.COMMITTED;
        if (logger.isLogging(Level.FINE)) {
            logger.fine("committed", this.getCoordIdPartId() + " STATE=" + this.state.toString());
        }
    }

    void readonly() {
        this.state = STATE.READONLY;
        if (logger.isLogging(Level.FINE)) {
            logger.fine("readonly", this.getCoordIdPartId() + " STATE=" + this.state.toString());
        }
    }

    void aborted() {
        this.state = STATE.ABORTED;
        if (logger.isLogging(Level.FINE)) {
            logger.fine("aborted", this.getCoordIdPartId() + " STATE=" + this.state.toString());
        }
    }

    SOAPFault createSOAPFault(String message) {
        try {
            SOAPFault fault = SOAPVersion.SOAP_11.saajSoapFactory.createFault();
            fault.setFaultString(message);
            fault.appendFaultSubcode(new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "InconsistentInternalState"));
            fault.setFaultRole("A global consistent failure has occurred. This is an unrecoverable condition.");
            return fault;
        }
        catch (SOAPException ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    private String getCoordIdPartId() {
        return " coordId=" + this.getCoordinator().getIdValue() + " partId=" + this.getIdValue() + " ";
    }

    public EndpointReference getLocalParticipantProtocolService() {
        if (this.localParticipantProtocolService == null) {
            if (this.isRemoteCPS()) {
                StatefulWebserviceFactory swf = StatefulWebserviceFactoryFactory.getInstance();
                this.localParticipantProtocolService = swf.createService(WSAT_COORDINATOR, "Participant", LOCAL_PPS_URI, AddressingVersion.MEMBER, this.getATCoordinator().getIdValue(), this.getId().getValue(), this.getATCoordinator().getExpires());
            } else {
                this.localParticipantProtocolService = ATParticipant.getLocalParticipantProtocolServiceEPR();
            }
        }
        return this.localParticipantProtocolService;
    }

    public static EndpointReference getLocalParticipantProtocolServiceEPR() {
        MemberSubmissionEndpointReference epr = new MemberSubmissionEndpointReference();
        epr.addr = new MemberSubmissionEndpointReference.Address();
        epr.addr.uri = LOCAL_PPS_URI.toString();
        return epr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        NONE,
        ACTIVE,
        PREPARING,
        PREPARED,
        PREPARED_SUCCESS,
        COMMITTING,
        ABORTING,
        COMMITTED,
        ABORTED,
        READONLY;

    }
}

