/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

final class ProtocolCommunicator {
    private static final RmLogger LOGGER = RmLogger.getLogger(ProtocolCommunicator.class);
    final QName soapMustUnderstandAttributeName;
    private volatile Engine fiberEngine;
    private final ReadWriteLock fiberEngineLock = new ReentrantReadWriteLock();
    private final AtomicReference<Packet> musterRequestPacket;
    private final Tube tubeline;
    private final SecureConversationInitiator scInitiator;
    private final Configuration configuration;

    ProtocolCommunicator(Tube tubeline, SecureConversationInitiator scInitiator, Configuration configuration) {
        this.tubeline = tubeline;
        this.scInitiator = scInitiator;
        this.configuration = configuration;
        this.soapMustUnderstandAttributeName = new QName(configuration.getSoapVersion().nsUri, "mustUnderstand");
        this.musterRequestPacket = new AtomicReference();
    }

    void registerMusterRequestPacket(Packet muster) {
        this.musterRequestPacket.set(muster);
    }

    SecurityTokenReferenceType tryStartSecureConversation() {
        JAXBElement strElement = null;
        if (this.scInitiator != null) {
            try {
                strElement = this.scInitiator.startSecureConversation(this.musterRequestPacket.get().copy(false));
            }
            catch (WSSecureConversationException ex) {
                LOGGER.severe(LocalizationMessages.WSRM_1121_SECURE_CONVERSATION_INIT_FAILED(), ex);
            }
        }
        return strElement != null ? (SecurityTokenReferenceType)strElement.getValue() : null;
    }

    Packet send(Packet request) {
        Fiber fiber = this.getFiberEngine().createFiber();
        return fiber.runSync(this.tubeline, request);
    }

    WSEndpointReference getDestination() {
        Packet packet = this.musterRequestPacket.get();
        return packet != null ? new WSEndpointReference(packet.endpointAddress.toString(), this.configuration.getAddressingVersion()) : null;
    }

    Packet createEmptyRequestPacket() {
        return this.musterRequestPacket.get().copy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine getFiberEngine() {
        try {
            this.fiberEngineLock.readLock().lock();
            if (this.fiberEngine == null) {
                this.fiberEngineLock.readLock().unlock();
                try {
                    this.fiberEngineLock.writeLock().lock();
                    if (this.fiberEngine == null) {
                        this.fiberEngine = Fiber.current().owner;
                    }
                }
                finally {
                    this.fiberEngineLock.readLock().lock();
                    this.fiberEngineLock.writeLock().unlock();
                }
            }
            Engine engine = this.fiberEngine;
            return engine;
        }
        finally {
            this.fiberEngineLock.readLock().unlock();
        }
    }
}

