/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.rm.jaxws.runtime.MessageSender;
import com.sun.xml.ws.rm.jaxws.runtime.Sequence;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractSequence;
import com.sun.xml.ws.rm.protocol.AbstractSequenceAcknowledgement;

public final class RMMessage {
    private Message message;
    private Sequence sequence;
    private int messageNumber;
    private boolean isBusy;
    private boolean isComplete;
    private RMMessage relatedMessage;
    private AbstractSequence sequenceElement;
    private AbstractSequenceAcknowledgement sequenceAcknowledgementElement;
    private AbstractAckRequested ackRequestedElement;
    private boolean twoWayRequest;
    private boolean oneWayResponse;
    private MessageSender messageSender;

    public RMMessage(Message message) {
        this.message = message;
    }

    public RMMessage(Message message, boolean isOneWayResponse, boolean isTwoWayRequest) {
        this(message);
        this.oneWayResponse = isOneWayResponse;
        this.twoWayRequest = isTwoWayRequest;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public boolean isOneWayResponse() {
        return this.oneWayResponse;
    }

    public boolean isTwoWayRequest() {
        return this.twoWayRequest;
    }

    public void setMessageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public RMMessage getRelatedMessage() {
        return this.relatedMessage;
    }

    public void setRelatedMessage(RMMessage mess) {
        mess.copyContents();
        this.relatedMessage = mess;
    }

    public void setBusy(boolean value) {
        this.isBusy = value;
    }

    public HeaderList getHeaders() {
        return this.message == null || !this.message.hasHeaders() ? null : this.message.getHeaders();
    }

    public void addHeader(Header header) {
        this.message.getHeaders().add(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Sequence sequence = this.sequence;
        synchronized (sequence) {
            return this.isComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Sequence sequence = this.sequence;
        synchronized (sequence) {
            this.messageSender = null;
            this.message = null;
            this.isComplete = true;
            this.sequenceElement = null;
            this.sequenceAcknowledgementElement = null;
            this.ackRequestedElement = null;
        }
    }

    public synchronized void resume() {
        if (!this.isBusy && !this.isComplete() && this.messageSender != null) {
            this.messageSender.send();
        }
    }

    public Message getCopy() {
        return this.message == null ? null : this.message.copy();
    }

    public void copyContents() {
        if (this.message != null) {
            Message newMessage;
            this.message = newMessage = this.message.copy();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Message:\n\tmessageNumber = ").append(this.messageNumber).append('\n');
        buffer.append("\tSequence = ").append(this.sequence != null ? this.sequence.getId() : "null").append('\n');
        if (null != this.sequenceElement) {
            buffer.append(this.sequenceElement.toString());
        }
        if (null != this.sequenceAcknowledgementElement) {
            buffer.append(this.sequenceAcknowledgementElement.toString());
        }
        if (null != this.ackRequestedElement) {
            buffer.append(this.ackRequestedElement.toString());
        }
        return buffer.toString();
    }

    public AbstractSequenceAcknowledgement getSequenceAcknowledgementElement() {
        return this.sequenceAcknowledgementElement;
    }

    public void setSequenceAcknowledgementElement(AbstractSequenceAcknowledgement el) {
        this.sequenceAcknowledgementElement = el;
    }

    public AbstractSequence getSequenceElement() {
        return this.sequenceElement;
    }

    public void setSequenceElement(AbstractSequence el) {
        this.sequenceElement = el;
    }

    public AbstractAckRequested getAckRequestedElement() {
        return this.ackRequestedElement;
    }

    public void setAckRequestedElement(AbstractAckRequested el) {
        this.ackRequestedElement = el;
    }
}

