/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coordinator;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.tx.Protocol;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.developer.StatefulWebServiceManager;
import com.sun.xml.ws.tx.at.ATParticipant;
import com.sun.xml.ws.tx.common.ActivityIdentifier;
import com.sun.xml.ws.tx.common.AddressManager;
import com.sun.xml.ws.tx.common.StatefulWebserviceFactory;
import com.sun.xml.ws.tx.common.StatefulWebserviceFactoryFactory;
import com.sun.xml.ws.tx.common.TxFault;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.common.WsaHelper;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import com.sun.xml.ws.tx.coordinator.LocalizationMessages;
import com.sun.xml.ws.tx.coordinator.Registrant;
import com.sun.xml.ws.tx.webservice.member.coord.RegisterResponseType;
import com.sun.xml.ws.tx.webservice.member.coord.RegisterType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationCoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationPortTypeRPC;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationRequesterPortType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationRequesterPortTypeImpl;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

public final class RegistrationManager {
    private static final RegistrationManager instance = new RegistrationManager();
    private static final URI localRegistrationURI = AddressManager.getPreferredAddress(RegistrationPortTypeRPC.class);
    private static final URI localAsynchronousRegistrationURI = AddressManager.getPreferredAddress(RegistrationCoordinatorPortType.class);
    private static final URI localRegistrationRequesterURI = AddressManager.getPreferredAddress(RegistrationRequesterPortType.class);
    private static TxLogger logger = TxLogger.getCoordLogger(RegistrationManager.class);
    private static final CoordinationManager coordinationManager = CoordinationManager.getInstance();
    private static final com.sun.xml.ws.tx.webservice.member.coord.Coordinator coordinatorService = new com.sun.xml.ws.tx.webservice.member.coord.Coordinator();

    public static URI getLocalRegistrationURI() {
        return localRegistrationURI;
    }

    public static URI getLocalAsyncRegistrationURI() {
        return localAsynchronousRegistrationURI;
    }

    public static URI getLocalRegistrationRequesterURI() {
        return localRegistrationRequesterURI;
    }

    public static EndpointReference newRegistrationEPR(ActivityIdentifier activityId, long timeoutInMillis) {
        StatefulWebserviceFactory swf = StatefulWebserviceFactoryFactory.getInstance();
        return swf.createService("Coordinator", "RegistrationCoordinator", localAsynchronousRegistrationURI, AddressingVersion.MEMBER, activityId.getValue(), null, timeoutInMillis);
    }

    public static StatefulWebServiceManager getRegistrationCoordinatorStatefulWebServiceManager() {
        StatefulWebserviceFactory swf = StatefulWebserviceFactoryFactory.getInstance();
        return swf.getManager("Coordinator", "RegistrationCoordinator");
    }

    private RegistrationManager() {
    }

    public static RegistrationManager getInstance() {
        return instance;
    }

    public void register(@NotNull WebServiceContext wsContext, @NotNull String activityId, @NotNull RegisterType registerRequest) {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("RegistrationManager.register(WebserviceContext, RegisterType)");
        }
        String msgID = WsaHelper.getMsgID(wsContext);
        EndpointReference registrationRequesterEPR = WsaHelper.getReplyTo(wsContext);
        WSEndpointReference faultTo = WsaHelper.getFaultTo(wsContext);
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("register", "activityId:" + activityId + " register request msg id: " + msgID + " replyTo: " + registrationRequesterEPR);
        }
        if (registrationRequesterEPR == null) {
            if (faultTo != null) {
                WsaHelper.sendFault(faultTo, null, SOAPVersion.SOAP_11, TxFault.InvalidParameters, "register wsa:replyTo must be set for activityId " + activityId + " and msgId: " + msgID, msgID);
            }
            throw new WebServiceException(LocalizationMessages.REGISTER_REPLYTO_NOT_SET_3003(activityId, msgID));
        }
        Coordinator c = coordinationManager.getCoordinator(activityId);
        if (c == null) {
            WsaHelper.sendFault(faultTo, null, SOAPVersion.SOAP_11, TxFault.InvalidState, "attempting to register for an unknown activity Id: " + activityId + " and msgId: " + msgID, msgID);
            logger.warning("register", LocalizationMessages.REGISTER_FOR_UNKNOWN_ACTIVITY_3004(activityId, msgID));
        }
        ATParticipant r = null;
        Protocol requestProtocol = Protocol.getProtocol(registerRequest.getProtocolIdentifier());
        switch (requestProtocol) {
            case DURABLE: 
            case VOLATILE: 
            case COMPLETION: {
                r = new ATParticipant(c, registerRequest);
                c.addRegistrant(r, wsContext);
                break;
            }
            case WSAT2004: 
            case UNKNOWN: {
                WsaHelper.sendFault(faultTo, null, SOAPVersion.SOAP_11, TxFault.InvalidState, registerRequest.getProtocolIdentifier() + " is not a recognized coordination type: activityId " + activityId + " and msgId " + msgID, msgID);
                throw new UnsupportedOperationException(LocalizationMessages.UNRECOGNIZED_COORDINATION_TYPE_3011(registerRequest.getProtocolIdentifier(), activityId, msgID));
            }
        }
        OneWayFeature owf = new OneWayFeature();
        owf.setRelatesToID(msgID);
        RegistrationRequesterPortType registrationRequester = this.getCoordinatorService().getRegistrationRequester(registrationRequesterEPR, new WebServiceFeature[]{owf});
        RegisterResponseType registerResponse = new RegisterResponseType();
        registerResponse.setCoordinatorProtocolService((MemberSubmissionEndpointReference)r.getCoordinatorProtocolService());
        try {
            registrationRequester.registerResponseOperation(registerResponse);
        }
        catch (WebServiceException wse) {
            logger.warning("register", LocalizationMessages.REGISTERRESPONSE_FAILED_3005(registrationRequesterEPR, activityId, msgID, wse.getLocalizedMessage()));
            throw wse;
        }
        catch (Exception e) {
            logger.severe("register", LocalizationMessages.REGISTERRESPONSE_FAILED_3005(registrationRequesterEPR, activityId, msgID, e.getLocalizedMessage()));
            throw new WebServiceException((Throwable)e);
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("RegistrationManager.register(WebserviceContext, RegisterType)");
        }
    }

    @NotNull
    private com.sun.xml.ws.tx.webservice.member.coord.Coordinator getCoordinatorService() {
        return coordinatorService;
    }

    public void register(Coordinator c, Registrant r) {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("RegistrationManager.register(Coordinator, Registrant)");
        }
        if (c.registerWithRootRegistrationService(r)) {
            boolean timedOut;
            if (logger.isLogging(Level.FINE)) {
                logger.fine("RegistrationManager.register", "register with remote coordinator");
            }
            EndpointReference registrationEPR = c.getContext().getRootRegistrationService();
            r.setRemoteCPS(true);
            assert (registrationEPR != null);
            assert (r.getCoordinatorProtocolService() == null);
            RegisterType registerParam = new RegisterType();
            registerParam.setProtocolIdentifier(r.getProtocol().getUri());
            MemberSubmissionEndpointReference ppsEpr = (MemberSubmissionEndpointReference)r.getLocalParticipantProtocolService();
            registerParam.setParticipantProtocolService(ppsEpr);
            if (logger.isLogging(Level.FINE)) {
                logger.fine("register", "participant protocol service" + ppsEpr.toString());
            }
            StatefulWebserviceFactory swf = StatefulWebserviceFactoryFactory.getInstance();
            EndpointReference registrationRequesterEPR = swf.createService("Coordinator", "RegistrationRequester", localRegistrationRequesterURI, AddressingVersion.MEMBER, r.getCoordinator().getIdValue(), r.getIdValue(), r.getCoordinator().getExpires());
            OneWayFeature owf = new OneWayFeature();
            owf.setReplyTo(new WSEndpointReference(registrationRequesterEPR));
            RegistrationCoordinatorPortType registerCoordinator = this.getCoordinatorService().getRegistrationCoordinator(registrationEPR, new WebServiceFeature[]{owf});
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("RegistrationManager.register", "send wscoor:register to epr:" + registrationEPR + " replyTo EPR: " + owf.getReplyTo());
            }
            r.setRegistrationCompleted(false);
            try {
                registerCoordinator.registerOperation(registerParam);
                timedOut = r.waitForRegistrationResponse();
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("register(Coordinator, Registrant)", "timedOut = " + timedOut);
                }
            }
            catch (WebServiceException wse) {
                logger.warning("register", LocalizationMessages.REGISTER_FAILED_3006(registrationEPR, c.getIdValue(), wse.getLocalizedMessage()));
                throw wse;
            }
            finally {
                RegistrationRequesterPortTypeImpl rrpti = (RegistrationRequesterPortTypeImpl)RegistrationRequesterPortTypeImpl.getManager().resolve(registrationRequesterEPR);
                if (rrpti != null) {
                    RegistrationRequesterPortTypeImpl.getManager().unexport((Object)rrpti);
                }
            }
            if (r.isRegistrationCompleted() && logger.isLogging(Level.FINE)) {
                logger.fine("register", "asynch registration succeeded. Coordinator Protocol Service is " + r.getCoordinatorProtocolService());
            }
            if (timedOut) {
                WsaHelper.sendFault(null, registrationEPR, SOAPVersion.SOAP_11, TxFault.NoActivity, "registration timed out for activity id: " + c.getIdValue(), null);
                logger.warning("register", LocalizationMessages.REGISTRATION_TIMEOUT_3007(c.getIdValue(), registrationEPR));
            }
        } else {
            if (logger.isLogging(Level.FINE)) {
                logger.fine("RegistrationManager.register", "register with local coordinator");
            }
            r.setCoordinatorProtocolService(c.getCoordinatorProtocolServiceForRegistrant(r));
            c.addRegistrant(r, null);
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("RegistrationManager.register(Coordinator, Registrant)");
        }
    }

    public void registerResponse(@NotNull WebServiceContext wsContext, @NotNull String activityId, @NotNull String registrantId, @NotNull RegisterResponseType registerResponse) {
        Registrant r;
        if (logger.isLogging(Level.FINER)) {
            logger.entering("RegistrationManager.registerResponse");
        }
        if ((r = Registrant.getOutstandingRegistrant(registrantId)) == null) {
            WsaHelper.sendFault(wsContext, SOAPVersion.SOAP_11, TxFault.InvalidState, "received registerResponse for non-existent registrant : " + registrantId + " for activityId:" + activityId);
            logger.warning("registerResponse", LocalizationMessages.NONEXISTENT_REGISTRANT_3008(registrantId, activityId));
        } else {
            r.setCoordinatorProtocolService((EndpointReference)registerResponse.getCoordinatorProtocolService());
            r.setRemoteCPS(true);
            r.getCoordinator().addRegistrant(r, wsContext);
            Registrant.removeOutstandingRegistrant(registrantId);
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("registerResponse", "Completed registration for CoordId:" + activityId + "registrantId:" + registrantId);
            }
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("RegistrationManager.registerResponse");
        }
    }

    private boolean synchronousRegister(EndpointReference registrationEPR, Coordinator c, RegisterType registerParam, Registrant r) {
        return false;
    }

    @NotNull
    public static RegisterResponseType synchronousRegister(@NotNull WebServiceContext wsContext, @NotNull String activityId, @NotNull RegisterType registerRequest) {
        Coordinator c;
        Protocol requestProtocol = Protocol.getProtocol(registerRequest.getProtocolIdentifier());
        if (logger.isLogging(Level.FINER)) {
            logger.entering("synchronousRegister", "protocol=" + (Object)((Object)requestProtocol) + " coordId=" + activityId);
        }
        if ((c = coordinationManager.getCoordinator(activityId)) == null) {
            WsaHelper.sendFault(wsContext, SOAPVersion.SOAP_11, TxFault.InvalidParameters, "Received RegisterResponse for unknown activity id: " + activityId);
            logger.warning("synchronousRegister", LocalizationMessages.NONEXISTENT_ACTIVITY_3010(activityId));
        }
        ATParticipant r = null;
        switch (requestProtocol) {
            case DURABLE: 
            case VOLATILE: 
            case COMPLETION: {
                r = new ATParticipant(c, registerRequest);
                c.addRegistrant(r, wsContext);
                break;
            }
            case WSAT2004: 
            case UNKNOWN: {
                WsaHelper.sendFault(wsContext, SOAPVersion.SOAP_11, TxFault.InvalidParameters, requestProtocol.getUri() + " is not a recognized coordination type");
                throw new UnsupportedOperationException(LocalizationMessages.UNRECOGNIZED_COORDINATION_TYPE_3011((Object)requestProtocol, activityId, WsaHelper.getMsgID(wsContext)));
            }
        }
        RegisterResponseType registerResponse = new RegisterResponseType();
        registerResponse.setCoordinatorProtocolService((MemberSubmissionEndpointReference)r.getCoordinatorProtocolService());
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("synchronousRegister", r.getCoordinatorProtocolService());
        }
        return registerResponse;
    }
}

