/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv.impl.elements;

import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.secconv.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.secconv.impl.bindings.SecurityContextTokenType;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SecurityContextTokenImpl
extends SecurityContextTokenType
implements SecurityContextToken {
    private String instance = null;
    private URI identifier = null;
    private List<Object> extElements = null;
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");

    public SecurityContextTokenImpl() {
    }

    public SecurityContextTokenImpl(URI identifier, String instance, String wsuId) {
        if (identifier != null) {
            this.setIdentifier(identifier);
        }
        if (instance != null) {
            this.setInstance(instance);
        }
        if (wsuId != null) {
            this.setWsuId(wsuId);
        }
    }

    public SecurityContextTokenImpl(SecurityContextTokenType sTokenType) {
        List list = sTokenType.getAny();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (object instanceof JAXBElement) {
                JAXBElement obj = (JAXBElement)object;
                String local = obj.getName().getLocalPart();
                if (local.equalsIgnoreCase("Instance")) {
                    this.setInstance((String)obj.getValue());
                    continue;
                }
                if (!local.equalsIgnoreCase("Identifier")) continue;
                this.setIdentifier(URI.create((String)obj.getValue()));
                continue;
            }
            this.getAny().add(object);
            if (this.extElements != null) continue;
            this.extElements = new ArrayList<Object>();
            this.extElements.add(object);
        }
        this.setWsuId(sTokenType.getId());
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(URI identifier) {
        this.identifier = identifier;
        JAXBElement iElement = new ObjectFactory().createIdentifier(identifier.toString());
        this.getAny().add(iElement);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1004_SECCTX_TOKEN_ID_VALUE(identifier.toString()));
        }
    }

    public String getInstance() {
        return this.instance;
    }

    public final void setInstance(String instance) {
        this.instance = instance;
        JAXBElement iElement = new ObjectFactory().createInstance(instance);
        this.getAny().add(iElement);
    }

    public final void setWsuId(String wsuId) {
        this.setId(wsuId);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1005_SECCTX_TOKEN_WSUID_VALUE(wsuId));
        }
    }

    public String getWsuId() {
        return this.getId();
    }

    public String getType() {
        return "SecurityContextToken";
    }

    public Object getTokenValue() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.newDocument();
            Marshaller marshaller = WSTrustElementFactory.getContext().createMarshaller();
            JAXBElement tElement = new ObjectFactory().createSecurityContextToken((SecurityContextTokenType)this);
            marshaller.marshal((Object)tElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0019_ERR_TOKEN_VALUE(), ex);
            throw new RuntimeException(LogStringsMessages.WSSC_0019_ERR_TOKEN_VALUE(), ex);
        }
    }

    public List getExtElements() {
        return this.extElements;
    }
}

