/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.BindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.EncryptionAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.TokenProcessor;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyContainer;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.EncryptedElements;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.KerberosToken;
import com.sun.xml.ws.security.policy.SamlToken;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.policy.X509Token;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricBindingProcessor
extends BindingProcessor {
    private SymmetricBinding binding = null;

    public SymmetricBindingProcessor(SymmetricBinding binding, XWSSPolicyContainer container, boolean isServer, boolean isIncoming, Vector<SignedParts> signedParts, Vector<EncryptedParts> encryptedParts, Vector<SignedElements> signedElements, Vector<EncryptedElements> encryptedElements) {
        this.binding = binding;
        this.container = container;
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.protectionOrder = binding.getProtectionOrder();
        this.tokenProcessor = new TokenProcessor(isServer, isIncoming, this.pid);
        this.iAP = new IntegrityAssertionProcessor(binding.getAlgorithmSuite(), binding.isSignContent());
        this.eAP = new EncryptionAssertionProcessor(binding.getAlgorithmSuite(), false);
        this.signedParts = signedParts;
        this.signedElements = signedElements;
        this.encryptedElements = encryptedElements;
        this.encryptedParts = encryptedParts;
    }

    public void process() throws PolicyException {
        SignaturePolicy.FeatureBinding spFB;
        Token pt = this.binding.getProtectionToken();
        Token st = null;
        Token et = null;
        if (pt == null) {
            st = this.binding.getSignatureToken();
            et = this.binding.getEncryptionToken();
            if (et != null) {
                this.primaryEP = new EncryptionPolicy();
                this.primaryEP.setUUID(this.pid.generateID());
                this.addSymmetricKeyBinding((WSSPolicy)this.primaryEP, et);
            }
            if (st != null) {
                this.primarySP = new SignaturePolicy();
                this.primarySP.setUUID(this.pid.generateID());
                spFB = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
                SecurityPolicyUtil.setCanonicalizationMethod(spFB, this.binding.getAlgorithmSuite());
                spFB.isPrimarySignature(true);
                this.addSymmetricKeyBinding((WSSPolicy)this.primarySP, st);
            }
        } else {
            this.primarySP = new SignaturePolicy();
            this.primarySP.setUUID(this.pid.generateID());
            this.primaryEP = new EncryptionPolicy();
            this.primaryEP.setUUID(this.pid.generateID());
            this.addSymmetricKeyBinding((WSSPolicy)this.primarySP, pt);
            this.addSymmetricKeyBinding((WSSPolicy)this.primaryEP, pt);
            spFB = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
            SecurityPolicyUtil.setCanonicalizationMethod(spFB, this.binding.getAlgorithmSuite());
            spFB.isPrimarySignature(true);
        }
        if (this.protectionOrder == "SignBeforeEncrypting") {
            this.container.insert((SecurityPolicy)this.primarySP);
        } else {
            this.container.insert((SecurityPolicy)this.primaryEP);
            this.container.insert((SecurityPolicy)this.primarySP);
            if (this.primaryEP != null) {
                EncryptionPolicy.FeatureBinding efp = (EncryptionPolicy.FeatureBinding)this.primaryEP.getFeatureBinding();
                efp.setUseStandAloneRefList(true);
            }
        }
        this.addPrimaryTargets();
        if (this.foundEncryptTargets && this.binding.getSignatureProtection()) {
            this.protectPrimarySignature();
        }
        if (this.binding.isIncludeTimeStamp()) {
            TimestampPolicy tp = new TimestampPolicy();
            tp.setUUID(this.pid.generateID());
            this.container.insert((SecurityPolicy)tp);
            if (!this.binding.isDisableTimestampSigning()) {
                this.protectTimestamp(tp);
            }
        }
        if (this.binding.getTokenProtection()) {
            WSSPolicy policy = (WSSPolicy)this.primarySP.getKeyBinding();
            if (PolicyTypeUtil.derivedTokenKeyBinding((SecurityPolicy)policy)) {
                this.protectToken(policy, true);
            } else {
                this.protectToken((WSSPolicy)policy.getKeyBinding(), true);
            }
        }
    }

    protected void addSymmetricKeyBinding(WSSPolicy policy, Token token) throws PolicyException {
        SymmetricKeyBinding skb = new SymmetricKeyBinding();
        PolicyAssertion tokenAssertion = (PolicyAssertion)((Object)token);
        SecurityPolicyVersion spVersion = SecurityPolicyUtil.getSPVersion(tokenAssertion);
        if (PolicyUtil.isX509Token(tokenAssertion, spVersion)) {
            AuthenticationTokenPolicy.X509CertificateBinding x509CB = new AuthenticationTokenPolicy.X509CertificateBinding();
            x509CB.setUUID(token.getTokenId());
            this.tokenProcessor.setTokenValueType(x509CB, tokenAssertion);
            this.tokenProcessor.setTokenInclusion((KeyBindingBase)x509CB, (Token)((Object)tokenAssertion));
            this.tokenProcessor.setX509TokenRefType(x509CB, (X509Token)token);
            if (((X509Token)token).isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                skb.setKeyBinding((MLSPolicy)x509CB);
                policy.setKeyBinding((MLSPolicy)dtKB);
                dtKB.setOriginalKeyBinding((WSSPolicy)skb);
                dtKB.setUUID(this.pid.generateID());
            } else {
                skb.setKeyBinding((MLSPolicy)x509CB);
                policy.setKeyBinding((MLSPolicy)skb);
            }
        } else if (PolicyUtil.isKerberosToken(tokenAssertion, spVersion)) {
            AuthenticationTokenPolicy.KerberosTokenBinding kerberosBinding = new AuthenticationTokenPolicy.KerberosTokenBinding();
            kerberosBinding.setUUID(token.getTokenId());
            this.tokenProcessor.setTokenValueType(kerberosBinding, tokenAssertion);
            this.tokenProcessor.setTokenInclusion((KeyBindingBase)kerberosBinding, (Token)((Object)tokenAssertion));
            this.tokenProcessor.setKerberosTokenRefType(kerberosBinding, (KerberosToken)token);
            if (((KerberosToken)token).isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                skb.setKeyBinding((MLSPolicy)kerberosBinding);
                policy.setKeyBinding((MLSPolicy)dtKB);
                dtKB.setOriginalKeyBinding((WSSPolicy)skb);
                dtKB.setUUID(this.pid.generateID());
            } else {
                skb.setKeyBinding((MLSPolicy)kerberosBinding);
                policy.setKeyBinding((MLSPolicy)skb);
            }
        } else if (PolicyUtil.isSamlToken(tokenAssertion, spVersion)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding sab = new AuthenticationTokenPolicy.SAMLAssertionBinding();
            sab.setUUID(token.getTokenId());
            sab.setReferenceType("Direct");
            this.tokenProcessor.setTokenInclusion((KeyBindingBase)sab, (Token)((Object)tokenAssertion));
            if (((SamlToken)token).isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding((WSSPolicy)sab);
                policy.setKeyBinding((MLSPolicy)dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding((MLSPolicy)sab);
            }
        } else if (PolicyUtil.isIssuedToken(tokenAssertion, spVersion)) {
            IssuedTokenKeyBinding itkb = new IssuedTokenKeyBinding();
            this.tokenProcessor.setTokenInclusion((KeyBindingBase)itkb, (Token)((Object)tokenAssertion));
            itkb.setUUID(((Token)((Object)tokenAssertion)).getTokenId());
            IssuedToken it = (IssuedToken)((Object)tokenAssertion);
            if (it.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding((WSSPolicy)itkb);
                policy.setKeyBinding((MLSPolicy)dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding((MLSPolicy)itkb);
            }
        } else if (PolicyUtil.isSecureConversationToken(tokenAssertion, spVersion)) {
            SecureConversationTokenKeyBinding sct = new SecureConversationTokenKeyBinding();
            SecureConversationToken sctPolicy = (SecureConversationToken)((Object)tokenAssertion);
            if (sctPolicy.isRequireDerivedKeys()) {
                DerivedTokenKeyBinding dtKB = new DerivedTokenKeyBinding();
                dtKB.setOriginalKeyBinding((WSSPolicy)sct);
                policy.setKeyBinding((MLSPolicy)dtKB);
                dtKB.setUUID(this.pid.generateID());
            } else {
                policy.setKeyBinding((MLSPolicy)sct);
            }
            this.tokenProcessor.setTokenInclusion((KeyBindingBase)sct, (Token)((Object)tokenAssertion));
            sct.setUUID(((Token)((Object)tokenAssertion)).getTokenId());
        } else {
            throw new UnsupportedOperationException("addKeyBinding for " + token + "is not supported");
        }
    }

    @Override
    protected Binding getBinding() {
        return this.binding;
    }

    @Override
    protected EncryptionPolicy getSecondaryEncryptionPolicy() throws PolicyException {
        if (this.sEncPolicy == null) {
            this.sEncPolicy = new EncryptionPolicy();
            this.sEncPolicy.setUUID(this.pid.generateID());
            Token token = null;
            token = this.binding.getProtectionToken();
            if (token == null) {
                token = this.binding.getEncryptionToken();
            }
            this.addSymmetricKeyBinding((WSSPolicy)this.sEncPolicy, token);
            this.container.insert((SecurityPolicy)this.sEncPolicy);
        }
        return this.sEncPolicy;
    }

    @Override
    protected void close() {
        if (this.protectionOrder == "SignBeforeEncrypting") {
            this.container.insert((SecurityPolicy)this.primaryEP);
        }
    }
}

