/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.addressing.policy.Address;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Issuer
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.Issuer,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private Address address;
    private boolean populated = false;
    private PolicyAssertion refProps = null;
    private PolicyAssertion refParams = null;
    private PolicyAssertion serviceName = null;
    private String portType = null;

    public Issuer() {
    }

    public Issuer(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            if (this.hasNestedAssertions()) {
                Iterator<PolicyAssertion> it = this.getNestedAssertionsIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = it.next();
                    if (PolicyUtil.isAddress(assertion)) {
                        this.address = (Address)((Object)assertion);
                        continue;
                    }
                    if (PolicyUtil.isPortType(assertion)) {
                        this.portType = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isReferenceParameters(assertion)) {
                        this.refParams = assertion;
                        continue;
                    }
                    if (PolicyUtil.isReferenceProperties(assertion)) {
                        this.refProps = assertion;
                        continue;
                    }
                    if (!PolicyUtil.isServiceName(assertion)) continue;
                    this.serviceName = assertion;
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public Address getAddress() {
        this.populate();
        return this.address;
    }

    @Override
    public String getPortType() {
        this.populate();
        return this.portType;
    }

    @Override
    public PolicyAssertion getReferenceParameters() {
        this.populate();
        return this.refParams;
    }

    @Override
    public PolicyAssertion getReferenceProperties() {
        this.populate();
        return this.refProps;
    }

    @Override
    public PolicyAssertion getServiceName() {
        this.populate();
        return this.serviceName;
    }
}

