/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerOutboundSequence;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class RMDestination
extends RMProvider {
    private static final RMDestination RM_DESTINATION_INSTANCE = new RMDestination();
    private static final RmLogger LOGGER = RmLogger.getLogger(RMDestination.class);
    private Hashtable<String, ServerOutboundSequence> outboundMap = new Hashtable();
    private Hashtable<String, ServerInboundSequence> inboundMap = new Hashtable();
    private SequenceReaper reaper = new SequenceReaper(5000L, this.inboundMap);

    public static RMDestination getRMDestination() {
        return RM_DESTINATION_INSTANCE;
    }

    private RMDestination() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSequence(String id) throws InvalidSequenceException {
        String outid;
        InboundSequence seq = this.inboundMap.get(id);
        if (seq == null) {
            throw new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(id), id);
        }
        OutboundSequence out = seq.getOutboundSequence();
        RMDestination rMDestination = this;
        synchronized (rMDestination) {
            if (seq != null) {
                this.inboundMap.remove(id);
            }
            if (this.inboundMap.isEmpty()) {
                this.reaper.stop();
            }
        }
        if (out != null && (outid = out.getId()) != null) {
            this.outboundMap.remove(outid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInboundSequence createSequence(String inboundId, String outboundId, SequenceConfig config) throws RMException {
        ServerInboundSequence seq = new ServerInboundSequence(inboundId, outboundId, config);
        RMDestination rMDestination = this;
        synchronized (rMDestination) {
            this.inboundMap.put(seq.getId(), seq);
            if (this.inboundMap.size() == 1) {
                this.reaper.start();
            }
        }
        ServerOutboundSequence outbound = (ServerOutboundSequence)seq.getOutboundSequence();
        String id = outbound.getId();
        if (id != null) {
            this.outboundMap.put(id, outbound);
        }
        return seq;
    }

    public ServerOutboundSequence getOutboundSequence(String id) {
        return this.outboundMap.get(id);
    }

    public ServerInboundSequence getInboundSequence(String id) {
        return this.inboundMap.get(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SequenceReaper
    extends Timer {
        private long frequency;
        private Map<String, ServerInboundSequence> map;
        private TimerTask timerTask;

        public void start() {
            this.timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HashSet<String> keysToRemove = new HashSet<String>();
                    for (String key : SequenceReaper.this.map.keySet()) {
                        ServerInboundSequence sis;
                        ServerInboundSequence serverInboundSequence = sis = (ServerInboundSequence)SequenceReaper.this.map.get(key);
                        synchronized (serverInboundSequence) {
                            if (sis.isExpired()) {
                                LOGGER.fine("Terminating expired sequence: " + sis.getId());
                                keysToRemove.add(key);
                            }
                        }
                    }
                    for (String str : keysToRemove) {
                        try {
                            RMDestination.this.terminateSequence(str);
                        }
                        catch (Exception e) {
                            LOGGER.warning("Exception occured when terminating sequence: " + str, e);
                        }
                    }
                }
            };
            this.schedule(this.timerTask, new Date(System.currentTimeMillis() + this.frequency), this.frequency);
        }

        public void stop() {
            this.timerTask.cancel();
        }

        public SequenceReaper(long frequency, Map<String, ServerInboundSequence> map) {
            super(true);
            this.map = map;
            this.frequency = frequency;
        }
    }
}

