/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.jaxws.runtime.InboundMessageProcessor;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.localization.RmLogger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public abstract class TubeBase
extends AbstractFilterTubeImpl {
    private static final RmLogger LOGGER = RmLogger.getLogger(TubeBase.class);
    private WSDLPort wsdlPort;
    private SequenceConfig config;
    private Unmarshaller unmarshaller;

    protected TubeBase(WSDLPort wsdlPort, WSBinding binding, Tube nextTube) {
        super(nextTube);
        this.wsdlPort = wsdlPort;
        this.config = new SequenceConfig(wsdlPort, binding.getAddressingVersion(), binding.getSOAPVersion());
        this.unmarshaller = this.createUnmarshaller((JAXBContext)this.config.getRMVersion().jaxbContext);
    }

    protected TubeBase(TubeBase that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.wsdlPort = that.wsdlPort;
        this.config = that.config;
        this.unmarshaller = this.createUnmarshaller((JAXBContext)this.config.getRMVersion().jaxbContext);
    }

    protected RMMessage handleOutboundMessage(OutboundSequence outboundSequence, Packet packet, boolean isTwoWayRequest, boolean isOneWayResponse) throws RMException {
        RMMessage rmMessage = new RMMessage(packet.getMessage(), isOneWayResponse, isTwoWayRequest);
        Object messageNumberProperty = packet.invocationProperties.get("com.sun.xml.ws.messagenumber");
        if (messageNumberProperty instanceof Integer) {
            rmMessage.setMessageNumber((Integer)messageNumberProperty);
        }
        outboundSequence.processOutboundMessage(rmMessage);
        return rmMessage;
    }

    protected RMMessage handleInboundMessage(Packet packet, RMProvider provider) throws RMException {
        RMMessage rmMessage = new RMMessage(packet.getMessage());
        InboundMessageProcessor.processMessage(rmMessage, this.unmarshaller, provider, this.config.getRMVersion());
        return rmMessage;
    }

    protected final Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    protected final WSDLPort getWsdlPort() {
        return this.wsdlPort;
    }

    protected final SequenceConfig getConfig() {
        return this.config;
    }

    private Unmarshaller createUnmarshaller(JAXBContext jaxbContext) {
        try {
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new IllegalStateException("Unable to create JAXB unmarshaller", e));
        }
    }
}

