/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.component.CompositeComponentStackManager;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.CompositeComponentExpressionHolder;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CompositeComponentAttributesELResolver
extends ELResolver {
    private static final String COMPOSITE_COMPONENT_ATTRIBUTES_NAME = "attrs";
    private static final String COMPOSITE_COMPONENT_PARENT_NAME = "parent";
    private static final String EVAL_MAP_KEY = CompositeComponentAttributesELResolver.class.getName() + "_EVAL_MAP";

    public Object getValue(ELContext context, Object base, Object property) {
        Util.notNull("context", context);
        if (base != null && base instanceof UIComponent && UIComponent.isCompositeComponent((UIComponent)((UIComponent)base)) && property != null) {
            String propertyName = property.toString();
            if (COMPOSITE_COMPONENT_ATTRIBUTES_NAME.equals(propertyName)) {
                UIComponent c = (UIComponent)base;
                context.setPropertyResolved(true);
                FacesContext ctx = (FacesContext)context.getContext(FacesContext.class);
                return this.getEvalMapFor(c, ctx);
            }
            if (COMPOSITE_COMPONENT_PARENT_NAME.equals(propertyName)) {
                UIComponent c = (UIComponent)base;
                context.setPropertyResolved(true);
                FacesContext ctx = (FacesContext)context.getContext(FacesContext.class);
                CompositeComponentStackManager m = CompositeComponentStackManager.getManager(ctx);
                UIComponent ccp = m.getParentCompositeComponent(CompositeComponentStackManager.StackType.TreeCreation, ctx, c);
                if (ccp == null) {
                    ccp = m.getParentCompositeComponent(CompositeComponentStackManager.StackType.Evaluation, ctx, c);
                }
                return ccp;
            }
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        Util.notNull("context", context);
        if (!(base instanceof ExpressionEvalMap) || !(property instanceof String)) {
            return null;
        }
        Class exprType = null;
        Class metaType = null;
        ExpressionEvalMap evalMap = (ExpressionEvalMap)base;
        ValueExpression ve = evalMap.getExpression((String)property);
        if (ve != null) {
            exprType = ve.getType(context);
        }
        if (!"".equals(property)) {
            FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
            UIComponent cc = UIComponent.getCurrentCompositeComponent((FacesContext)facesContext);
            BeanInfo metadata = (BeanInfo)cc.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            assert (null != metadata);
            PropertyDescriptor[] attributes = metadata.getPropertyDescriptors();
            if (null != attributes) {
                for (PropertyDescriptor cur : attributes) {
                    Object type;
                    if (!property.equals(cur.getName()) || null == (type = cur.getValue("type"))) continue;
                    assert (type instanceof Class);
                    metaType = (Class)type;
                    break;
                }
            }
        }
        if (metaType != null && (exprType == null || exprType.isAssignableFrom(metaType))) {
            context.setPropertyResolved(true);
            return metaType;
        }
        return exprType;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        Util.notNull("context", context);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Util.notNull("context", context);
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        Util.notNull("context", context);
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        Util.notNull("context", context);
        return String.class;
    }

    public Map<String, Object> getEvalMapFor(UIComponent c, FacesContext ctx) {
        Map ctxAttributes = ctx.getAttributes();
        HashMap<UIComponent, Map> topMap = (HashMap<UIComponent, Map>)ctxAttributes.get(EVAL_MAP_KEY);
        Map evalMap = null;
        if (topMap == null) {
            topMap = new HashMap<UIComponent, Map>();
            ctxAttributes.put(EVAL_MAP_KEY, topMap);
            evalMap = new ExpressionEvalMap(ctx, c);
            topMap.put(c, evalMap);
        } else {
            evalMap = (Map)topMap.get(c);
            if (evalMap == null) {
                evalMap = new ExpressionEvalMap(ctx, c);
                topMap.put(c, evalMap);
            } else {
                ((ExpressionEvalMap)evalMap).updateFacesContext(ctx);
            }
        }
        return evalMap;
    }

    private static final class ExpressionEvalMap
    implements Map<String, Object>,
    CompositeComponentExpressionHolder {
        private Map<String, Object> attributesMap;
        private PropertyDescriptor[] declaredAttributes;
        private Map<Object, Object> declaredDefaultValues;
        private FacesContext ctx;
        private UIComponent cc;

        ExpressionEvalMap(FacesContext ctx, UIComponent cc) {
            this.cc = cc;
            this.attributesMap = cc.getAttributes();
            BeanInfo metadata = (BeanInfo)this.attributesMap.get("jakarta.faces.component.BEANINFO_KEY");
            if (null != metadata) {
                this.declaredAttributes = metadata.getPropertyDescriptors();
                this.declaredDefaultValues = new HashMap<Object, Object>(5);
            }
            this.ctx = ctx;
        }

        public ValueExpression getExpression(String name) {
            ValueExpression ve = this.cc.getValueExpression(name);
            return ve instanceof ValueExpression ? ve : null;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            boolean result = this.attributesMap.containsKey(key);
            if (!result) {
                result = null != this.getDeclaredDefaultValue(key);
            }
            return result;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            Object v = this.attributesMap.get(key);
            if (v == null && (v = this.getDeclaredDefaultValue(key)) != null) {
                return ((ValueExpression)v).getValue(this.ctx.getELContext());
            }
            if (v != null && v instanceof MethodExpression) {
                return v;
            }
            return v;
        }

        @Override
        public Object put(String key, Object value) {
            ValueExpression ve = this.cc.getValueExpression(key);
            if (ve != null) {
                ve.setValue(this.ctx.getELContext(), value);
            } else {
                this.attributesMap.put(key, value);
            }
            return null;
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        private Object getDeclaredDefaultValue(Object key) {
            Object result = null;
            if (!this.declaredDefaultValues.containsKey(key)) {
                boolean found = false;
                for (PropertyDescriptor cur : this.declaredAttributes) {
                    if (!cur.getName().equals(key)) continue;
                    found = true;
                    result = cur.getValue("default");
                    this.declaredDefaultValues.put(key, result);
                    break;
                }
                if (!found) {
                    this.declaredDefaultValues.put(key, null);
                }
            } else {
                result = this.declaredDefaultValues.get(key);
            }
            return result;
        }

        public void updateFacesContext(FacesContext ctx) {
            if (this.ctx != ctx) {
                this.ctx = ctx;
            }
        }
    }
}

