/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.ScriptStyleBaseRenderer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public class StylesheetRenderer
extends ScriptStyleBaseRenderer {
    public static final String DEFAULT_CONTENT_TYPE = "text/css";

    @Override
    protected void startInlineElement(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("style", component);
        this.writeTypeAttributeIfNecessary(context, writer);
    }

    private void writeTypeAttributeIfNecessary(FacesContext context, ResponseWriter writer) throws IOException {
        if (!RenderKitUtils.isOutputHtml5Doctype(context)) {
            writer.writeAttribute("type", (Object)DEFAULT_CONTENT_TYPE, "type");
        }
    }

    @Override
    protected void endInlineElement(ResponseWriter writer, UIComponent component) throws IOException {
        writer.endElement("style");
    }

    @Override
    protected void startExternalElement(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("link", component);
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        this.writeTypeAttributeIfNecessary(context, writer);
    }

    @Override
    protected void endExternalElement(ResponseWriter writer, UIComponent component, String resourceUrl) throws IOException {
        writer.writeURIAttribute("href", (Object)resourceUrl, "href");
        String media = (String)component.getAttributes().get("media");
        if (media != null) {
            writer.writeAttribute("media", (Object)media, "media");
        }
        writer.endElement("link");
    }

    @Override
    protected String verifyTarget(String toVerify) {
        return "head";
    }
}

