/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.InjectionApplicationFactory;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.context.InjectionFacesContextFactory;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FactoryConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACTORY = "factory";
    private static final String APPLICATION_FACTORY = "application-factory";
    private static final String EXCEPTION_HANDLER_FACTORY = "exception-handler-factory";
    private static final String FLASH_FACTORY = "flash-factory";
    private static final String VISIT_CONTEXT_FACTORY = "visit-context-factory";
    private static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "view-declaration-language-factory";
    private static final String TAG_HANDLER_DELEGATE_FACTORY = "tag-handler-delegate-factory";
    private static final String FACELET_CACHE_FACTORY = "facelet-cache-factory";
    private static final String FACES_CONTEXT_FACTORY = "faces-context-factory";
    private static final String CLIENT_WINDOW_FACTORY = "client-window-factory";
    private static final String PARTIAL_VIEW_CONTEXT_FACTORY = "partial-view-context-factory";
    private static final String LIFECYCLE_FACTORY = "lifecycle-factory";
    private static final String RENDER_KIT_FACTORY = "render-kit-factory";
    private static final String EXTERNAL_CONTEXT_FACTORY = "external-context-factory";
    private static final String FLOW_HANDLER_FACTORY = "flow-handler-factory";
    private static final String SEARCH_EXPRESSION_CONTEXT_FACTORY = "search-expression-context-factory";
    private final List<String> factoryNames = Arrays.asList("jakarta.faces.application.ApplicationFactory", "jakarta.faces.lifecycle.ClientWindowFactory", "jakarta.faces.context.ExceptionHandlerFactory", "jakarta.faces.context.ExternalContextFactory", "jakarta.faces.context.FacesContextFactory", "jakarta.faces.context.FlashFactory", "jakarta.faces.lifecycle.LifecycleFactory", "jakarta.faces.view.ViewDeclarationLanguageFactory", "jakarta.faces.context.PartialViewContextFactory", "jakarta.faces.render.RenderKitFactory", "jakarta.faces.component.visit.VisitContextFactory", "jakarta.faces.view.facelets.FaceletCacheFactory", "jakarta.faces.view.facelets.TagHandlerDelegateFactory", "jakarta.faces.flow.FlowHandlerFactory", "jakarta.faces.component.search.SearchExpressionContextFactory");
    private boolean validateFactories = true;

    public FactoryConfigProcessor() {
    }

    public FactoryConfigProcessor(boolean validateFactories) {
        this.validateFactories = validateFactories;
    }

    @Override
    public void process(ServletContext servletContext, FacesContext facesContext, DocumentInfo[] documentInfos) throws Exception {
        AtomicInteger facesContextFactoryCount = new AtomicInteger(0);
        AtomicInteger applicationFactoryCount = new AtomicInteger(0);
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList factories = document.getDocumentElement().getElementsByTagNameNS(namespace, FACTORY);
            if (factories == null || factories.getLength() <= 0) continue;
            this.processFactories(factories, namespace, facesContextFactoryCount, applicationFactoryCount);
        }
        this.wrapFactories(applicationFactoryCount.get(), facesContextFactoryCount.get());
        this.verifyFactoriesExist(servletContext);
    }

    private void processFactories(NodeList factories, String namespace, AtomicInteger fcCount, AtomicInteger appCount) {
        int size = factories.getLength();
        for (int i = 0; i < size; ++i) {
            Node factory = factories.item(i);
            NodeList children = ((Element)factory).getElementsByTagNameNS(namespace, "*");
            int csize = children.getLength();
            block35: for (int c = 0; c < csize; ++c) {
                Node childNode = children.item(c);
                switch (childNode.getLocalName()) {
                    case "application-factory": {
                        int cnt = appCount.incrementAndGet();
                        FactoryConfigProcessor.setFactory("jakarta.faces.application.ApplicationFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "exception-handler-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.context.ExceptionHandlerFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "visit-context-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.component.visit.VisitContextFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "lifecycle-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.lifecycle.LifecycleFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "flash-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.context.FlashFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "client-window-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.lifecycle.ClientWindowFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "faces-context-factory": {
                        fcCount.incrementAndGet();
                        FactoryConfigProcessor.setFactory("jakarta.faces.context.FacesContextFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "render-kit-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.render.RenderKitFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "view-declaration-language-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.view.ViewDeclarationLanguageFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "tag-handler-delegate-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.view.facelets.TagHandlerDelegateFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "facelet-cache-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.view.facelets.FaceletCacheFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "external-context-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.context.ExternalContextFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "partial-view-context-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.context.PartialViewContextFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "flow-handler-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.flow.FlowHandlerFactory", this.getNodeText(childNode));
                        continue block35;
                    }
                    case "search-expression-context-factory": {
                        FactoryConfigProcessor.setFactory("jakarta.faces.component.search.SearchExpressionContextFactory", this.getNodeText(childNode));
                    }
                }
            }
        }
    }

    private static void setFactory(String factoryName, String factoryImpl) {
        if (factoryName != null && factoryImpl != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling FactoryFinder.setFactory({0}, {1})", factoryName, factoryImpl));
            }
            FactoryFinder.setFactory((String)factoryName, (String)factoryImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFactoriesExist(ServletContext servletContext) {
        if (this.validateFactories) {
            ConcurrentLinkedDeque exceptions = new ConcurrentLinkedDeque();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.factoryNames.stream().forEach(e -> {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    InitFacesContext.getInstance(servletContext);
                    try {
                        FactoryFinder.getFactory((String)e);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        exceptions.add(new ConfigurationException(MessageFormat.format("Factory ''{0}'' was not configured properly.", e), exception));
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(null);
                    }
                });
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    private void wrapFactories(int appCount, int fcCount) {
        if (appCount > 1) {
            this.addInjectionApplicationFactory();
        }
        if (fcCount > 1) {
            this.addInjectionFacesContextFactory();
        }
    }

    private void addInjectionApplicationFactory() {
        FactoryFinder.setFactory((String)"jakarta.faces.application.ApplicationFactory", (String)InjectionApplicationFactory.class.getName());
    }

    private void addInjectionFacesContextFactory() {
        FactoryFinder.setFactory((String)"jakarta.faces.context.FacesContextFactory", (String)InjectionFacesContextFactory.class.getName());
    }
}

