/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PostRenderViewEvent;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.event.SystemEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NamedEventManager {
    private Map<String, Class<? extends SystemEvent>> namedEvents = new ConcurrentHashMap<String, Class<? extends SystemEvent>>();
    private Map<String, Set<Class<? extends SystemEvent>>> duplicateNames = new ConcurrentHashMap<String, Set<Class<? extends SystemEvent>>>();

    public NamedEventManager() {
        this.namedEvents.put("jakarta.faces.event.PreRenderComponent", PreRenderComponentEvent.class);
        this.namedEvents.put("jakarta.faces.event.PreRenderView", PreRenderViewEvent.class);
        this.namedEvents.put("jakarta.faces.event.PostRenderView", PostRenderViewEvent.class);
        this.namedEvents.put("jakarta.faces.event.PostAddToView", PostAddToViewEvent.class);
        this.namedEvents.put("jakarta.faces.event.PreValidate", PreValidateEvent.class);
        this.namedEvents.put("jakarta.faces.event.PostValidate", PostValidateEvent.class);
        this.namedEvents.put("preRenderComponent", PreRenderComponentEvent.class);
        this.namedEvents.put("preRenderView", PreRenderViewEvent.class);
        this.namedEvents.put("postRenderView", PostRenderViewEvent.class);
        this.namedEvents.put("postAddToView", PostAddToViewEvent.class);
        this.namedEvents.put("preValidate", PreValidateEvent.class);
        this.namedEvents.put("postValidate", PostValidateEvent.class);
    }

    public void addNamedEvent(String name, Class<? extends SystemEvent> event) {
        this.namedEvents.put(name, event);
    }

    public Class<? extends SystemEvent> getNamedEvent(String name) {
        Class namedEvent = this.namedEvents.get(name);
        if (namedEvent == null) {
            try {
                namedEvent = Util.loadClass(name, this);
            }
            catch (ClassNotFoundException ex) {
                throw new FacesException("An unknown event type was specified:  " + name, (Throwable)ex);
            }
        }
        if (!ComponentSystemEvent.class.isAssignableFrom(namedEvent)) {
            throw new ClassCastException();
        }
        return namedEvent;
    }

    public void addDuplicateName(String name, Class<? extends SystemEvent> event) {
        Class<? extends SystemEvent> registeredEvent = this.namedEvents.remove(name);
        Set<Class<? extends SystemEvent>> events = this.duplicateNames.get(name);
        if (events == null) {
            events = new HashSet<Class<? extends SystemEvent>>();
            this.duplicateNames.put(name, events);
        }
        events.add(event);
        if (registeredEvent != null) {
            events.add(registeredEvent);
        }
    }

    public boolean isDuplicateNamedEvent(String name) {
        return this.namedEvents.get(name) != null || this.duplicateNames.get(name) != null;
    }
}

