/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context.flash;

import com.sun.faces.context.flash.ELFlash;
import jakarta.faces.context.ExternalContext;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.io.Serializable;
import java.util.Map;

class SessionHelper
implements Serializable,
HttpSessionActivationListener {
    private static final long serialVersionUID = -4146679754778263071L;
    static final String FLASH_SESSIONACTIVATIONLISTENER_ATTRIBUTE_NAME = "csfcffFSAL";
    private static final String FLASH_INNER_MAP_KEY = "csfcffFIM";
    private boolean didPassivate;

    SessionHelper() {
    }

    static SessionHelper getInstance(ExternalContext extContext) {
        return (SessionHelper)extContext.getSessionMap().get(FLASH_SESSIONACTIVATIONLISTENER_ATTRIBUTE_NAME);
    }

    void update(ExternalContext extContext, ELFlash flash) {
        Map sessionMap = extContext.getSessionMap();
        if (this.didPassivate) {
            Map flashInnerMap = (Map)sessionMap.get(FLASH_INNER_MAP_KEY);
            flash.setFlashInnerMap(flashInnerMap);
            this.didPassivate = false;
        } else {
            sessionMap.put(FLASH_SESSIONACTIVATIONLISTENER_ATTRIBUTE_NAME, this);
            sessionMap.put(FLASH_INNER_MAP_KEY, flash.getFlashInnerMap());
        }
    }

    void remove(ExternalContext extContext) {
        Map sessionMap = extContext.getSessionMap();
        sessionMap.remove(FLASH_SESSIONACTIVATIONLISTENER_ATTRIBUTE_NAME);
        sessionMap.remove(FLASH_INNER_MAP_KEY);
    }

    public void sessionDidActivate(HttpSessionEvent hse) {
        this.didPassivate = true;
    }

    public void sessionWillPassivate(HttpSessionEvent hse) {
        this.didPassivate = true;
    }
}

