/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostlySingletonSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 2818326518724772145L;
    private Set<E> inner;

    @Override
    public boolean add(E e) {
        boolean result = true;
        if (null == this.inner) {
            this.inner = Collections.singleton(e);
        } else {
            if (1 == this.inner.size()) {
                HashSet<E> newSet = new HashSet<E>();
                newSet.add(this.inner.iterator().next());
                this.inner = newSet;
            }
            result = this.inner.add(e);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = true;
        if (null == this.inner && 1 == c.size()) {
            this.inner = Collections.singleton(c.iterator().next());
        } else {
            if (1 == this.inner.size()) {
                HashSet<E> newSet = new HashSet<E>();
                newSet.add(this.inner.iterator().next());
                this.inner = newSet;
            }
            result = this.inner.addAll(c);
        }
        return result;
    }

    @Override
    public void clear() {
        if (null != this.inner) {
            if (1 < this.inner.size()) {
                this.inner.clear();
            }
            this.inner = null;
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean didRemove = false;
        if (null != this.inner) {
            if (1 == this.inner.size()) {
                E e = this.inner.iterator().next();
                if (null != e && null != o) {
                    didRemove = e.equals(o);
                } else {
                    boolean bl = didRemove = null == o;
                }
                if (didRemove) {
                    this.inner = null;
                }
            } else {
                didRemove = this.inner.remove(o);
                if (didRemove && 1 == this.inner.size()) {
                    Set<E> newInner = Collections.singleton(this.inner.iterator().next());
                    this.inner.clear();
                    this.inner = newInner;
                }
            }
        }
        return didRemove;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        if (null != this.inner) {
            if (1 == this.inner.size()) {
                Iterator<?> incomingIter = c.iterator();
                E oneAndOnlyElement = this.inner.iterator().next();
                while (incomingIter.hasNext()) {
                    Object cur = incomingIter.next();
                    if (!(null != oneAndOnlyElement ? (result = oneAndOnlyElement.equals(cur)) : (result = cur == null))) continue;
                    break;
                }
                if (result) {
                    this.inner = null;
                }
            } else {
                result = this.inner.removeAll(c);
                if (result && 0 == this.inner.size()) {
                    this.inner = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean didModify = false;
        if (null != this.inner) {
            if (1 == this.inner.size()) {
                Iterator<?> incomingIter = c.iterator();
                E oneAndOnlyElement = this.inner.iterator().next();
                boolean found = false;
                while (incomingIter.hasNext()) {
                    Object cur = incomingIter.next();
                    if (!(null != oneAndOnlyElement ? (found = oneAndOnlyElement.equals(cur)) : (found = cur == null))) continue;
                    break;
                }
                if (didModify = !found) {
                    this.inner = null;
                }
            } else {
                didModify = this.inner.retainAll(c);
            }
        }
        return didModify;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        if (null != this.inner) {
            result = this.inner.contains(o);
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = false;
        if (null != this.inner) {
            result = this.inner.containsAll(c);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = true;
        if (null != this.inner) {
            result = this.inner.isEmpty();
        }
        return result;
    }

    @Override
    public int size() {
        int size = 0;
        if (null != this.inner) {
            size = this.inner.size();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null) {
            if (obj instanceof MostlySingletonSet) {
                MostlySingletonSet other = (MostlySingletonSet)obj;
                result = this.inner == other.inner || this.inner != null && this.inner.equals(other.inner);
            } else if (obj instanceof Collection) {
                Collection otherCollection = (Collection)obj;
                result = null != this.inner ? this.inner.equals(otherCollection) : otherCollection.isEmpty();
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.inner != null ? this.inner.hashCode() : 0);
        return hash;
    }

    public String toString() {
        String result = "empty";
        if (null != this.inner) {
            result = this.inner.toString();
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator result = null != this.inner ? this.inner.iterator() : Collections.EMPTY_SET.iterator();
        return result;
    }

    @Override
    public Object[] toArray() {
        Object[] result = null;
        if (null != this.inner) {
            result = this.inner.toArray();
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] result = null;
        if (null != this.inner) {
            result = this.inner.toArray(a);
        }
        return result;
    }
}

