/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import org.openqa.selenium.Keys;

public enum OperaKey {
    NULL("null"),
    CANCEL("cancel"),
    HELP("help"),
    BACK_SPACE("backspace"),
    TAB("Tab"),
    CLEAR("clear"),
    ENTER("enter"),
    RETURN(OperaKey.ENTER.value),
    SHIFT("Shift"),
    LEFT_SHIFT(OperaKey.SHIFT.value),
    CONTROL("control"),
    LEFT_CONTROL(OperaKey.CONTROL.value),
    ALT("alt"),
    LEFT_ALT(OperaKey.ALT.value),
    PAUSE("pause"),
    ESCAPE("escape"),
    SPACE(" "),
    PAGE_UP("pageup"),
    PAGE_DOWN("pagedown"),
    END("end"),
    HOME("home"),
    LEFT("left"),
    ARROW_LEFT(OperaKey.LEFT.value),
    UP("up"),
    ARROW_UP(OperaKey.UP.value),
    RIGHT("right"),
    ARROW_RIGHT(OperaKey.RIGHT.value),
    DOWN("down"),
    ARROW_DOWN(OperaKey.DOWN.value),
    INSERT("insert"),
    DELETE("del"),
    SEMICOLON(";"),
    EQUALS("="),
    NUMPAD0("0"),
    NUMPAD1("1"),
    NUMPAD2("2"),
    NUMPAD3("3"),
    NUMPAD4("4"),
    NUMPAD5("5"),
    NUMPAD6("6"),
    NUMPAD7("7"),
    NUMPAD8("8"),
    NUMPAD9("9"),
    MULTIPLY("*"),
    ADD("+"),
    SEPARATOR(","),
    SUBTRACT("-"),
    DECIMAL("."),
    DIVIDE("/"),
    F1("f1"),
    F2("f2"),
    F3("f3"),
    F4("f4"),
    F5("f5"),
    F6("f6"),
    F7("f7"),
    F8("f8"),
    F9("f9"),
    F10("f10"),
    F11("f11"),
    F12("f12");

    private static final Map<Keys, OperaKey> lookup;
    private final String value;

    private OperaKey(String value) {
        this.value = value;
    }

    public String toScope() {
        return this.value;
    }

    public String toString() {
        return String.format("%s -> %s", this.name(), this.toScope());
    }

    public static OperaKey get(Keys key) {
        return lookup.get(key);
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])OperaKey.values()), (Function)new Function<OperaKey, Keys>(){

            public Keys apply(OperaKey key) {
                return Keys.valueOf((String)key.name());
            }
        });
    }
}

