/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.internal.input;

import com.opera.core.systems.internal.input.KeyboardModifiers;
import org.openqa.selenium.Keys;

public class KeyEvent {
    private final Character character;
    private final Keys unicodeKey;

    public KeyEvent(char ch) {
        this.character = Character.valueOf(ch);
        this.unicodeKey = KeyEvent.getKeyFromUnicode(this.character.charValue());
    }

    public char getCharacter() {
        return this.character.charValue();
    }

    public Keys getKey() {
        return this.unicodeKey;
    }

    public boolean isSpecial() {
        return this.getKey() != null;
    }

    public boolean isModifier() {
        return KeyboardModifiers.isModifier(this.getKey());
    }

    public boolean isModifierRelease() {
        return this.getKey() == Keys.NULL;
    }

    public boolean isNewLine() {
        return this.getCharacter() == '\n';
    }

    private static Keys getKeyFromUnicode(char key) {
        for (Keys unicodeKey : Keys.values()) {
            if (unicodeKey.charAt(0) != key) continue;
            return unicodeKey;
        }
        return null;
    }
}

