/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.Ansi;
import com.novocode.junit.RichLogger;
import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.TestSelector;

abstract class AbstractEvent
implements Event {
    protected final String ansiName;
    protected final String ansiMsg;
    protected final Status status;
    protected final Throwable error;
    private final Fingerprint fingerprint;
    private final Long duration;

    AbstractEvent(String string, String string2, Status status, Fingerprint fingerprint, Long l, Throwable throwable) {
        this.fingerprint = fingerprint;
        this.ansiName = string;
        this.ansiMsg = string2;
        this.status = status;
        this.duration = l;
        this.error = throwable;
    }

    abstract void logTo(RichLogger var1);

    public String fullyQualifiedName() {
        return Ansi.filterAnsi(this.ansiName);
    }

    public Fingerprint fingerprint() {
        return this.fingerprint;
    }

    public Selector selector() {
        return new TestSelector(this.fullyQualifiedName());
    }

    public Status status() {
        return this.status;
    }

    public OptionalThrowable throwable() {
        if (this.error == null) {
            return new OptionalThrowable();
        }
        return new OptionalThrowable(this.error);
    }

    public long duration() {
        return this.duration;
    }

    String durationToString() {
        return (double)this.duration.longValue() / 1000.0 + " sec";
    }
}

