/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.css.parser.CharStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"})
public final class CSSCharStream
implements CharStream {
    private static final int DEFAULT_BUF_SIZE = 4096;
    private final Reader m_aReader;
    private int m_nLine;
    private int m_nColumn;
    private int m_nAvailable;
    private int m_nBufsize;
    private char[] m_aBuffer;
    private int[] m_aBufLine;
    private int[] m_aBufColumn;
    private char[] m_aNextCharBuf;
    private boolean m_bPrevCharIsCR = false;
    private boolean m_bPrevCharIsLF = false;
    private int m_nTokenBegin = 0;
    private int m_nInBuf = 0;
    private int m_nMaxNextCharInd = 0;
    private int m_nNextCharInd = -1;
    private int m_nBufpos = -1;
    private int m_nTabSize = 8;
    private boolean m_bTrackLineColumn = true;

    public CSSCharStream(@Nonnull Reader reader) {
        this(reader, 1, 1, 4096);
    }

    private CSSCharStream(@Nonnull Reader reader, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        ValueEnforcer.isGE0((int)n3, (String)"BufferSize");
        this.m_aReader = StreamHelper.getBuffered((Reader)((Reader)ValueEnforcer.notNull((Object)reader, (String)"Reader")));
        this.m_nLine = ValueEnforcer.isGE0((int)n, (String)"StartLine");
        this.m_nColumn = ValueEnforcer.isGE0((int)n2, (String)"StartColumn") - 1;
        this.m_nAvailable = n3;
        this.m_nBufsize = n3;
        this.m_aBuffer = new char[n3];
        this.m_aBufLine = new int[n3];
        this.m_aBufColumn = new int[n3];
        this.m_aNextCharBuf = new char[4096];
    }

    @Override
    public void setTabSize(int n) {
        this.m_nTabSize = n;
    }

    @Override
    public int getTabSize() {
        return this.m_nTabSize;
    }

    private void _expandBuff(boolean bl) {
        char[] cArray = new char[this.m_nBufsize + 2048];
        int[] nArray = new int[this.m_nBufsize + 2048];
        int[] nArray2 = new int[this.m_nBufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(this.m_aBuffer, this.m_nTokenBegin, cArray, 0, this.m_nBufsize - this.m_nTokenBegin);
                System.arraycopy(this.m_aBuffer, 0, cArray, this.m_nBufsize - this.m_nTokenBegin, this.m_nBufpos);
                this.m_aBuffer = cArray;
                System.arraycopy(this.m_aBufLine, this.m_nTokenBegin, nArray, 0, this.m_nBufsize - this.m_nTokenBegin);
                System.arraycopy(this.m_aBufLine, 0, nArray, this.m_nBufsize - this.m_nTokenBegin, this.m_nBufpos);
                this.m_aBufLine = nArray;
                System.arraycopy(this.m_aBufColumn, this.m_nTokenBegin, nArray2, 0, this.m_nBufsize - this.m_nTokenBegin);
                System.arraycopy(this.m_aBufColumn, 0, nArray2, this.m_nBufsize - this.m_nTokenBegin, this.m_nBufpos);
                this.m_aBufColumn = nArray2;
                this.m_nBufpos += this.m_nBufsize - this.m_nTokenBegin;
            } else {
                System.arraycopy(this.m_aBuffer, this.m_nTokenBegin, cArray, 0, this.m_nBufsize - this.m_nTokenBegin);
                this.m_aBuffer = cArray;
                System.arraycopy(this.m_aBufLine, this.m_nTokenBegin, nArray, 0, this.m_nBufsize - this.m_nTokenBegin);
                this.m_aBufLine = nArray;
                System.arraycopy(this.m_aBufColumn, this.m_nTokenBegin, nArray2, 0, this.m_nBufsize - this.m_nTokenBegin);
                this.m_aBufColumn = nArray2;
                this.m_nBufpos -= this.m_nTokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error("Something went wrong", throwable);
        }
        this.m_nBufsize += 2048;
        this.m_nAvailable = this.m_nBufsize;
        this.m_nTokenBegin = 0;
    }

    private void _fillBuff() throws IOException {
        if (this.m_nMaxNextCharInd == 4096) {
            this.m_nMaxNextCharInd = 0;
            this.m_nNextCharInd = 0;
        }
        try {
            int n = this.m_aReader.read(this.m_aNextCharBuf, this.m_nMaxNextCharInd, 4096 - this.m_nMaxNextCharInd);
            if (n == -1) {
                this.m_aReader.close();
                throw new IOException("EOF in JavaCharStream");
            }
            this.m_nMaxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            if (this.m_nBufpos != 0) {
                --this.m_nBufpos;
                this.backup(0);
            } else {
                this.m_aBufLine[this.m_nBufpos] = this.m_nLine;
                this.m_aBufColumn[this.m_nBufpos] = this.m_nColumn;
            }
            throw iOException;
        }
    }

    private char _readByte() throws IOException {
        ++this.m_nNextCharInd;
        if (this.m_nNextCharInd >= this.m_nMaxNextCharInd) {
            this._fillBuff();
        }
        return this.m_aNextCharBuf[this.m_nNextCharInd];
    }

    @Override
    public char BeginToken() throws IOException {
        if (this.m_nInBuf > 0) {
            --this.m_nInBuf;
            if (++this.m_nBufpos == this.m_nBufsize) {
                this.m_nBufpos = 0;
            }
            this.m_nTokenBegin = this.m_nBufpos;
            return this.m_aBuffer[this.m_nBufpos];
        }
        this.m_nTokenBegin = 0;
        this.m_nBufpos = -1;
        return this.readChar();
    }

    private void _adjustBuffSize() {
        if (this.m_nAvailable == this.m_nBufsize) {
            if (this.m_nTokenBegin > 2048) {
                this.m_nBufpos = 0;
                this.m_nAvailable = this.m_nTokenBegin;
            } else {
                this._expandBuff(false);
            }
        } else if (this.m_nAvailable > this.m_nTokenBegin) {
            this.m_nAvailable = this.m_nBufsize;
        } else if (this.m_nTokenBegin - this.m_nAvailable < 2048) {
            this._expandBuff(true);
        } else {
            this.m_nAvailable = this.m_nTokenBegin;
        }
    }

    private void _updateLineColumn(char c) {
        ++this.m_nColumn;
        if (this.m_bPrevCharIsLF) {
            this.m_bPrevCharIsLF = false;
            this.m_nColumn = 1;
            ++this.m_nLine;
        } else if (this.m_bPrevCharIsCR) {
            this.m_bPrevCharIsCR = false;
            if (c == '\n') {
                this.m_bPrevCharIsLF = true;
            } else {
                this.m_nColumn = 1;
                ++this.m_nLine;
            }
        }
        switch (c) {
            case '\r': {
                this.m_bPrevCharIsCR = true;
                break;
            }
            case '\n': {
                this.m_bPrevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.m_nColumn;
                this.m_nColumn += this.m_nTabSize - this.m_nColumn % this.m_nTabSize;
                break;
            }
        }
        this.m_aBufLine[this.m_nBufpos] = this.m_nLine;
        this.m_aBufColumn[this.m_nBufpos] = this.m_nColumn;
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.m_nInBuf > 0) {
            --this.m_nInBuf;
            if (++this.m_nBufpos == this.m_nBufsize) {
                this.m_nBufpos = 0;
            }
            return this.m_aBuffer[this.m_nBufpos];
        }
        if (++this.m_nBufpos == this.m_nAvailable) {
            this._adjustBuffSize();
        }
        this.m_aBuffer[this.m_nBufpos] = c = this._readByte();
        if (this.m_bTrackLineColumn) {
            this._updateLineColumn(c);
        }
        return c;
    }

    @Override
    public int getEndColumn() {
        return this.m_aBufColumn[this.m_nBufpos];
    }

    @Override
    public int getEndLine() {
        return this.m_aBufLine[this.m_nBufpos];
    }

    @Override
    public int getBeginColumn() {
        return this.m_aBufColumn[this.m_nTokenBegin];
    }

    @Override
    public int getBeginLine() {
        return this.m_aBufLine[this.m_nTokenBegin];
    }

    @Override
    public void backup(int n) {
        this.m_nInBuf += n;
        this.m_nBufpos -= n;
        if (this.m_nBufpos < 0) {
            this.m_nBufpos += this.m_nBufsize;
        }
    }

    @Override
    public String GetImage() {
        if (this.m_nBufpos >= this.m_nTokenBegin) {
            return new String(this.m_aBuffer, this.m_nTokenBegin, this.m_nBufpos - this.m_nTokenBegin + 1);
        }
        return new String(this.m_aBuffer, this.m_nTokenBegin, this.m_nBufsize - this.m_nTokenBegin) + new String(this.m_aBuffer, 0, this.m_nBufpos + 1);
    }

    @Override
    public char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (this.m_nBufpos + 1 >= n) {
            System.arraycopy(this.m_aBuffer, this.m_nBufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(this.m_aBuffer, this.m_nBufsize - (n - this.m_nBufpos - 1), cArray, 0, n - this.m_nBufpos - 1);
            System.arraycopy(this.m_aBuffer, 0, cArray, n - this.m_nBufpos - 1, this.m_nBufpos + 1);
        }
        return cArray;
    }

    @Override
    public void Done() {
        this.m_aNextCharBuf = null;
        this.m_aBuffer = null;
        this.m_aBufLine = null;
        this.m_aBufColumn = null;
    }

    public void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.m_nTokenBegin;
        int n6 = n;
        int n7 = this.m_nBufpos >= this.m_nTokenBegin ? this.m_nBufpos - this.m_nTokenBegin + this.m_nInBuf + 1 : this.m_nBufsize - this.m_nTokenBegin + this.m_nBufpos + 1 + this.m_nInBuf;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n4 = 0; n4 < n7 && this.m_aBufLine[n8 = n5 % this.m_nBufsize] == this.m_aBufLine[n3 = ++n5 % this.m_nBufsize]; ++n4) {
            this.m_aBufLine[n8] = n6;
            n9 = n10 + this.m_aBufColumn[n3] - this.m_aBufColumn[n8];
            this.m_aBufColumn[n8] = n2 + n10;
            n10 = n9;
        }
        if (n4 < n7) {
            this.m_aBufLine[n8] = n6++;
            this.m_aBufColumn[n8] = n2 + n10;
            while (n4++ < n7) {
                n8 = n5 % this.m_nBufsize;
                if (this.m_aBufLine[n8] != this.m_aBufLine[n3 = ++n5 % this.m_nBufsize]) {
                    this.m_aBufLine[n8] = n6++;
                    continue;
                }
                this.m_aBufLine[n8] = n6;
            }
        }
        this.m_nLine = this.m_aBufLine[n8];
        this.m_nColumn = this.m_aBufColumn[n8];
    }

    @Override
    public boolean getTrackLineColumn() {
        return this.m_bTrackLineColumn;
    }

    @Override
    public void setTrackLineColumn(boolean bl) {
        this.m_bTrackLineColumn = bl;
    }
}

