/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.DbSettings;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.schema.Constant;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.table.TableLink;
import org.h2.util.New;

public class Schema
extends DbObjectBase {
    private User owner;
    private final boolean system;
    private final HashMap<String, Table> tablesAndViews;
    private final HashMap<String, Index> indexes;
    private final HashMap<String, Sequence> sequences;
    private final HashMap<String, TriggerObject> triggers;
    private final HashMap<String, Constraint> constraints;
    private final HashMap<String, Constant> constants;
    private final HashMap<String, FunctionAlias> functions;
    private final HashSet<String> temporaryUniqueNames = New.hashSet();

    public Schema(Database database, int n, String string, User user, boolean bl) {
        this.tablesAndViews = database.newStringMap();
        this.indexes = database.newStringMap();
        this.sequences = database.newStringMap();
        this.triggers = database.newStringMap();
        this.constraints = database.newStringMap();
        this.constants = database.newStringMap();
        this.functions = database.newStringMap();
        this.initDbObjectBase(database, n, string, 8);
        this.owner = user;
        this.system = bl;
    }

    public boolean canDrop() {
        return !this.system;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        return "CREATE SCHEMA IF NOT EXISTS " + this.getSQL() + " AUTHORIZATION " + this.owner.getSQL();
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        Object object;
        SchemaObjectBase schemaObjectBase;
        while (this.triggers != null && this.triggers.size() > 0) {
            schemaObjectBase = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObjectBase);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            schemaObjectBase = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, schemaObjectBase);
        }
        boolean bl = false;
        do {
            bl = false;
            if (this.tablesAndViews == null) continue;
            for (Table table : New.arrayList(this.tablesAndViews.values())) {
                if (table.getName() == null) continue;
                if (this.database.getDependentTable(table, table) == null) {
                    this.database.removeSchemaObject(session, table);
                    continue;
                }
                bl = true;
            }
        } while (bl);
        while (this.indexes != null && this.indexes.size() > 0) {
            object = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            object = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.constants != null && this.constants.size() > 0) {
            object = (Constant)this.constants.values().toArray()[0];
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.functions != null && this.functions.size() > 0) {
            object = (FunctionAlias)this.functions.values().toArray()[0];
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public User getOwner() {
        return this.owner;
    }

    private HashMap<String, SchemaObject> getMap(int n) {
        HashMap<String, SchemaObject> hashMap;
        switch (n) {
            case 0: {
                hashMap = this.tablesAndViews;
                break;
            }
            case 3: {
                hashMap = this.sequences;
                break;
            }
            case 1: {
                hashMap = this.indexes;
                break;
            }
            case 4: {
                hashMap = this.triggers;
                break;
            }
            case 5: {
                hashMap = this.constraints;
                break;
            }
            case 11: {
                hashMap = this.constants;
                break;
            }
            case 9: {
                hashMap = this.functions;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return hashMap;
    }

    public void add(SchemaObject schemaObject) {
        if (SysProperties.CHECK && schemaObject.getSchema() != this) {
            DbException.throwInternalError("wrong schema");
        }
        String string = schemaObject.getName();
        HashMap<String, SchemaObject> hashMap = this.getMap(schemaObject.getType());
        if (SysProperties.CHECK && hashMap.get(string) != null) {
            DbException.throwInternalError("object already exists: " + string);
        }
        hashMap.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public void rename(SchemaObject schemaObject, String string) {
        int n = schemaObject.getType();
        HashMap<String, SchemaObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(schemaObject.getName())) {
                DbException.throwInternalError("not found: " + schemaObject.getName());
            }
            if (schemaObject.getName().equals(string) || hashMap.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        schemaObject.checkRename();
        hashMap.remove(schemaObject.getName());
        this.freeUniqueName(schemaObject.getName());
        schemaObject.rename(string);
        hashMap.put(string, schemaObject);
        this.freeUniqueName(string);
    }

    public Table findTableOrView(Session session, String string) {
        Table table = this.tablesAndViews.get(string);
        if (table == null && session != null) {
            table = session.findLocalTempTable(string);
        }
        return table;
    }

    public Index findIndex(Session session, String string) {
        Index index = this.indexes.get(string);
        if (index == null) {
            index = session.findLocalTempTableIndex(string);
        }
        return index;
    }

    public TriggerObject findTrigger(String string) {
        return this.triggers.get(string);
    }

    public Sequence findSequence(String string) {
        return this.sequences.get(string);
    }

    public Constraint findConstraint(Session session, String string) {
        Constraint constraint = this.constraints.get(string);
        if (constraint == null) {
            constraint = session.findLocalTempTableConstraint(string);
        }
        return constraint;
    }

    public Constant findConstant(String string) {
        return this.constants.get(string);
    }

    public FunctionAlias findFunction(String string) {
        return this.functions.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String string) {
        if (string != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueName(DbObject dbObject, HashMap<String, ? extends SchemaObject> hashMap, String string) {
        String string2 = Integer.toHexString(dbObject.getName().hashCode()).toUpperCase();
        String string3 = null;
        HashSet<String> hashSet = this.temporaryUniqueNames;
        synchronized (hashSet) {
            int n;
            int n2 = string2.length();
            for (n = 1; n < n2 && (hashMap.containsKey(string3 = string + string2.substring(0, n)) || this.temporaryUniqueNames.contains(string3)); ++n) {
                string3 = null;
            }
            if (string3 == null) {
                string = string + string2 + "_";
                n = 0;
                while (hashMap.containsKey(string3 = string + n) || this.temporaryUniqueNames.contains(string3)) {
                    ++n;
                }
            }
            this.temporaryUniqueNames.add(string3);
        }
        return string3;
    }

    public String getUniqueConstraintName(Session session, Table table) {
        HashMap<String, Constraint> hashMap = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.constraints;
        return this.getUniqueName(table, hashMap, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Session session, Table table, String string) {
        HashMap<String, Index> hashMap = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.indexes;
        return this.getUniqueName(table, hashMap, string);
    }

    public Table getTableOrView(Session session, String string) {
        Table table = this.tablesAndViews.get(string);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(string);
            }
            if (table == null) {
                throw DbException.get(42102, string);
            }
        }
        return table;
    }

    public Index getIndex(String string) {
        Index index = this.indexes.get(string);
        if (index == null) {
            throw DbException.get(42112, string);
        }
        return index;
    }

    public Constraint getConstraint(String string) {
        Constraint constraint = this.constraints.get(string);
        if (constraint == null) {
            throw DbException.get(90057, string);
        }
        return constraint;
    }

    public Constant getConstant(String string) {
        Constant constant = this.constants.get(string);
        if (constant == null) {
            throw DbException.get(90115, string);
        }
        return constant;
    }

    public Sequence getSequence(String string) {
        Sequence sequence = this.sequences.get(string);
        if (sequence == null) {
            throw DbException.get(90036, string);
        }
        return sequence;
    }

    public ArrayList<SchemaObject> getAll() {
        ArrayList<SchemaObject> arrayList = New.arrayList();
        arrayList.addAll(this.getMap(0).values());
        arrayList.addAll(this.getMap(3).values());
        arrayList.addAll(this.getMap(1).values());
        arrayList.addAll(this.getMap(4).values());
        arrayList.addAll(this.getMap(5).values());
        arrayList.addAll(this.getMap(11).values());
        arrayList.addAll(this.getMap(9).values());
        return arrayList;
    }

    public ArrayList<SchemaObject> getAll(int n) {
        HashMap<String, SchemaObject> hashMap = this.getMap(n);
        return New.arrayList(hashMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Table> getAllTablesAndViews() {
        Database database = this.database;
        synchronized (database) {
            return New.arrayList(this.tablesAndViews.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableOrViewByName(String string) {
        Database database = this.database;
        synchronized (database) {
            return this.tablesAndViews.get(string);
        }
    }

    public void remove(SchemaObject schemaObject) {
        String string = schemaObject.getName();
        HashMap<String, SchemaObject> hashMap = this.getMap(schemaObject.getType());
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            DbException.throwInternalError("not found: " + string);
        }
        hashMap.remove(string);
        this.freeUniqueName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData createTableData) {
        Database database = this.database;
        synchronized (database) {
            if (!createTableData.temporary || createTableData.globalTemporary) {
                this.database.lockMeta(createTableData.session);
            }
            createTableData.schema = this;
            if (createTableData.tableEngine == null) {
                DbSettings dbSettings = this.database.getSettings();
                if (dbSettings.defaultTableEngine != null) {
                    createTableData.tableEngine = dbSettings.defaultTableEngine;
                } else if (dbSettings.mvStore) {
                    createTableData.tableEngine = MVTableEngine.class.getName();
                }
            }
            if (createTableData.tableEngine != null) {
                return this.database.getTableEngine(createTableData.tableEngine).createTable(createTableData);
            }
            return new RegularTable(createTableData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, n, string, string2, string3, string4, string5, string6, string7, bl, bl2);
        }
    }
}

