/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.EndpointManager;
import net.rithms.riot.api.LogHandler;
import net.rithms.riot.api.RiotApiAsync;
import net.rithms.riot.api.RiotApiException;
import net.rithms.riot.api.endpoints.champion.dto.Champion;
import net.rithms.riot.api.endpoints.champion.methods.GetChampion;
import net.rithms.riot.api.endpoints.champion.methods.GetChampions;
import net.rithms.riot.api.endpoints.champion_mastery.dto.ChampionMastery;
import net.rithms.riot.api.endpoints.champion_mastery.methods.GetChampionMasteriesBySummoner;
import net.rithms.riot.api.endpoints.champion_mastery.methods.GetChampionMasteriesBySummonerByChampion;
import net.rithms.riot.api.endpoints.champion_mastery.methods.GetChampionMasteryScoresBySummoner;
import net.rithms.riot.api.endpoints.league.constant.LeagueQueue;
import net.rithms.riot.api.endpoints.league.dto.LeagueList;
import net.rithms.riot.api.endpoints.league.dto.LeaguePosition;
import net.rithms.riot.api.endpoints.league.methods.GetChallengerLeagueByQueue;
import net.rithms.riot.api.endpoints.league.methods.GetLeagueById;
import net.rithms.riot.api.endpoints.league.methods.GetLeaguePositionsBySummonerId;
import net.rithms.riot.api.endpoints.league.methods.GetMasterLeagueByQueue;
import net.rithms.riot.api.endpoints.lol_status.dto.ShardStatus;
import net.rithms.riot.api.endpoints.lol_status.methods.GetShardData;
import net.rithms.riot.api.endpoints.match.dto.Match;
import net.rithms.riot.api.endpoints.match.dto.MatchList;
import net.rithms.riot.api.endpoints.match.dto.MatchTimeline;
import net.rithms.riot.api.endpoints.match.methods.GetMatch;
import net.rithms.riot.api.endpoints.match.methods.GetMatchByMatchIdAndTournamentCode;
import net.rithms.riot.api.endpoints.match.methods.GetMatchIdsByTournamentCode;
import net.rithms.riot.api.endpoints.match.methods.GetMatchListByAccountId;
import net.rithms.riot.api.endpoints.match.methods.GetTimelineByMatchId;
import net.rithms.riot.api.endpoints.spectator.dto.CurrentGameInfo;
import net.rithms.riot.api.endpoints.spectator.dto.FeaturedGames;
import net.rithms.riot.api.endpoints.spectator.methods.GetActiveGameBySummoner;
import net.rithms.riot.api.endpoints.spectator.methods.GetFeaturedGames;
import net.rithms.riot.api.endpoints.static_data.constant.ChampionListTags;
import net.rithms.riot.api.endpoints.static_data.constant.ChampionTags;
import net.rithms.riot.api.endpoints.static_data.constant.ItemListTags;
import net.rithms.riot.api.endpoints.static_data.constant.ItemTags;
import net.rithms.riot.api.endpoints.static_data.constant.Locale;
import net.rithms.riot.api.endpoints.static_data.constant.MasteryListTags;
import net.rithms.riot.api.endpoints.static_data.constant.MasteryTags;
import net.rithms.riot.api.endpoints.static_data.constant.RuneListTags;
import net.rithms.riot.api.endpoints.static_data.constant.RuneTags;
import net.rithms.riot.api.endpoints.static_data.constant.SpellListTags;
import net.rithms.riot.api.endpoints.static_data.constant.SpellTags;
import net.rithms.riot.api.endpoints.static_data.dto.ChampionList;
import net.rithms.riot.api.endpoints.static_data.dto.Item;
import net.rithms.riot.api.endpoints.static_data.dto.ItemList;
import net.rithms.riot.api.endpoints.static_data.dto.LanguageStrings;
import net.rithms.riot.api.endpoints.static_data.dto.MapData;
import net.rithms.riot.api.endpoints.static_data.dto.Mastery;
import net.rithms.riot.api.endpoints.static_data.dto.MasteryList;
import net.rithms.riot.api.endpoints.static_data.dto.ProfileIconData;
import net.rithms.riot.api.endpoints.static_data.dto.Realm;
import net.rithms.riot.api.endpoints.static_data.dto.ReforgedRune;
import net.rithms.riot.api.endpoints.static_data.dto.ReforgedRunePath;
import net.rithms.riot.api.endpoints.static_data.dto.Rune;
import net.rithms.riot.api.endpoints.static_data.dto.RuneList;
import net.rithms.riot.api.endpoints.static_data.dto.SummonerSpell;
import net.rithms.riot.api.endpoints.static_data.dto.SummonerSpellList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataChampion;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataChampionList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataItem;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataItemList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataLanguageStrings;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataLanguages;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataMaps;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataMastery;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataMasteryList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataProfileIcons;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataRealm;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRune;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRuneList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRunePath;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataReforgedRunePathList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataRune;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataRuneList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataSummonerSpell;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataSummonerSpellList;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataTarballLinks;
import net.rithms.riot.api.endpoints.static_data.methods.GetDataVersions;
import net.rithms.riot.api.endpoints.summoner.dto.Summoner;
import net.rithms.riot.api.endpoints.summoner.methods.GetSummoner;
import net.rithms.riot.api.endpoints.summoner.methods.GetSummonerByAccount;
import net.rithms.riot.api.endpoints.summoner.methods.GetSummonerByName;
import net.rithms.riot.api.endpoints.third_party_code.methods.GetThirdPartyCodeBySummoner;
import net.rithms.riot.api.endpoints.tournament.constant.PickType;
import net.rithms.riot.api.endpoints.tournament.constant.SpectatorType;
import net.rithms.riot.api.endpoints.tournament.constant.TournamentMap;
import net.rithms.riot.api.endpoints.tournament.dto.LobbyEventWrapper;
import net.rithms.riot.api.endpoints.tournament.dto.TournamentCode;
import net.rithms.riot.api.endpoints.tournament.methods.CreateTournament;
import net.rithms.riot.api.endpoints.tournament.methods.CreateTournamentCodes;
import net.rithms.riot.api.endpoints.tournament.methods.CreateTournamentProvider;
import net.rithms.riot.api.endpoints.tournament.methods.GetLobbyEventsByCode;
import net.rithms.riot.api.endpoints.tournament.methods.GetTournamentCode;
import net.rithms.riot.api.endpoints.tournament.methods.UpdateTournamentCode;
import net.rithms.riot.constant.Platform;
import net.rithms.util.RiotApiUtil;

public class RiotApi
implements Cloneable {
    public static final Logger log = Logger.getLogger(RiotApi.class.getName());
    private final ApiConfig config;
    private final EndpointManager endpointManager;
    private final Object asyncApiLock = new Object();
    private volatile RiotApiAsync asyncApi;

    public RiotApi() {
        this(new ApiConfig());
    }

    public RiotApi(ApiConfig config) {
        this.config = config;
        log.setUseParentHandlers(false);
        log.addHandler(new LogHandler(config.getDebugToFile()));
        log.setLevel(config.getDebugLevel());
        this.endpointManager = new EndpointManager(config);
    }

    public Object callCustomApiMethod(ApiMethod method) throws RiotApiException {
        Objects.requireNonNull(method);
        return this.endpointManager.callMethodAndReturnDto(method);
    }

    public RiotApi clone() {
        return new RiotApi(this.config.clone());
    }

    public int createTournament(String tournamentName, int providerId) throws RiotApiException {
        CreateTournament method = new CreateTournament(this.getConfig(), tournamentName, providerId);
        return (Integer)this.endpointManager.callMethodAndReturnDto(method);
    }

    public int createTournament(int providerId) throws RiotApiException {
        return this.createTournament(null, providerId);
    }

    public List<String> createTournamentCodes(int tournamentId, int count, int teamSize, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, String metaData, long ... allowedSummonerIds) throws RiotApiException {
        Objects.requireNonNull(mapType);
        Objects.requireNonNull(pickType);
        Objects.requireNonNull(spectatorType);
        CreateTournamentCodes method = new CreateTournamentCodes(this.getConfig(), tournamentId, count, teamSize, mapType, pickType, spectatorType, metaData, allowedSummonerIds);
        return (List)this.endpointManager.callMethodAndReturnDto(method);
    }

    public List<String> createTournamentCodes(int tournamentId, int count, int teamSize, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, long ... allowedSummonerIds) throws RiotApiException {
        return this.createTournamentCodes(tournamentId, count, teamSize, mapType, pickType, spectatorType, null, allowedSummonerIds);
    }

    public int createTournamentProvider(String region, String callbackUrl) throws RiotApiException {
        Objects.requireNonNull(region);
        Objects.requireNonNull(callbackUrl);
        CreateTournamentProvider method = new CreateTournamentProvider(this.getConfig(), region, callbackUrl);
        return (Integer)this.endpointManager.callMethodAndReturnDto(method);
    }

    public CurrentGameInfo getActiveGameBySummoner(Platform platform, long summonerId) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(summonerId);
        GetActiveGameBySummoner method = new GetActiveGameBySummoner(this.getConfig(), platform, summonerId);
        return (CurrentGameInfo)this.endpointManager.callMethodAndReturnDto(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiotApiAsync getAsyncApi() {
        RiotApiAsync asyncInstance = this.asyncApi;
        if (asyncInstance == null) {
            Object object = this.asyncApiLock;
            synchronized (object) {
                asyncInstance = this.asyncApi;
                if (asyncInstance == null) {
                    this.asyncApi = asyncInstance = new RiotApiAsync(this.config, this.endpointManager);
                }
            }
        }
        return asyncInstance;
    }

    public LeagueList getChallengerLeagueByQueue(Platform platform, String queue) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(queue);
        GetChallengerLeagueByQueue method = new GetChallengerLeagueByQueue(this.getConfig(), platform, queue);
        return (LeagueList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LeagueList getChallengerLeagueByQueue(Platform platform, LeagueQueue queue) throws RiotApiException {
        Objects.requireNonNull(queue);
        return this.getChallengerLeagueByQueue(platform, queue.toString());
    }

    public Champion getChampion(Platform platform, int id) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetChampion method = new GetChampion(this.getConfig(), platform, id);
        return (Champion)this.endpointManager.callMethodAndReturnDto(method);
    }

    public List<ChampionMastery> getChampionMasteriesBySummoner(Platform platform, long summonerId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetChampionMasteriesBySummoner method = new GetChampionMasteriesBySummoner(this.getConfig(), platform, summonerId);
        return (List)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ChampionMastery getChampionMasteriesBySummonerByChampion(Platform platform, long summonerId, int championId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetChampionMasteriesBySummonerByChampion method = new GetChampionMasteriesBySummonerByChampion(this.getConfig(), platform, summonerId, championId);
        return (ChampionMastery)this.endpointManager.callMethodAndReturnDto(method);
    }

    public int getChampionMasteryScoresBySummoner(Platform platform, long summonerId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetChampionMasteryScoresBySummoner method = new GetChampionMasteryScoresBySummoner(this.getConfig(), platform, summonerId);
        return (Integer)this.endpointManager.callMethodAndReturnDto(method);
    }

    public net.rithms.riot.api.endpoints.champion.dto.ChampionList getChampions(Platform platform, boolean freeToPlay) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetChampions method = new GetChampions(this.getConfig(), platform, freeToPlay);
        return (net.rithms.riot.api.endpoints.champion.dto.ChampionList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public net.rithms.riot.api.endpoints.champion.dto.ChampionList getChampions(Platform platform) throws RiotApiException {
        return this.getChampions(platform, false);
    }

    protected ApiConfig getConfig() {
        return this.config;
    }

    public net.rithms.riot.api.endpoints.static_data.dto.Champion getDataChampion(Platform platform, int id, Locale locale, String version, ChampionTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataChampion method = new GetDataChampion(this.getConfig(), platform, id, locale, version, tags);
        return (net.rithms.riot.api.endpoints.static_data.dto.Champion)this.endpointManager.callMethodAndReturnDto(method);
    }

    public net.rithms.riot.api.endpoints.static_data.dto.Champion getDataChampion(Platform platform, int id) throws RiotApiException {
        return this.getDataChampion(platform, id, null, null, new ChampionTags[0]);
    }

    public ChampionList getDataChampionList(Platform platform, Locale locale, String version, boolean dataById, ChampionListTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataChampionList method = new GetDataChampionList(this.getConfig(), platform, locale, version, dataById, tags);
        return (ChampionList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ChampionList getDataChampionList(Platform platform) throws RiotApiException {
        return this.getDataChampionList(platform, null, null, false, new ChampionListTags[0]);
    }

    public Item getDataItem(Platform platform, int id, Locale locale, String version, ItemTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataItem method = new GetDataItem(this.getConfig(), platform, id, locale, version, tags);
        return (Item)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Item getDataItem(Platform platform, int id) throws RiotApiException {
        return this.getDataItem(platform, id, null, null, new ItemTags[0]);
    }

    public ItemList getDataItemList(Platform platform, Locale locale, String version, ItemListTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataItemList method = new GetDataItemList(this.getConfig(), platform, locale, version, tags);
        return (ItemList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ItemList getDataItemList(Platform platform) throws RiotApiException {
        return this.getDataItemList(platform, null, null, new ItemListTags[0]);
    }

    public List<String> getDataLanguages(Platform platform) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataLanguages method = new GetDataLanguages(this.getConfig(), platform);
        return (List)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LanguageStrings getDataLanguageStrings(Platform platform, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataLanguageStrings method = new GetDataLanguageStrings(this.getConfig(), platform, locale, version);
        return (LanguageStrings)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LanguageStrings getDataLanguageStrings(Platform platform) throws RiotApiException {
        return this.getDataLanguageStrings(platform, null, null);
    }

    public MapData getDataMaps(Platform platform, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataMaps method = new GetDataMaps(this.getConfig(), platform, locale, version);
        return (MapData)this.endpointManager.callMethodAndReturnDto(method);
    }

    public MapData getDataMaps(Platform platform) throws RiotApiException {
        return this.getDataMaps(platform, null, null);
    }

    public Mastery getDataMastery(Platform platform, int id, Locale locale, String version, MasteryTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataMastery method = new GetDataMastery(this.getConfig(), platform, id, locale, version, tags);
        return (Mastery)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Mastery getDataMastery(Platform platform, int id) throws RiotApiException {
        return this.getDataMastery(platform, id, null, null, new MasteryTags[0]);
    }

    public MasteryList getDataMasteryList(Platform platform, Locale locale, String version, MasteryListTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataMasteryList method = new GetDataMasteryList(this.getConfig(), platform, locale, version, tags);
        return (MasteryList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public MasteryList getDataMasteryList(Platform platform) throws RiotApiException {
        return this.getDataMasteryList(platform, null, null, new MasteryListTags[0]);
    }

    public ProfileIconData getDataProfileIcons(Platform platform, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataProfileIcons method = new GetDataProfileIcons(this.getConfig(), platform, locale, version);
        return (ProfileIconData)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ProfileIconData getDataProfileIcons(Platform platform) throws RiotApiException {
        return this.getDataProfileIcons(platform, null, null);
    }

    public Realm getDataRealm(Platform platform) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataRealm method = new GetDataRealm(this.getConfig(), platform);
        return (Realm)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ReforgedRune getDataReforgedRune(Platform platform, int id, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataReforgedRune method = new GetDataReforgedRune(this.getConfig(), platform, id, locale, version);
        return (ReforgedRune)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ReforgedRune getDataReforgedRune(Platform platform, int id) throws RiotApiException {
        return this.getDataReforgedRune(platform, id, null, null);
    }

    public ReforgedRune[] getDataReforgedRuneList(Platform platform, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataReforgedRuneList method = new GetDataReforgedRuneList(this.getConfig(), platform, locale, version);
        return (ReforgedRune[])this.endpointManager.callMethodAndReturnDto(method);
    }

    public ReforgedRune[] getDataReforgedRuneList(Platform platform) throws RiotApiException {
        return this.getDataReforgedRuneList(platform, null, null);
    }

    public ReforgedRunePath getDataReforgedRunePath(Platform platform, int id, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataReforgedRunePath method = new GetDataReforgedRunePath(this.getConfig(), platform, id, locale, version);
        return (ReforgedRunePath)this.endpointManager.callMethodAndReturnDto(method);
    }

    public ReforgedRunePath getDataReforgedRunePath(Platform platform, int id) throws RiotApiException {
        return this.getDataReforgedRunePath(platform, id, null, null);
    }

    public ReforgedRunePath[] getDataReforgedRunePathList(Platform platform, Locale locale, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataReforgedRunePathList method = new GetDataReforgedRunePathList(this.getConfig(), platform, locale, version);
        return (ReforgedRunePath[])this.endpointManager.callMethodAndReturnDto(method);
    }

    public ReforgedRunePath[] getDataReforgedRunePathList(Platform platform) throws RiotApiException {
        return this.getDataReforgedRunePathList(platform, null, null);
    }

    public Rune getDataRune(Platform platform, int id, Locale locale, String version, RuneTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataRune method = new GetDataRune(this.getConfig(), platform, id, locale, version, tags);
        return (Rune)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Rune getDataRune(Platform platform, int id) throws RiotApiException {
        return this.getDataRune(platform, id, null, null, new RuneTags[0]);
    }

    public RuneList getDataRuneList(Platform platform, Locale locale, String version, RuneListTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataRuneList method = new GetDataRuneList(this.getConfig(), platform, locale, version, tags);
        return (RuneList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public RuneList getDataRuneList(Platform platform) throws RiotApiException {
        return this.getDataRuneList(platform, null, null, new RuneListTags[0]);
    }

    public SummonerSpell getDataSummonerSpell(Platform platform, int id, Locale locale, String version, SpellTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataSummonerSpell method = new GetDataSummonerSpell(this.getConfig(), platform, id, locale, version, tags);
        return (SummonerSpell)this.endpointManager.callMethodAndReturnDto(method);
    }

    public SummonerSpell getDataSummonerSpell(Platform platform, int id) throws RiotApiException {
        return this.getDataSummonerSpell(platform, id, null, null, new SpellTags[0]);
    }

    public SummonerSpellList getDataSummonerSpellList(Platform platform, Locale locale, String version, boolean dataById, SpellListTags ... tags) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataSummonerSpellList method = new GetDataSummonerSpellList(this.getConfig(), platform, locale, version, dataById, tags);
        return (SummonerSpellList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public SummonerSpellList getDataSummonerSpellList(Platform platform) throws RiotApiException {
        return this.getDataSummonerSpellList(platform, null, null, false, new SpellListTags[0]);
    }

    public String getDataTarballLinks(Platform platform, String version) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetDataTarballLinks method = new GetDataTarballLinks(this.getConfig(), platform, version);
        return (String)this.endpointManager.callMethodAndReturnDto(method);
    }

    public String getDataTarballLinks(Platform platform) throws RiotApiException {
        Objects.requireNonNull(platform);
        return this.getDataTarballLinks(platform, null);
    }

    public List<String> getDataVersions(Platform platform) throws RiotApiException {
        GetDataVersions method = new GetDataVersions(this.getConfig(), platform);
        return (List)this.endpointManager.callMethodAndReturnDto(method);
    }

    public FeaturedGames getFeaturedGames(Platform platform) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetFeaturedGames method = new GetFeaturedGames(this.getConfig(), platform);
        return (FeaturedGames)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LeagueList getLeagueById(Platform platform, String leagueId) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(leagueId);
        GetLeagueById method = new GetLeagueById(this.getConfig(), platform, leagueId);
        return (LeagueList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Set<LeaguePosition> getLeaguePositionsBySummonerId(Platform platform, long summonerId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetLeaguePositionsBySummonerId method = new GetLeaguePositionsBySummonerId(this.getConfig(), platform, summonerId);
        return (Set)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LobbyEventWrapper getLobbyEventsByTournament(String tournamentCode) throws RiotApiException {
        Objects.requireNonNull(tournamentCode);
        GetLobbyEventsByCode method = new GetLobbyEventsByCode(this.getConfig(), tournamentCode);
        return (LobbyEventWrapper)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LeagueList getMasterLeagueByQueue(Platform platform, String queue) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(queue);
        GetMasterLeagueByQueue method = new GetMasterLeagueByQueue(this.getConfig(), platform, queue);
        return (LeagueList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public LeagueList getMasterLeagueByQueue(Platform platform, LeagueQueue queue) throws RiotApiException {
        Objects.requireNonNull(queue);
        return this.getMasterLeagueByQueue(platform, queue.toString());
    }

    public Match getMatch(Platform platform, long matchId, long forAccountId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetMatch method = new GetMatch(this.getConfig(), platform, matchId, forAccountId);
        return (Match)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Match getMatch(Platform platform, long matchId) throws RiotApiException {
        return this.getMatch(platform, matchId, -1L);
    }

    public Match getMatchByMatchIdAndTournamentCode(Platform platform, long matchId, String tournamentCode) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(tournamentCode);
        GetMatchByMatchIdAndTournamentCode method = new GetMatchByMatchIdAndTournamentCode(this.getConfig(), platform, matchId, tournamentCode);
        return (Match)this.endpointManager.callMethodAndReturnDto(method);
    }

    public List<Long> getMatchIdsByTournamentCode(Platform platform, String tournamentCode) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(tournamentCode);
        GetMatchIdsByTournamentCode method = new GetMatchIdsByTournamentCode(this.getConfig(), platform, tournamentCode);
        return (List)this.endpointManager.callMethodAndReturnDto(method);
    }

    public MatchList getMatchListByAccountId(Platform platform, long accountId, Set<Integer> champion, Set<Integer> queue, Set<Integer> season, long beginTime, long endTime, int beginIndex, int endIndex) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetMatchListByAccountId method = new GetMatchListByAccountId(this.getConfig(), platform, accountId, champion, queue, season, beginTime, endTime, beginIndex, endIndex);
        return (MatchList)this.endpointManager.callMethodAndReturnDto(method);
    }

    public MatchList getMatchListByAccountId(Platform platform, long accountId, Set<Integer> champion, Set<Integer> queue, Set<Integer> season) throws RiotApiException {
        return this.getMatchListByAccountId(platform, accountId, champion, queue, season, -1L, -1L, -1, -1);
    }

    public MatchList getMatchListByAccountId(Platform platform, long accountId) throws RiotApiException {
        return this.getMatchListByAccountId(platform, accountId, null, null, null);
    }

    public ShardStatus getShardData(Platform platform) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetShardData method = new GetShardData(this.getConfig(), platform);
        return (ShardStatus)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Summoner getSummonerByAccount(Platform platform, long accountId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetSummonerByAccount method = new GetSummonerByAccount(this.getConfig(), platform, accountId);
        return (Summoner)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Summoner getSummoner(Platform platform, long summonerId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetSummoner method = new GetSummoner(this.getConfig(), platform, summonerId);
        return (Summoner)this.endpointManager.callMethodAndReturnDto(method);
    }

    public Summoner getSummonerByName(Platform platform, String summonerName) throws RiotApiException {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(summonerName);
        RiotApiUtil.requireValidSummonerName(summonerName);
        GetSummonerByName method = new GetSummonerByName(this.getConfig(), platform, summonerName);
        return (Summoner)this.endpointManager.callMethodAndReturnDto(method);
    }

    public String getThirdPartyCodeBySummoner(Platform platform, long summonerId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetThirdPartyCodeBySummoner method = new GetThirdPartyCodeBySummoner(this.getConfig(), platform, summonerId);
        return (String)this.endpointManager.callMethodAndReturnDto(method);
    }

    public MatchTimeline getTimelineByMatchId(Platform platform, long matchId) throws RiotApiException {
        Objects.requireNonNull(platform);
        GetTimelineByMatchId method = new GetTimelineByMatchId(this.getConfig(), platform, matchId);
        return (MatchTimeline)this.endpointManager.callMethodAndReturnDto(method);
    }

    public TournamentCode getTournamentCode(String tournamentCode) throws RiotApiException {
        Objects.requireNonNull(tournamentCode);
        GetTournamentCode method = new GetTournamentCode(this.getConfig(), tournamentCode);
        return (TournamentCode)this.endpointManager.callMethodAndReturnDto(method);
    }

    public void updateTournamentCode(String tournamentCode, TournamentMap mapType, PickType pickType, SpectatorType spectatorType, long ... allowedSummonerIds) throws RiotApiException {
        Objects.requireNonNull(tournamentCode);
        UpdateTournamentCode method = new UpdateTournamentCode(this.getConfig(), tournamentCode, mapType, pickType, spectatorType, allowedSummonerIds);
        this.endpointManager.callMethod(method);
    }
}

