/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.util.logging.Level;
import net.rithms.riot.api.AsyncRequestPool;
import net.rithms.riot.api.RiotApi;

class AsyncRequestPoolSupervisor
extends Thread {
    private static final long IDLE_TIME_RESIGN = 5000L;
    private final AsyncRequestPool pool;
    private long lastJob = 0L;
    private boolean running = true;

    AsyncRequestPoolSupervisor(AsyncRequestPool pool) {
        super("Riot Api - Async Request Pool Supervisor");
        this.pool = pool;
    }

    private void clearPool() {
        if (this.pool.getPoolSize() > 0) {
            this.pool.clearPool();
        }
    }

    private void pollQueue() {
        if (this.pool.getPoolSize() == this.pool.getMaxAsyncThreads()) {
            return;
        }
        for (int i = this.pool.getPoolSize(); i < this.pool.getMaxAsyncThreads() && this.pool.pollQueue(); ++i) {
            this.lastJob = System.currentTimeMillis();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            this.clearPool();
            this.pollQueue();
            if (this.pool.isEmpty() && this.lastJob + 5000L < System.currentTimeMillis()) {
                this.pool.resignSupervisor();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                RiotApi.log.log(Level.WARNING, "Supervisor Sleep Interrupted", e);
            }
        }
    }

    void shutdown() {
        this.running = false;
    }
}

