/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.ProjectRolesRestClient;
import com.atlassian.jira.rest.client.domain.BasicProjectRole;
import com.atlassian.jira.rest.client.domain.ProjectRole;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.BasicProjectRoleJsonParser;
import com.atlassian.jira.rest.client.internal.json.ProjectRoleJsonParser;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.UriBuilder;

public class JerseyProjectRolesRestClient
extends AbstractJerseyRestClient
implements ProjectRolesRestClient {
    private final ProjectRoleJsonParser projectRoleJsonParser;
    private final BasicProjectRoleJsonParser basicRoleJsonParser;

    public JerseyProjectRolesRestClient(URI baseUri, ApacheHttpClient client, URI serverUri) {
        super(baseUri, client);
        this.projectRoleJsonParser = new ProjectRoleJsonParser(serverUri);
        this.basicRoleJsonParser = new BasicProjectRoleJsonParser();
    }

    @Override
    public ProjectRole getRole(URI uri, ProgressMonitor progressMonitor) {
        return this.getAndParse(uri, this.projectRoleJsonParser, progressMonitor);
    }

    @Override
    public ProjectRole getRole(URI projectUri, Long roleId, ProgressMonitor progressMonitor) {
        URI roleUri = UriBuilder.fromUri((URI)projectUri).path("role").path(String.valueOf(roleId)).build(new Object[0]);
        return this.getAndParse(roleUri, this.projectRoleJsonParser, progressMonitor);
    }

    @Override
    public Iterable<ProjectRole> getRoles(URI projectUri, final ProgressMonitor progressMonitor) {
        URI rolesUris = UriBuilder.fromUri((URI)projectUri).path("role").build(new Object[0]);
        Collection<BasicProjectRole> basicProjectRoles = this.getAndParse(rolesUris, this.basicRoleJsonParser, progressMonitor);
        return Iterables.transform(basicProjectRoles, (Function)new Function<BasicProjectRole, ProjectRole>(){

            public ProjectRole apply(BasicProjectRole role) {
                return JerseyProjectRolesRestClient.this.getRole(role.getSelf(), progressMonitor);
            }
        });
    }
}

