/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment.api;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;
import uz.paycom.payment.utils.PaycomSandBox;

public class JsonRpcRequest {
    private static final String TAG = "JsonRpcRequest";
    public static final String cardsCreateMethod = "cards.create";
    public static final String cardsGetVerifyCodeMethod = "cards.get_verify_code";
    public static final String cardsCreateVerifyMethod = "cards.verify";
    private final String xAuth;
    private HttpURLConnection urlConnection;

    public JsonRpcRequest(String xAuth) {
        this.xAuth = xAuth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callApi(JSONObject jsonObject) {
        try {
            String urlApi = PaycomSandBox.isSandBox() ? "http://checkout.test.paycom.uz/api" : "http://checkout.paycom.uz/api";
            URL url = new URL(urlApi);
            this.urlConnection = (HttpURLConnection)url.openConnection();
            this.urlConnection.setRequestMethod("POST");
            this.urlConnection.addRequestProperty("X-Auth", this.xAuth);
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setUseCaches(false);
            this.urlConnection.setConnectTimeout(30000);
            OutputStreamWriter writer = new OutputStreamWriter(this.urlConnection.getOutputStream());
            writer.write(jsonObject.toString());
            writer.flush();
            int responseCode = this.urlConnection.getResponseCode();
            String line = "";
            if (responseCode == 200) {
                StringBuffer response = new StringBuffer();
                BufferedReader br = new BufferedReader(new InputStreamReader(this.urlConnection.getInputStream()));
                while ((line = br.readLine()) != null) {
                    response.append(line);
                    Log.d((String)TAG, (String)line);
                }
                br.close();
                String string = response.toString();
                return string;
            }
            try {
                throw new IOException("Unexpected responseCode: " + responseCode);
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)e.toString());
                String string = null;
                return string;
            }
        }
        finally {
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    public String callApiMethod(JSONObject jsonObject, String method) {
        try {
            jsonObject.accumulate("method", (Object)method);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)e.toString());
        }
        return this.callApi(jsonObject);
    }
}

