/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;

public class LocaleHelper {
    public static Context onAttach(Context context, String string2) {
        return LocaleHelper.setLocale(context, LocaleHelper.getLanguage(string2));
    }

    private static String getLanguage(String string2) {
        if (string2 == null) {
            return Locale.getDefault().getLanguage();
        }
        if (string2.toLowerCase().trim().equals("uz")) {
            return string2;
        }
        return Locale.getDefault().getLanguage();
    }

    private static Context setLocale(Context context, String string2) {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleHelper.updateResources(context, string2);
        }
        return LocaleHelper.updateResourcesLegacy(context, string2);
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, String string2) {
        Locale locale = new Locale(string2);
        Locale.setDefault(locale);
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        return context.createConfigurationContext(configuration);
    }

    private static Context updateResourcesLegacy(Context context, String string2) {
        Locale locale = new Locale(string2);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return context;
    }
}

