/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment.api.task;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Parcelable;
import java.lang.ref.WeakReference;
import org.json.JSONObject;
import uz.paycom.payment.ConfirmActivity;
import uz.paycom.payment.PaymentActivity;
import uz.paycom.payment.R;
import uz.paycom.payment.api.JsonParser;
import uz.paycom.payment.api.JsonRpcRequest;

public class VerifyCardTask
extends AsyncTask<Void, Void, String> {
    private Double amount;
    private boolean hasError;
    private boolean save;
    private JsonParser jsonParser = new JsonParser();
    private String id;
    private String number;
    private String expire;
    private String token;
    private WeakReference<PaymentActivity> weakActivity;

    public VerifyCardTask(PaymentActivity paymentActivity) {
        this.weakActivity = new WeakReference<PaymentActivity>(paymentActivity);
    }

    protected void onPreExecute() {
        PaymentActivity paymentActivity = (PaymentActivity)((Object)this.weakActivity.get());
        if (paymentActivity != null) {
            this.id = PaymentActivity.id;
            this.amount = paymentActivity.amount * 100.0;
            this.number = paymentActivity.activityMainCardNumber.getText().toString().replace(" ", "");
            this.expire = paymentActivity.activityMainDateExpire.getText().toString().replace("/", "");
            this.save = paymentActivity.activityMainCardRemember.isChecked();
        }
    }

    protected String doInBackground(Void ... voidArray) {
        JsonRpcRequest jsonRpcRequest = new JsonRpcRequest(this.id);
        JSONObject jSONObject = this.jsonParser.getCardsCreate(this.number, this.expire, this.amount, this.save);
        String string2 = jsonRpcRequest.callApiMethod(jSONObject, "cards.create");
        if (string2 == null) {
            return null;
        }
        if (this.jsonParser.checkError(string2) != null) {
            this.hasError = true;
            return this.jsonParser.checkError(string2);
        }
        this.token = this.jsonParser.getCardToken(string2);
        jSONObject = this.jsonParser.getCardsVerifyCode(this.token);
        string2 = jsonRpcRequest.callApiMethod(jSONObject, "cards.get_verify_code");
        return string2;
    }

    protected void onPostExecute(String string2) {
        PaymentActivity paymentActivity = (PaymentActivity)((Object)this.weakActivity.get());
        if (paymentActivity == null) {
            return;
        }
        if (string2 == null) {
            paymentActivity.showError(paymentActivity.getString(R.string.tryAgainMessage));
        } else if (this.hasError) {
            paymentActivity.showError(string2);
        } else {
            Intent intent = new Intent((Context)paymentActivity, ConfirmActivity.class);
            intent.putExtra("CONFIRM", (Parcelable)this.jsonParser.getConfirm(string2));
            intent.putExtra("TOKEN", this.token);
            intent.putExtra("LANG", paymentActivity.lang);
            intent.setFlags(0x2000000);
            paymentActivity.startActivity(intent);
            paymentActivity.finish();
        }
        paymentActivity.activityMainContinue.setEnabled(true);
        paymentActivity.activityMainProgress.setVisibility(8);
    }
}

