/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment.api;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;
import uz.paycom.payment.api.TLSSocketFactory;
import uz.paycom.payment.utils.PaycomSandBox;

public class JsonRpcRequest {
    private static final String TAG = "JsonRpcRequest";
    public static final String cardsCreateMethod = "cards.create";
    public static final String cardsGetVerifyCodeMethod = "cards.get_verify_code";
    public static final String cardsCreateVerifyMethod = "cards.verify";
    private final String xAuth;
    private HttpsURLConnection urlConnection;

    public JsonRpcRequest(String string) {
        this.xAuth = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callApi(JSONObject jSONObject) {
        try {
            String string = PaycomSandBox.isSandBox() ? "https://checkout.test.paycom.uz/api" : "https://checkout.paycom.uz/api";
            Log.d((String)TAG, (String)string);
            URL uRL = new URL(string);
            this.urlConnection = (HttpsURLConnection)uRL.openConnection();
            try {
                this.urlConnection.setSSLSocketFactory(new TLSSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                Log.d((String)TAG, (String)generalSecurityException.toString());
            }
            this.urlConnection.setRequestMethod("POST");
            this.urlConnection.addRequestProperty("X-Auth", this.xAuth);
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setUseCaches(false);
            this.urlConnection.setConnectTimeout(30000);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.urlConnection.getOutputStream());
            outputStreamWriter.write(jSONObject.toString());
            outputStreamWriter.flush();
            Log.d((String)TAG, (String)jSONObject.toString());
            int n = this.urlConnection.getResponseCode();
            String string2 = "";
            if (n == 200) {
                StringBuffer stringBuffer = new StringBuffer();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.urlConnection.getInputStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    Log.d((String)TAG, (String)string2);
                }
                bufferedReader.close();
                String string3 = stringBuffer.toString();
                return string3;
            }
            try {
                throw new IOException("Unexpected responseCode: " + n);
            }
            catch (IOException iOException) {
                Log.d((String)TAG, (String)iOException.toString());
                uRL = null;
                return uRL;
            }
        }
        finally {
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    public String callApiMethod(JSONObject jSONObject, String string) {
        try {
            Log.d((String)TAG, (String)string);
            jSONObject.accumulate("method", (Object)string);
        }
        catch (JSONException jSONException) {
            Log.d((String)TAG, (String)jSONException.toString());
        }
        return this.callApi(jSONObject);
    }
}

