/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import uz.paycom.payment.R;
import uz.paycom.payment.api.task.VerifyCardTask;
import uz.paycom.payment.utils.CardNumberFormat;
import uz.paycom.payment.utils.DateExpireFormat;
import uz.paycom.payment.utils.LocaleHelper;
import uz.paycom.payment.utils.PaycomSandBox;

public class PaymentActivity
extends AppCompatActivity {
    public static String id;
    public static final String EXTRA_ID = "ID";
    public static final String EXTRA_LANG = "LANG";
    public static final String EXTRA_SAVE = "SAVE";
    public static final String EXTRA_AMOUNT = "AMOUNT";
    public static final String EXTRA_RESULT = "RESULT";
    private TextView activityMainClose;
    private TextView activityMainPaymentSum;
    private TextView activityMainErrorMessage;
    private TextView activityMainPaymentSumTitle;
    private TextView activityMainErrorLayoutError;
    private TextView activityMainCardNumberTitle;
    private TextView activityMainUzcardOnlyText;
    private TextView activityMainDateExpireTitle;
    private RelativeLayout activityMainErrorLayout;
    private DecimalFormat decimalFormat;
    public EditText activityMainCardNumber;
    public EditText activityMainDateExpire;
    public CheckBox activityMainCardRemember;
    public Button activityMainContinue;
    public ProgressBar activityMainProgress;
    public String lang;
    public Double amount;
    public boolean save;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.paycom_payment_main);
        this.activityMainClose = (TextView)this.findViewById(R.id.activity_main_close);
        this.activityMainContinue = (Button)this.findViewById(R.id.activity_main_continue);
        this.activityMainProgress = (ProgressBar)this.findViewById(R.id.activity_main_progress);
        this.activityMainErrorLayout = (RelativeLayout)this.findViewById(R.id.activity_main_errorLayout);
        this.activityMainCardNumber = (EditText)this.findViewById(R.id.activity_main_cardNumber);
        this.activityMainPaymentSum = (TextView)this.findViewById(R.id.activity_main_paymentSum);
        this.activityMainDateExpire = (EditText)this.findViewById(R.id.activity_main_dateExpire);
        this.activityMainErrorMessage = (TextView)this.findViewById(R.id.activity_main_errorMessage);
        this.activityMainCardRemember = (CheckBox)this.findViewById(R.id.activity_main_cardRemember);
        this.activityMainUzcardOnlyText = (TextView)this.findViewById(R.id.activity_main_uzcardOnlyText);
        this.activityMainCardNumberTitle = (TextView)this.findViewById(R.id.activity_main_cardNumberTitle);
        this.activityMainPaymentSumTitle = (TextView)this.findViewById(R.id.activity_main_paymentSumTitle);
        this.activityMainDateExpireTitle = (TextView)this.findViewById(R.id.activity_main_dateExpireTitle);
        this.activityMainErrorLayoutError = (TextView)this.findViewById(R.id.activity_main_errorLayout_error);
        this.initUI();
        this.activityMainCardNumber.addTextChangedListener((TextWatcher)new CardNumberFormat((View)this.activityMainContinue, this.activityMainDateExpire));
        this.activityMainDateExpire.addTextChangedListener((TextWatcher)new DateExpireFormat((View)this.activityMainContinue, this.activityMainCardNumber));
        this.activityMainContinue.setEnabled(false);
        this.activityMainContinue.setAlpha(0.3f);
        this.activityMainContinue.setClickable(false);
        this.activityMainContinue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = PaymentActivity.this.activityMainCardNumber.getText().toString().replace(" ", "");
                if (!PaymentActivity.isOnline(string2) && !PaycomSandBox.isSandBox()) {
                    PaymentActivity.this.showError(PaymentActivity.this.getString(R.string.uzcardOnly));
                    return;
                }
                if (!PaymentActivity.isValid(string2)) {
                    PaymentActivity.this.showError(PaymentActivity.this.getString(R.string.invalidCard));
                }
                new VerifyCardTask(PaymentActivity.this).execute(new Void[0]);
                PaymentActivity.this.activityMainContinue.setEnabled(false);
                PaymentActivity.this.activityMainProgress.setVisibility(0);
                PaymentActivity.this.activityMainErrorLayout.setVisibility(8);
            }
        });
        this.activityMainClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PaymentActivity.this.activityMainErrorLayout.setVisibility(8);
            }
        });
    }

    private void initUI() {
        this.lang = this.getIntent().getStringExtra(EXTRA_LANG);
        Context context = LocaleHelper.onAttach((Context)this, this.lang);
        Resources resources = context.getResources();
        this.setTitle(resources.getString(R.string.paycomTitle));
        this.activityMainErrorLayoutError.setText((CharSequence)resources.getString(R.string.error));
        this.activityMainClose.setText((CharSequence)resources.getString(R.string.close));
        this.activityMainPaymentSumTitle.setText((CharSequence)resources.getString(R.string.paymentSum));
        this.activityMainCardNumberTitle.setText((CharSequence)resources.getString(R.string.cardNumber));
        this.activityMainUzcardOnlyText.setText((CharSequence)resources.getString(R.string.uzcardOnly));
        this.activityMainDateExpireTitle.setText((CharSequence)resources.getString(R.string.dateExpire));
        this.activityMainDateExpire.setHint((CharSequence)resources.getString(R.string.dateExpireHint));
        this.activityMainContinue.setText((CharSequence)resources.getString(R.string.continueText));
        this.activityMainCardRemember.setText((CharSequence)resources.getString(R.string.cardRemember));
        id = this.getIntent().getStringExtra(EXTRA_ID);
        this.amount = this.getIntent().getDoubleExtra(EXTRA_AMOUNT, 0.0);
        this.amount = Math.floor(this.amount * 100.0) / 100.0;
        this.save = this.getIntent().getBooleanExtra(EXTRA_SAVE, false);
        if (this.amount <= 0.0) {
            this.setResult(0);
            this.finish();
        }
        this.activityMainPaymentSum.setText((CharSequence)(this.formatMoney(this.amount, true) + " " + resources.getString(R.string.card_balance_currency)));
        this.activityMainCardRemember.setVisibility(this.save ? 0 : 8);
    }

    public static boolean isValid(String string2) {
        int n = 0;
        boolean bl = false;
        for (int i = string2.length() - 1; i >= 0; --i) {
            int n2 = Integer.parseInt(string2.substring(i, i + 1));
            if (bl && (n2 *= 2) > 9) {
                n2 = n2 % 10 + 1;
            }
            n += n2;
            bl = !bl;
        }
        return n % 10 == 0;
    }

    public String formatMoney(double d, boolean bl) {
        if (this.decimalFormat == null) {
            this.decimalFormat = new DecimalFormat("###,###,###.00");
            this.decimalFormat.setGroupingSize(3);
            this.decimalFormat.setMinimumFractionDigits(0);
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(' ');
            DecimalFormatSymbols decimalFormatSymbols2 = this.decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(decimalFormatSymbols2.getDecimalSeparator());
            this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        this.decimalFormat.setMinimumFractionDigits(bl ? 2 : 0);
        this.decimalFormat.setMaximumFractionDigits(bl ? 2 : 0);
        return this.decimalFormat.format(d);
    }

    public static boolean isOnline(String string2) {
        return string2.substring(0, 4).equals("8600");
    }

    public void showError(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.activityMainErrorLayout.setVisibility(0);
            this.activityMainErrorMessage.setText((CharSequence)string2);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
    }
}

