/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;

public class LocaleHelper {
    public static Context onAttach(Context context, String language) {
        return LocaleHelper.setLocale(context, LocaleHelper.getLanguage(language));
    }

    private static String getLanguage(String language) {
        if (language == null) {
            return Locale.getDefault().getLanguage();
        }
        if (language.toLowerCase().trim().equals("uz")) {
            return language;
        }
        return Locale.getDefault().getLanguage();
    }

    private static Context setLocale(Context context, String language) {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleHelper.updateResources(context, language);
        }
        return LocaleHelper.updateResourcesLegacy(context, language);
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        return context.createConfigurationContext(configuration);
    }

    private static Context updateResourcesLegacy(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return context;
    }
}

