/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import org.json.JSONObject;
import uz.paycom.payment.PaymentActivity;
import uz.paycom.payment.R;
import uz.paycom.payment.api.JsonParser;
import uz.paycom.payment.api.JsonRpcRequest;
import uz.paycom.payment.model.Confirm;
import uz.paycom.payment.utils.LocaleHelper;

public class ConfirmActivity
extends AppCompatActivity {
    public static final String ARG_CONFIRM = "CONFIRM";
    public static final String ARG_TOKEN = "TOKEN";
    private String token;
    private RelativeLayout activityConfirmErrorLayout;
    private TextView activityConfirmError;
    private TextView activityConfirmErrorMessage;
    private TextView activityConfirmClose;
    private ProgressBar activityConfirmProgress;
    private TextView activityConfirmTimer;
    private ImageView activityRepeatImage;
    private TextView activityConfirmCodeConfirmTitle;
    private EditText activityConfirmCodeConfirm;
    private TextView activityConfirmPhoneNumberTitle;
    private TextView activityConfirmPhoneNumber;
    private Button activityConfirmButton;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.paycom_payment_confirm);
        this.getWindow().setSoftInputMode(16);
        this.activityConfirmErrorLayout = (RelativeLayout)this.findViewById(R.id.activity_confirm_errorLayout);
        this.activityConfirmError = (TextView)this.findViewById(R.id.activity_confirm_error);
        this.activityConfirmErrorMessage = (TextView)this.findViewById(R.id.activity_confirm_errorMessage);
        this.activityConfirmClose = (TextView)this.findViewById(R.id.activity_confirm_close);
        this.activityConfirmProgress = (ProgressBar)this.findViewById(R.id.activity_confirm_progress);
        this.activityConfirmTimer = (TextView)this.findViewById(R.id.activity_confirm_timer);
        this.activityRepeatImage = (ImageView)this.findViewById(R.id.activity_repeat_image);
        this.activityConfirmCodeConfirmTitle = (TextView)this.findViewById(R.id.activity_confirm_codeConfirmTitle);
        this.activityConfirmCodeConfirm = (EditText)this.findViewById(R.id.activity_confirm_codeConfirm);
        this.activityConfirmPhoneNumberTitle = (TextView)this.findViewById(R.id.activity_confirm_phoneNumberTitle);
        this.activityConfirmPhoneNumber = (TextView)this.findViewById(R.id.activity_confirm_phoneNumber);
        this.activityConfirmButton = (Button)this.findViewById(R.id.activity_confirm_button);
        Context context = LocaleHelper.onAttach((Context)this, this.getIntent().getStringExtra("LANG"));
        Resources resources = context.getResources();
        this.setTitle(resources.getString(R.string.paycomTitle));
        this.activityConfirmError.setText((CharSequence)resources.getString(R.string.error));
        this.activityConfirmClose.setText((CharSequence)resources.getString(R.string.close));
        this.activityConfirmCodeConfirmTitle.setText((CharSequence)resources.getString(R.string.codeConfirm));
        this.activityConfirmPhoneNumberTitle.setText((CharSequence)resources.getString(R.string.codeSent));
        this.activityConfirmButton.setText((CharSequence)resources.getString(R.string.confirm));
        this.activityConfirmCodeConfirmTitle.setText((CharSequence)resources.getString(R.string.codeConfirm));
        this.initUI(null);
        this.token = this.getIntent().getStringExtra(ARG_TOKEN);
        this.activityConfirmButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmActivity.this.activityConfirmErrorLayout.setVisibility(8);
                ConfirmActivity.this.activityConfirmButton.setEnabled(false);
                ConfirmActivity.this.activityConfirmProgress.setVisibility(0);
                new ConfirmTask().execute(new Void[0]);
            }
        });
        this.activityConfirmClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmActivity.this.activityConfirmErrorLayout.setVisibility(8);
            }
        });
        this.activityRepeatImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmActivity.this.activityConfirmErrorLayout.setVisibility(8);
                ConfirmActivity.this.activityConfirmButton.setEnabled(false);
                ConfirmActivity.this.activityConfirmProgress.setVisibility(0);
                new RetryTask().execute(new Void[0]);
            }
        });
    }

    private void initUI(Confirm confirm) {
        if (confirm == null) {
            confirm = (Confirm)this.getIntent().getParcelableExtra(ARG_CONFIRM);
        }
        this.activityConfirmPhoneNumber.setText((CharSequence)confirm.getPhone());
        this.activityRepeatImage.setVisibility(8);
        this.activityConfirmTimer.setVisibility(0);
        new CountDownTimer(confirm.getWait(), 1000L){

            public void onTick(long millisUntilFinished) {
                ConfirmActivity.this.activityConfirmTimer.setText((CharSequence)("0:" + String.valueOf(millisUntilFinished / 1000L)));
            }

            public void onFinish() {
                ConfirmActivity.this.activityRepeatImage.setVisibility(0);
                ConfirmActivity.this.activityConfirmTimer.setVisibility(8);
            }
        }.start();
    }

    private void showError(String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            this.activityConfirmErrorLayout.setVisibility(0);
            this.activityConfirmErrorMessage.setText((CharSequence)s);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
    }

    private class RetryTask
    extends AsyncTask<Void, Void, String> {
        private boolean hasError;
        private JsonParser jsonParser = new JsonParser();

        protected String doInBackground(Void ... params) {
            JsonRpcRequest jsonRpcRequest = new JsonRpcRequest(PaymentActivity.id);
            JSONObject jsonObject = this.jsonParser.getCardsVerifyCode(ConfirmActivity.this.token);
            String result = jsonRpcRequest.callApiMethod(jsonObject, "cards.get_verify_code");
            if (result == null) {
                return null;
            }
            if (this.jsonParser.checkError(result) != null) {
                this.hasError = true;
                return this.jsonParser.checkError(result);
            }
            return result;
        }

        protected void onPostExecute(String s) {
            if (s == null) {
                ConfirmActivity.this.showError(ConfirmActivity.this.getString(R.string.tryAgainMessage));
            } else if (this.hasError) {
                ConfirmActivity.this.showError(s);
            } else {
                ConfirmActivity.this.initUI(this.jsonParser.getConfirm(s));
            }
            ConfirmActivity.this.activityConfirmButton.setEnabled(true);
            ConfirmActivity.this.activityConfirmProgress.setVisibility(8);
        }
    }

    private class ConfirmTask
    extends AsyncTask<Void, Void, String> {
        private String code;
        private boolean hasError;
        private JsonParser jsonParser = new JsonParser();

        protected void onPreExecute() {
            this.code = ConfirmActivity.this.activityConfirmCodeConfirm.getText().toString();
        }

        protected String doInBackground(Void ... params) {
            JsonRpcRequest jsonRpcRequest = new JsonRpcRequest(PaymentActivity.id);
            JSONObject jsonObject = this.jsonParser.getCardsVerify(ConfirmActivity.this.token, this.code);
            String result = jsonRpcRequest.callApiMethod(jsonObject, "cards.verify");
            if (result == null) {
                return null;
            }
            if (this.jsonParser.checkError(result) != null) {
                this.hasError = true;
                return this.jsonParser.checkError(result);
            }
            return result;
        }

        protected void onPostExecute(String s) {
            if (s == null) {
                ConfirmActivity.this.showError(ConfirmActivity.this.getString(R.string.tryAgainMessage));
            } else if (this.hasError) {
                ConfirmActivity.this.showError(s);
            } else {
                Intent intent = new Intent();
                intent.putExtra("RESULT", (Parcelable)this.jsonParser.getResult(s));
                ConfirmActivity.this.setResult(-1, intent);
                ConfirmActivity.this.finish();
            }
            ConfirmActivity.this.activityConfirmButton.setEnabled(true);
            ConfirmActivity.this.activityConfirmProgress.setVisibility(8);
        }
    }
}

