/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.cfg.SerializerFactoryConfig;
import tools.jackson.databind.ext.OptionalHandlerFactory;
import tools.jackson.databind.ext.jdk8.DoubleStreamSerializer;
import tools.jackson.databind.ext.jdk8.IntStreamSerializer;
import tools.jackson.databind.ext.jdk8.Jdk8OptionalSerializer;
import tools.jackson.databind.ext.jdk8.Jdk8StreamSerializer;
import tools.jackson.databind.ext.jdk8.LongStreamSerializer;
import tools.jackson.databind.ext.jdk8.OptionalDoubleSerializer;
import tools.jackson.databind.ext.jdk8.OptionalIntSerializer;
import tools.jackson.databind.ext.jdk8.OptionalLongSerializer;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BasicBeanDescription;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.jackson.JacksonSerializableSerializer;
import tools.jackson.databind.ser.jackson.JsonValueSerializer;
import tools.jackson.databind.ser.jdk.AtomicReferenceSerializer;
import tools.jackson.databind.ser.jdk.BooleanSerializer;
import tools.jackson.databind.ser.jdk.ByteBufferSerializer;
import tools.jackson.databind.ser.jdk.CollectionSerializer;
import tools.jackson.databind.ser.jdk.EnumSerializer;
import tools.jackson.databind.ser.jdk.EnumSetSerializer;
import tools.jackson.databind.ser.jdk.IndexedListSerializer;
import tools.jackson.databind.ser.jdk.IndexedStringListSerializer;
import tools.jackson.databind.ser.jdk.InetAddressSerializer;
import tools.jackson.databind.ser.jdk.InetSocketAddressSerializer;
import tools.jackson.databind.ser.jdk.IterableSerializer;
import tools.jackson.databind.ser.jdk.IteratorSerializer;
import tools.jackson.databind.ser.jdk.JDKArraySerializers;
import tools.jackson.databind.ser.jdk.JDKKeySerializers;
import tools.jackson.databind.ser.jdk.JDKMiscSerializers;
import tools.jackson.databind.ser.jdk.JDKStringLikeSerializer;
import tools.jackson.databind.ser.jdk.JavaUtilCalendarSerializer;
import tools.jackson.databind.ser.jdk.JavaUtilDateSerializer;
import tools.jackson.databind.ser.jdk.MapEntrySerializer;
import tools.jackson.databind.ser.jdk.MapSerializer;
import tools.jackson.databind.ser.jdk.NumberSerializer;
import tools.jackson.databind.ser.jdk.NumberSerializers;
import tools.jackson.databind.ser.jdk.ObjectArraySerializer;
import tools.jackson.databind.ser.jdk.StringArraySerializer;
import tools.jackson.databind.ser.jdk.StringCollectionSerializer;
import tools.jackson.databind.ser.jdk.StringSerializer;
import tools.jackson.databind.ser.jdk.TimeZoneSerializer;
import tools.jackson.databind.ser.std.ReferenceTypeSerializer;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.ser.std.StdDelegatingSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.ser.std.ToEmptyObjectSerializer;
import tools.jackson.databind.ser.std.ToStringSerializer;
import tools.jackson.databind.type.ArrayType;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.MapType;
import tools.jackson.databind.type.ReferenceType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, ValueSerializer<?>> _concrete;
    protected final SerializerFactoryConfig _factoryConfig;

    protected BasicSerializerFactory(SerializerFactoryConfig config) {
        this._factoryConfig = config == null ? new SerializerFactoryConfig() : config;
    }

    protected abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(additional));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(additional));
    }

    @Override
    public final SerializerFactory withSerializerModifier(ValueSerializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(modifier));
    }

    @Override
    public final SerializerFactory withNullValueSerializer(ValueSerializer<?> nvs) {
        return this.withConfig(this._factoryConfig.withNullValueSerializer(nvs));
    }

    @Override
    public final SerializerFactory withNullKeySerializer(ValueSerializer<?> nks) {
        return this.withConfig(this._factoryConfig.withNullKeySerializer(nks));
    }

    @Override
    public ValueSerializer<Object> createKeySerializer(SerializationContext ctxt, JavaType keyType) {
        BeanDescription.Supplier beanDescRef = ctxt.lazyIntrospectBeanDescription(keyType);
        SerializationConfig config = ctxt.getConfig();
        JsonValueSerializer ser = null;
        if (this._factoryConfig.hasKeySerializers()) {
            Serializers serializers;
            Iterator<Object> iterator = this._factoryConfig.keySerializers().iterator();
            while (iterator.hasNext() && (ser = (serializers = iterator.next()).findSerializer(config, keyType, beanDescRef, null)) == null) {
            }
        }
        if (ser == null && (ser = this._findKeySerializer(ctxt, beanDescRef.getClassInfo())) == null && (ser = JDKKeySerializers.getStdKeySerializer(config, keyType.getRawClass(), false)) == null) {
            BeanDescription beanDesc = beanDescRef.get();
            AnnotatedMember acc = beanDesc.findJsonKeyAccessor();
            if (acc == null) {
                acc = beanDesc.findJsonValueAccessor();
            }
            if (acc != null) {
                ValueSerializer<Object> delegate = this.createKeySerializer(ctxt, acc.getType());
                if (config.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(acc.getMember(), config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                ser = JsonValueSerializer.construct(config, keyType, acc.getType(), false, null, delegate, acc);
            } else {
                ser = JDKKeySerializers.getFallbackKeySerializer(config, keyType.getRawClass(), beanDesc.getClassInfo());
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyKeySerializer(config, keyType, beanDescRef, ser);
            }
        }
        return ser;
    }

    @Override
    public ValueSerializer<Object> getDefaultNullKeySerializer() {
        return this._factoryConfig.getNullKeySerializer();
    }

    @Override
    public ValueSerializer<Object> getDefaultNullValueSerializer() {
        return this._factoryConfig.getNullValueSerializer();
    }

    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    public TypeSerializer findPropertyContentTypeSerializer(SerializationContext ctxt, JavaType containerType, AnnotatedMember accessor) {
        return ctxt.getConfig().getTypeResolverProvider().findPropertyContentTypeSerializer(ctxt, accessor, containerType);
    }

    protected final ValueSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BeanDescription.Supplier beanDescRef, JsonFormat.Value format, boolean staticTyping) {
        Class<?> raw = type.getRawClass();
        ValueSerializer<?> ser = JDKMiscSerializers.find(raw);
        if (ser == null) {
            String clsName = raw.getName();
            ser = _concrete.get(clsName);
        }
        return ser;
    }

    protected final ValueSerializer<?> findSerializerByAnnotations(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef) {
        Class<?> raw = type.getRawClass();
        if (JacksonSerializable.class.isAssignableFrom(raw)) {
            return JacksonSerializableSerializer.instance;
        }
        AnnotatedMember valueAccessor = beanDescRef.get().findJsonValueAccessor();
        if (valueAccessor != null) {
            if (ctxt.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(valueAccessor.getMember(), ctxt.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            ValueSerializer<Object> ser = this.findSerializerFromAnnotation(ctxt, valueAccessor);
            JavaType valueType = valueAccessor.getType();
            TypeSerializer vts = ctxt.findTypeSerializer(valueType);
            return JsonValueSerializer.construct(ctxt.getConfig(), type, valueType, false, vts, ser, valueAccessor);
        }
        return null;
    }

    protected final ValueSerializer<?> findSerializerByPrimaryType(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, boolean staticTyping) {
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            return JavaUtilCalendarSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            ValueSerializer<?> ser;
            if (!type.hasRawClass(Date.class) && (ser = OptionalHandlerFactory.instance.findSerializer(ctxt.getConfig(), type)) != null) {
                return ser;
            }
            return JavaUtilDateSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(Stream.class)) {
            return new Jdk8StreamSerializer(type, ctxt.getTypeFactory().findFirstTypeParameter(type, Stream.class));
        }
        if (type.isTypeOrSubTypeOf(Number.class)) {
            JsonFormat.Value format = this._calculateEffectiveFormat(beanDescRef, Number.class, formatOverrides);
            switch (format.getShape()) {
                case STRING: {
                    return ToStringSerializer.instance;
                }
                case OBJECT: {
                    return null;
                }
            }
            return NumberSerializer.instance;
        }
        if (type.isEnumType()) {
            return this.buildEnumSerializer(ctxt, type, beanDescRef, this._calculateEffectiveFormat(beanDescRef, Enum.class, formatOverrides));
        }
        Class<?> raw = type.getRawClass();
        if (Map.Entry.class.isAssignableFrom(raw)) {
            JavaType mapEntryType = type.findSuperType(Map.Entry.class);
            JavaType kt = mapEntryType.containedTypeOrUnknown(0);
            JavaType vt = mapEntryType.containedTypeOrUnknown(1);
            return this.buildMapEntrySerializer(ctxt, type, beanDescRef, this._calculateEffectiveFormat(beanDescRef, Map.Entry.class, formatOverrides), staticTyping, kt, vt);
        }
        if (ByteBuffer.class.isAssignableFrom(raw)) {
            return new ByteBufferSerializer();
        }
        if (InetAddress.class.isAssignableFrom(raw)) {
            return new InetAddressSerializer();
        }
        if (InetSocketAddress.class.isAssignableFrom(raw)) {
            return new InetSocketAddressSerializer();
        }
        if (TimeZone.class.isAssignableFrom(raw)) {
            return new TimeZoneSerializer();
        }
        if (Charset.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (LongStream.class.isAssignableFrom(raw)) {
            return LongStreamSerializer.INSTANCE;
        }
        if (IntStream.class.isAssignableFrom(raw)) {
            return IntStreamSerializer.INSTANCE;
        }
        if (DoubleStream.class.isAssignableFrom(raw)) {
            return DoubleStreamSerializer.INSTANCE;
        }
        if (Path.class.isAssignableFrom(raw)) {
            return JDKStringLikeSerializer.find(Path.class);
        }
        if (ClassLoader.class.isAssignableFrom(raw)) {
            return new ToEmptyObjectSerializer(type);
        }
        return OptionalHandlerFactory.instance.findSerializer(ctxt.getConfig(), type);
    }

    protected final ValueSerializer<?> findSerializerByAddonType(SerializationContext ctxt, JavaType javaType, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, boolean staticTyping) {
        TypeFactory tf = ctxt.getTypeFactory();
        if (javaType.isTypeOrSubTypeOf(Iterator.class)) {
            return this.buildIteratorSerializer(ctxt, javaType, beanDescRef, formatOverrides, staticTyping, tf.findFirstTypeParameter(javaType, Iterator.class));
        }
        if (javaType.isTypeOrSubTypeOf(Iterable.class)) {
            return this.buildIterableSerializer(ctxt, javaType, beanDescRef, formatOverrides, staticTyping, tf.findFirstTypeParameter(javaType, Iterable.class));
        }
        if (javaType.isTypeOrSubTypeOf(CharSequence.class)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected ValueSerializer<Object> findSerializerFromAnnotation(SerializationContext ctxt, Annotated a) {
        Object serDef = ctxt.getAnnotationIntrospector().findSerializer(ctxt.getConfig(), a);
        if (serDef == null) {
            return null;
        }
        return this.findConvertingSerializer(ctxt, a, ctxt.serializerInstance(a, serDef));
    }

    protected ValueSerializer<?> findConvertingSerializer(SerializationContext ctxt, Annotated a, ValueSerializer<?> ser) {
        Converter<Object, Object> conv = this.findConverter(ctxt, a);
        if (conv == null) {
            return ser;
        }
        JavaType delegateType = conv.getOutputType(ctxt.getTypeFactory());
        return new StdDelegatingSerializer(conv, delegateType, ser, null);
    }

    protected Converter<Object, Object> findConverter(SerializationContext ctxt, Annotated a) {
        Object convDef = ctxt.getAnnotationIntrospector().findSerializationConverter(ctxt.getConfig(), a);
        if (convDef == null) {
            return null;
        }
        return ctxt.converterInstance(a, convDef);
    }

    protected ValueSerializer<?> buildContainerSerializer(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, boolean staticTyping) {
        JavaType elementType;
        TypeSerializer elementTypeSerializer;
        if (!(staticTyping || !type.useStaticType() || type.isContainerType() && type.getContentType().isJavaLangObject())) {
            staticTyping = true;
        }
        if ((elementTypeSerializer = ctxt.findTypeSerializer(elementType = type.getContentType())) != null) {
            staticTyping = false;
        }
        ValueSerializer<Object> elementValueSerializer = this._findContentSerializer(ctxt, beanDescRef.getClassInfo());
        SerializationConfig config = ctxt.getConfig();
        if (type.isMapLikeType()) {
            Serializers serializers;
            MapLikeType mlt = (MapLikeType)type;
            ValueSerializer<Object> keySerializer = this._findKeySerializer(ctxt, beanDescRef.getClassInfo());
            if (mlt instanceof MapType) {
                return this.buildMapSerializer(ctxt, (MapType)mlt, beanDescRef, formatOverrides, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            ValueSerializer<?> ser = null;
            MapLikeType mlType = (MapLikeType)type;
            Iterator<Object> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (ser = (serializers = iterator.next()).findMapLikeSerializer(config, mlType, beanDescRef, formatOverrides, keySerializer, elementTypeSerializer, elementValueSerializer)) == null) {
            }
            if (ser == null) {
                ser = this.findSerializerByAnnotations(ctxt, type, beanDescRef);
            }
            if (ser != null && this._factoryConfig.hasSerializerModifiers()) {
                for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                    ser = mod.modifyMapLikeSerializer(config, mlType, beanDescRef, ser);
                }
            }
            return ser;
        }
        if (type.isCollectionLikeType()) {
            Serializers serializers;
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt instanceof CollectionType) {
                return this.buildCollectionSerializer(ctxt, (CollectionType)clt, beanDescRef, formatOverrides, staticTyping, elementTypeSerializer, elementValueSerializer);
            }
            ValueSerializer<?> ser = null;
            CollectionLikeType clType = (CollectionLikeType)type;
            Iterator<Object> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (ser = (serializers = iterator.next()).findCollectionLikeSerializer(config, clType, beanDescRef, formatOverrides, elementTypeSerializer, elementValueSerializer)) == null) {
            }
            if (ser == null) {
                ser = this.findSerializerByAnnotations(ctxt, type, beanDescRef);
            }
            if (ser != null && this._factoryConfig.hasSerializerModifiers()) {
                for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                    ser = mod.modifyCollectionLikeSerializer(config, clType, beanDescRef, ser);
                }
            }
            return ser;
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(ctxt, (ArrayType)type, beanDescRef, formatOverrides, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    protected ValueSerializer<?> buildCollectionSerializer(SerializationContext ctxt, CollectionType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, boolean staticTyping, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        Serializers serializers;
        SerializationConfig config = ctxt.getConfig();
        StdSerializer ser = null;
        Iterator<Serializers> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (ser = (serializers = iterator.next()).findCollectionSerializer(config, type, beanDescRef, formatOverrides, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        JsonFormat.Value format = this._calculateEffectiveFormat(beanDescRef, Collection.class, formatOverrides);
        if (ser == null && (ser = this.findSerializerByAnnotations(ctxt, type, beanDescRef)) == null) {
            if (format.getShape() == JsonFormat.Shape.POJO) {
                return null;
            }
            Class<?> raw = type.getRawClass();
            if (EnumSet.class.isAssignableFrom(raw)) {
                JavaType enumType = type.getContentType();
                if (!enumType.isEnumImplType()) {
                    enumType = null;
                }
                ser = this.buildEnumSetSerializer(enumType);
            } else {
                Class<?> elementRaw = type.getContentType().getRawClass();
                if (this.isIndexedList(raw)) {
                    if (elementRaw == String.class) {
                        if (ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                            ser = IndexedStringListSerializer.instance;
                        }
                    } else {
                        ser = this.buildIndexedListSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                    }
                } else if (elementRaw == String.class && ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                    ser = StringCollectionSerializer.instance;
                }
                if (ser == null) {
                    ser = this.buildCollectionSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyCollectionSerializer(config, type, beanDescRef, ser);
            }
        }
        return ser;
    }

    protected boolean isIndexedList(Class<?> cls) {
        return RandomAccess.class.isAssignableFrom(cls);
    }

    public StdContainerSerializer<?> buildIndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> valueSerializer) {
        return new IndexedListSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    public StdContainerSerializer<?> buildCollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> valueSerializer) {
        return new CollectionSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    public ValueSerializer<?> buildEnumSetSerializer(JavaType enumType) {
        return new EnumSetSerializer(enumType);
    }

    protected ValueSerializer<?> buildMapSerializer(SerializationContext ctxt, MapType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, boolean staticTyping, ValueSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        Serializers serializers;
        JsonFormat.Value format = this._calculateEffectiveFormat(beanDescRef, Map.class, formatOverrides);
        if (format.getShape() == JsonFormat.Shape.POJO) {
            return null;
        }
        MapSerializer ser = null;
        SerializationConfig config = ctxt.getConfig();
        Iterator<Object> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (ser = (serializers = iterator.next()).findMapSerializer(config, type, beanDescRef, formatOverrides, keySerializer, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null && (ser = this.findSerializerByAnnotations(ctxt, type, beanDescRef)) == null) {
            Object filterId = this.findFilterId(config, beanDescRef);
            AnnotatedClass classInfo = beanDescRef.getClassInfo();
            JsonIgnoreProperties.Value ignorals = config.getDefaultPropertyIgnorals(Map.class, classInfo);
            Set ignored = ignorals == null ? null : ignorals.findIgnoredForSerialization();
            JsonIncludeProperties.Value inclusions = config.getDefaultPropertyInclusions(Map.class, classInfo);
            Set included = inclusions == null ? null : inclusions.getIncluded();
            MapSerializer mapSer = MapSerializer.construct(type, staticTyping, elementTypeSerializer, keySerializer, elementValueSerializer, filterId, ignored, included);
            ser = this._checkMapContentInclusion(ctxt, beanDescRef, mapSer);
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyMapSerializer(config, type, beanDescRef, ser);
            }
        }
        return ser;
    }

    protected MapSerializer _checkMapContentInclusion(SerializationContext ctxt, BeanDescription.Supplier beanDescRef, MapSerializer mapSer) {
        Object valueToSuppress;
        JsonInclude.Include incl;
        JavaType contentType = mapSer.getContentType();
        JsonInclude.Value inclV = this._findInclusionWithContent(ctxt, beanDescRef, contentType, Map.class);
        JsonInclude.Include include = incl = inclV == null ? JsonInclude.Include.USE_DEFAULTS : inclV.getContentInclusion();
        if (incl == JsonInclude.Include.USE_DEFAULTS || incl == JsonInclude.Include.ALWAYS) {
            return mapSer;
        }
        boolean suppressNulls = true;
        switch (incl) {
            case NON_DEFAULT: {
                valueToSuppress = BeanUtil.getDefaultValue(contentType);
                if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                break;
            }
            case NON_ABSENT: {
                valueToSuppress = contentType.isReferenceType() ? MapSerializer.MARKER_FOR_EMPTY : null;
                break;
            }
            case NON_EMPTY: {
                valueToSuppress = MapSerializer.MARKER_FOR_EMPTY;
                break;
            }
            case CUSTOM: {
                valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                if (valueToSuppress == null) break;
                suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                break;
            }
            default: {
                valueToSuppress = null;
            }
        }
        return mapSer.withContentInclusion(valueToSuppress, suppressNulls);
    }

    protected ValueSerializer<?> buildMapEntrySerializer(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value effectiveFormat, boolean staticTyping, JavaType keyType, JavaType valueType) {
        Object valueToSuppress;
        JsonInclude.Include incl;
        if (effectiveFormat.getShape() == JsonFormat.Shape.POJO) {
            return null;
        }
        MapEntrySerializer ser = new MapEntrySerializer(valueType, keyType, valueType, staticTyping, ctxt.findTypeSerializer(valueType), null);
        JavaType contentType = ser.getContentType();
        JsonInclude.Value inclV = this._findInclusionWithContent(ctxt, beanDescRef, contentType, Map.Entry.class);
        JsonInclude.Include include = incl = inclV == null ? JsonInclude.Include.USE_DEFAULTS : inclV.getContentInclusion();
        if (incl == JsonInclude.Include.USE_DEFAULTS || incl == JsonInclude.Include.ALWAYS) {
            return ser;
        }
        boolean suppressNulls = true;
        switch (incl) {
            case NON_DEFAULT: {
                valueToSuppress = BeanUtil.getDefaultValue(contentType);
                if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                break;
            }
            case NON_ABSENT: {
                valueToSuppress = contentType.isReferenceType() ? MapSerializer.MARKER_FOR_EMPTY : null;
                break;
            }
            case NON_EMPTY: {
                valueToSuppress = MapSerializer.MARKER_FOR_EMPTY;
                break;
            }
            case CUSTOM: {
                valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                if (valueToSuppress == null) break;
                suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                break;
            }
            default: {
                valueToSuppress = null;
            }
        }
        return ser.withContentInclusion(valueToSuppress, suppressNulls);
    }

    protected JsonInclude.Value _findInclusionWithContent(SerializationContext ctxt, BeanDescription.Supplier beanDescRef, JavaType contentType, Class<?> configType) {
        SerializationConfig config = ctxt.getConfig();
        JsonInclude.Value inclV = beanDescRef.get().findPropertyInclusion(config.getDefaultPropertyInclusion());
        inclV = config.getDefaultPropertyInclusion(configType, inclV);
        JsonInclude.Value valueIncl = config.getDefaultPropertyInclusion(contentType.getRawClass(), null);
        if (valueIncl != null) {
            switch (valueIncl.getValueInclusion()) {
                case USE_DEFAULTS: {
                    break;
                }
                case CUSTOM: {
                    inclV = inclV.withContentFilter(valueIncl.getContentFilter());
                    break;
                }
                default: {
                    inclV = inclV.withContentInclusion(valueIncl.getValueInclusion());
                }
            }
        }
        return inclV;
    }

    protected ValueSerializer<?> buildArraySerializer(SerializationContext ctxt, ArrayType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, boolean staticTyping, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        Serializers serializers;
        SerializationConfig config = ctxt.getConfig();
        ValueSerializer ser = null;
        Iterator<Object> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (ser = (serializers = iterator.next()).findArraySerializer(config, type, beanDescRef, formatOverrides, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            Class<?> raw = type.getRawClass();
            if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                ser = String[].class == raw ? StringArraySerializer.instance : JDKArraySerializers.findStandardImpl(raw);
            }
            if (ser == null) {
                ser = new ObjectArraySerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyArraySerializer(config, type, beanDescRef, ser);
            }
        }
        return ser;
    }

    public ValueSerializer<?> findReferenceSerializer(SerializationContext ctxt, ReferenceType refType, BeanDescription.Supplier beanDesc, JsonFormat.Value format, boolean staticTyping) {
        JavaType contentType = refType.getContentType();
        TypeSerializer contentTypeSerializer = (TypeSerializer)contentType.getTypeHandler();
        SerializationConfig config = ctxt.getConfig();
        if (contentTypeSerializer == null) {
            contentTypeSerializer = ctxt.findTypeSerializer(contentType);
        }
        ValueSerializer contentSerializer = (ValueSerializer)contentType.getValueHandler();
        for (Serializers serializers : this.customSerializers()) {
            ValueSerializer<?> ser = serializers.findReferenceSerializer(config, refType, beanDesc, format, contentTypeSerializer, contentSerializer);
            if (ser == null) continue;
            return ser;
        }
        if (refType.isTypeOrSubTypeOf(AtomicReference.class)) {
            return this._buildReferenceSerializer(ctxt, AtomicReference.class, refType, beanDesc, staticTyping, contentTypeSerializer, contentSerializer);
        }
        if (refType.isTypeOrSubTypeOf(Optional.class)) {
            return this._buildReferenceSerializer(ctxt, Optional.class, refType, beanDesc, staticTyping, contentTypeSerializer, contentSerializer);
        }
        if (refType.isTypeOrSubTypeOf(OptionalInt.class)) {
            return new OptionalIntSerializer();
        }
        if (refType.isTypeOrSubTypeOf(OptionalLong.class)) {
            return new OptionalLongSerializer();
        }
        if (refType.isTypeOrSubTypeOf(OptionalDouble.class)) {
            return new OptionalDoubleSerializer();
        }
        return null;
    }

    protected ValueSerializer<?> _buildReferenceSerializer(SerializationContext ctxt, Class<?> baseType, ReferenceType refType, BeanDescription.Supplier beanDescRef, boolean staticTyping, TypeSerializer contentTypeSerializer, ValueSerializer<Object> contentSerializer) {
        boolean suppressNulls;
        Object valueToSuppress;
        JsonInclude.Include incl;
        JavaType contentType = refType.getReferencedType();
        JsonInclude.Value inclV = this._findInclusionWithContent(ctxt, beanDescRef, contentType, baseType);
        JsonInclude.Include include = incl = inclV == null ? JsonInclude.Include.USE_DEFAULTS : inclV.getContentInclusion();
        if (incl == JsonInclude.Include.USE_DEFAULTS || incl == JsonInclude.Include.ALWAYS) {
            valueToSuppress = null;
            suppressNulls = false;
        } else {
            suppressNulls = true;
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.getDefaultValue(contentType);
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    valueToSuppress = contentType.isReferenceType() ? MapSerializer.MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    valueToSuppress = MapSerializer.MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                default: {
                    valueToSuppress = null;
                }
            }
        }
        ReferenceTypeSerializer ser = baseType == Optional.class ? new Jdk8OptionalSerializer(refType, staticTyping, contentTypeSerializer, contentSerializer) : new AtomicReferenceSerializer(refType, staticTyping, contentTypeSerializer, contentSerializer);
        return ser.withContentInclusion(valueToSuppress, suppressNulls);
    }

    protected ValueSerializer<?> buildIteratorSerializer(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping, JavaType valueType) {
        return new IteratorSerializer(valueType, staticTyping, ctxt.findTypeSerializer(valueType));
    }

    protected ValueSerializer<?> buildIterableSerializer(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value effectiveFormat, boolean staticTyping, JavaType valueType) {
        return new IterableSerializer(valueType, staticTyping, ctxt.findTypeSerializer(valueType));
    }

    protected ValueSerializer<?> buildEnumSerializer(SerializationContext ctxt, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value effectiveFormat) {
        JsonFormat.Shape shape = effectiveFormat.getShape();
        if (shape == JsonFormat.Shape.POJO || shape == JsonFormat.Shape.OBJECT) {
            BeanDescription beanDesc = beanDescRef.get();
            ((BasicBeanDescription)beanDesc).removeProperty("declaringClass");
            if (type.isEnumType()) {
                this._removeEnumSelfReferences(beanDesc);
            }
            return null;
        }
        Class<?> enumClass = type.getRawClass();
        SerializationConfig config = ctxt.getConfig();
        ValueSerializer ser = EnumSerializer.construct(enumClass, config, beanDescRef.get(), effectiveFormat);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (ValueSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyEnumSerializer(config, type, beanDescRef, ser);
            }
        }
        return ser;
    }

    private void _removeEnumSelfReferences(BeanDescription beanDesc) {
        Class<? extends Enum<?>> aClass = ClassUtil.findEnumType(beanDesc.getBeanClass());
        Iterator<BeanPropertyDefinition> it = beanDesc.findProperties().iterator();
        while (it.hasNext()) {
            BeanPropertyDefinition property = it.next();
            JavaType propType = property.getPrimaryType();
            if (!propType.isEnumType() || !propType.isTypeOrSubTypeOf(aClass) || !property.getAccessor().isStatic()) continue;
            it.remove();
        }
    }

    protected JsonFormat.Value _calculateEffectiveFormat(BeanDescription.Supplier beanDescRef, Class<?> baseType, JsonFormat.Value formatOverrides) {
        JsonFormat.Value fromType = beanDescRef.get().findExpectedFormat(baseType);
        if (formatOverrides == null) {
            return fromType;
        }
        return JsonFormat.Value.merge((JsonFormat.Value)fromType, (JsonFormat.Value)formatOverrides);
    }

    protected ValueSerializer<Object> _findKeySerializer(SerializationContext ctxt, Annotated a) {
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        Object serDef = intr.findKeySerializer(ctxt.getConfig(), a);
        return ctxt.serializerInstance(a, serDef);
    }

    protected ValueSerializer<Object> _findContentSerializer(SerializationContext ctxt, Annotated a) {
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        Object serDef = intr.findContentSerializer(ctxt.getConfig(), a);
        return ctxt.serializerInstance(a, serDef);
    }

    protected Object findFilterId(SerializationConfig config, BeanDescription.Supplier beanDescRef) {
        return config.getAnnotationIntrospector().findFilterId(config, beanDescRef.getClassInfo());
    }

    protected boolean usesStaticTyping(SerializationConfig config, BeanDescription.Supplier beanDescRef) {
        JsonSerialize.Typing t = config.getAnnotationIntrospector().findSerializationTyping(config, beanDescRef.getClassInfo());
        if (t != null) {
            switch (t) {
                case DYNAMIC: {
                    return false;
                }
                case STATIC: {
                    return true;
                }
            }
        }
        return config.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    static {
        HashMap concrete = new HashMap();
        concrete.put(String.class.getName(), StringSerializer.instance);
        ToStringSerializer sls = ToStringSerializer.instance;
        concrete.put(StringBuffer.class.getName(), sls);
        concrete.put(StringBuilder.class.getName(), sls);
        concrete.put(Character.class.getName(), sls);
        concrete.put(Character.TYPE.getName(), sls);
        NumberSerializers.addAll(concrete);
        concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        concrete.put(BigInteger.class.getName(), new NumberSerializer((Class<? extends Number>)BigInteger.class));
        concrete.put(BigDecimal.class.getName(), new NumberSerializer((Class<? extends Number>)BigDecimal.class));
        concrete.put(Calendar.class.getName(), JavaUtilCalendarSerializer.instance);
        concrete.put(Date.class.getName(), JavaUtilDateSerializer.instance);
        _concrete = concrete;
    }
}

