/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.ValueNode;
import tools.jackson.databind.util.RawValue;

public class TreeBuildingGenerator
extends JsonGenerator {
    protected static final int DEFAULT_STREAM_WRITE_FEATURES = StreamWriteFeature.collectDefaults();
    protected static final JacksonFeatureSet<StreamWriteCapability> BOGUS_WRITE_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamWriteCapability.values());
    protected final ObjectWriteContext _objectWriteContext;
    protected final JsonNodeFactory _nodeFactory;
    protected final int _streamWriteFeatures;
    protected RootContext _rootWriteContext;
    protected TreeWriteContext _tokenWriteContext;

    TreeBuildingGenerator(ObjectWriteContext owCtxt, JsonNodeFactory nodeFactory) {
        this._objectWriteContext = owCtxt;
        this._nodeFactory = nodeFactory;
        this._streamWriteFeatures = DEFAULT_STREAM_WRITE_FEATURES;
        this._rootWriteContext = new RootContext(nodeFactory);
        this._tokenWriteContext = this._rootWriteContext;
    }

    public static TreeBuildingGenerator forSerialization(SerializationContext ctxt, JsonNodeFactory nodeFactory) {
        return new TreeBuildingGenerator(ctxt, nodeFactory);
    }

    public JsonNode treeBuilt() {
        return this._rootWriteContext._node;
    }

    public TokenStreamContext streamWriteContext() {
        return this._tokenWriteContext;
    }

    public Object currentValue() {
        return this._tokenWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._tokenWriteContext.assignCurrentValue(v);
    }

    public ObjectWriteContext objectWriteContext() {
        return this._objectWriteContext;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonGenerator configure(StreamWriteFeature f, boolean state) {
        return this;
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return (this._streamWriteFeatures & f.getMask()) != 0;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return BOGUS_WRITE_CAPABILITIES;
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public Object streamWriteOutputTarget() {
        return null;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public JsonGenerator writeStartArray() {
        return this.writeStartArray(null);
    }

    public JsonGenerator writeStartArray(Object forValue) {
        this._tokenWriteContext = this._tokenWriteContext.createChildArrayContext(forValue);
        return this;
    }

    public JsonGenerator writeStartArray(Object forValue, int len) {
        return this.writeStartArray(forValue);
    }

    public JsonGenerator writeEndArray() {
        if (!this._tokenWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._tokenWriteContext.typeDesc());
        }
        this._tokenWriteContext = this._tokenWriteContext.getParent();
        return this;
    }

    public JsonGenerator writeStartObject() {
        return this.writeStartObject(null);
    }

    public JsonGenerator writeStartObject(Object forValue) {
        this._tokenWriteContext = this._tokenWriteContext.createChildObjectContext(forValue);
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue, int size) {
        return this.writeStartObject(forValue);
    }

    public JsonGenerator writeEndObject() {
        if (!this._tokenWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._tokenWriteContext.typeDesc());
        }
        this._tokenWriteContext = this._tokenWriteContext.getParent();
        return this;
    }

    public JsonGenerator writeName(String name) {
        this._tokenWriteContext.writeName(name);
        return this;
    }

    public JsonGenerator writeName(SerializableString name) {
        this._tokenWriteContext.writeName(name.getValue());
        return this;
    }

    public JsonGenerator writePropertyId(long id) {
        return this.writeName(Long.toString(id));
    }

    public JsonGenerator writeString(String text) {
        if (text == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeString(text);
        }
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) {
        return this.writeString(new String(text, offset, len));
    }

    public JsonGenerator writeString(SerializableString text) {
        if (text == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeString(text.getValue());
        }
        return this;
    }

    public JsonGenerator writeString(Reader reader, int len) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int length) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text, int offset, int len) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(SerializableString text) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char c) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text) {
        this._tokenWriteContext.writeNode(this._nodeFactory.rawValueNode(new RawValue(text)));
        return this;
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) {
        if (offset > 0 || len != text.length()) {
            text = text.substring(offset, offset + len);
        }
        return this.writeRawValue(text);
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) {
        return this.writeRawValue(new String(text, offset, len));
    }

    public JsonGenerator writeNumber(short v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        return this;
    }

    public JsonGenerator writeNumber(int v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        return this;
    }

    public JsonGenerator writeNumber(long v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        return this;
    }

    public JsonGenerator writeNumber(double v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        return this;
    }

    public JsonGenerator writeNumber(float v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal v) {
        if (v == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        }
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) {
        if (v == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        }
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) {
        return this.writeString(encodedValue);
    }

    public JsonGenerator writeBoolean(boolean state) {
        this._tokenWriteContext.writeBoolean(state);
        return this;
    }

    public JsonGenerator writeNull() {
        this._tokenWriteContext.writeNull();
        return this;
    }

    public JsonGenerator writePOJO(Object value) {
        if (value == null) {
            return this.writeNull();
        }
        Class<?> raw = value.getClass();
        if (raw == byte[].class || value instanceof RawValue) {
            this._tokenWriteContext.writePOJO(value);
            return this;
        }
        this._objectWriteContext.writeValue((JsonGenerator)this, value);
        return this;
    }

    public JsonGenerator writeTree(TreeNode node) {
        if (node == null) {
            return this.writeNull();
        }
        if (node instanceof JsonNode) {
            this._tokenWriteContext.writeNode((JsonNode)node);
        } else {
            this._tokenWriteContext.writePOJO(node);
        }
        return this;
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) {
        byte[] copy = Arrays.copyOfRange(data, offset, offset + len);
        return this.writePOJO(copy);
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) {
        return (Integer)this._reportUnsupportedOperation();
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public JsonGenerator writeTypeId(Object id) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeObjectId(Object id) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeEmbeddedObject(Object object) {
        this._tokenWriteContext.writePOJO(object);
        return this;
    }

    static final class RootContext
    extends TreeWriteContext {
        protected JsonNode _node;

        public RootContext(JsonNodeFactory nf) {
            super(0, null, nf, null);
        }

        @Override
        public final TreeWriteContext createChildArrayContext(Object currValue) {
            ArrayContext child = new ArrayContext(this, this._nodeFactory, currValue);
            this._node = child._node;
            return child;
        }

        @Override
        public TreeWriteContext createChildObjectContext(Object currValue) {
            ObjectContext child = new ObjectContext(this, this._nodeFactory, currValue);
            this._node = child._node;
            return child;
        }

        @Override
        public void writeBinary(byte[] data) {
            this._node = this._nodeFactory.binaryNode(data);
        }

        @Override
        public void writeBoolean(boolean v) {
            this._node = this._nodeFactory.booleanNode(v);
        }

        @Override
        public void writeNull() {
            this._node = this._nodeFactory.nullNode();
        }

        @Override
        public void writeNumber(ValueNode v) {
            this._node = v;
        }

        @Override
        public void writeString(String v) {
            this._node = this._nodeFactory.stringNode(v);
        }

        @Override
        public void writePOJO(Object value) {
            this._node = this._nodeFactory.pojoNode(value);
        }

        @Override
        public void writeNode(JsonNode node) {
            this._node = node;
        }
    }

    static abstract class TreeWriteContext
    extends TokenStreamContext {
        protected final TreeWriteContext _parent;
        protected final JsonNodeFactory _nodeFactory;
        protected Object _currentValue;

        protected TreeWriteContext(int type, TreeWriteContext parent, JsonNodeFactory nf, Object currValue) {
            this._type = type;
            this._parent = parent;
            this._nodeFactory = nf;
            this._currentValue = currValue;
        }

        public Object currentValue() {
            return this._currentValue;
        }

        public void assignCurrentValue(Object v) {
            this._currentValue = v;
        }

        public final TreeWriteContext getParent() {
            return this._parent;
        }

        public String currentName() {
            return null;
        }

        public abstract TreeWriteContext createChildArrayContext(Object var1);

        public abstract TreeWriteContext createChildObjectContext(Object var1);

        public boolean writeName(String name) {
            return false;
        }

        public abstract void writeBinary(byte[] var1);

        public abstract void writeBoolean(boolean var1);

        public abstract void writeNull();

        public abstract void writeNumber(ValueNode var1);

        public abstract void writeString(String var1);

        public abstract void writeNode(JsonNode var1);

        public abstract void writePOJO(Object var1);
    }

    static final class ObjectContext
    extends TreeWriteContext {
        protected final ObjectNode _node;
        protected String _currentName;
        protected boolean _expectValue = false;

        protected ObjectContext(TreeWriteContext parent, JsonNodeFactory nf, Object currValue) {
            super(2, parent, nf, currValue);
            this._node = nf.objectNode();
        }

        @Override
        public final String currentName() {
            return this._currentName;
        }

        @Override
        public final TreeWriteContext createChildArrayContext(Object currValue) {
            this._verifyValueWrite();
            ArrayContext child = new ArrayContext(this, this._nodeFactory, currValue);
            this._node.set(this._currentName, child._node);
            return child;
        }

        @Override
        public TreeWriteContext createChildObjectContext(Object currValue) {
            this._verifyValueWrite();
            ObjectContext child = new ObjectContext(this, this._nodeFactory, currValue);
            this._node.set(this._currentName, child._node);
            return child;
        }

        @Override
        public boolean writeName(String name) {
            this._currentName = name;
            this._expectValue = true;
            return true;
        }

        @Override
        public void writeBinary(byte[] data) {
            this._verifyValueWrite();
            this._node.put(this._currentName, data);
        }

        @Override
        public void writeBoolean(boolean v) {
            this._verifyValueWrite();
            this._node.put(this._currentName, v);
        }

        @Override
        public void writeNull() {
            this._verifyValueWrite();
            this._node.putNull(this._currentName);
        }

        @Override
        public void writeNumber(ValueNode v) {
            this._verifyValueWrite();
            this._node.set(this._currentName, v);
        }

        @Override
        public void writeString(String v) {
            this._verifyValueWrite();
            this._node.put(this._currentName, v);
        }

        @Override
        public void writePOJO(Object v) {
            this._verifyValueWrite();
            this._node.putPOJO(this._currentName, v);
        }

        @Override
        public void writeNode(JsonNode node) {
            this._verifyValueWrite();
            this._node.set(this._currentName, node);
        }

        protected void _verifyValueWrite() {
            if (!this._expectValue) {
                throw new IllegalStateException("Expecting FIELD_NAME, not value");
            }
            this._expectValue = false;
        }
    }

    static final class ArrayContext
    extends TreeWriteContext {
        protected final ArrayNode _node;

        protected ArrayContext(TreeWriteContext parent, JsonNodeFactory nf, Object currValue) {
            super(1, parent, nf, currValue);
            this._node = nf.arrayNode();
        }

        @Override
        public final TreeWriteContext createChildArrayContext(Object currValue) {
            ArrayContext child = new ArrayContext(this, this._nodeFactory, currValue);
            this._node.add(child._node);
            return child;
        }

        @Override
        public TreeWriteContext createChildObjectContext(Object currValue) {
            ObjectContext child = new ObjectContext(this, this._nodeFactory, currValue);
            this._node.add(child._node);
            return child;
        }

        @Override
        public void writeBinary(byte[] v) {
            this._node.add(v);
        }

        @Override
        public void writeBoolean(boolean v) {
            this._node.add(v);
        }

        @Override
        public void writeNull() {
            this._node.addNull();
        }

        @Override
        public void writeNumber(ValueNode v) {
            this._node.add(v);
        }

        @Override
        public void writeString(String v) {
            this._node.add(v);
        }

        @Override
        public void writePOJO(Object value) {
            this._node.addPOJO(value);
        }

        @Override
        public void writeNode(JsonNode node) {
            this._node.add(node);
        }
    }
}

