/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.bean;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.deser.BeanDeserializerBuilder;
import tools.jackson.databind.deser.ReadableObjectId;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.UnresolvedForwardReference;
import tools.jackson.databind.deser.bean.BeanAsArrayDeserializer;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.PropertyBasedCreator;
import tools.jackson.databind.deser.bean.PropertyValueBuffer;
import tools.jackson.databind.deser.impl.ExternalTypeHandler;
import tools.jackson.databind.deser.impl.MethodProperty;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.IgnorePropertiesUtil;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.TokenBuffer;

public class BeanDeserializer
extends BeanDeserializerBase {
    protected PropertyNameMatcher _propNameMatcher;
    protected SettableBeanProperty[] _propsByIndex;
    protected volatile transient NameTransformer _currentlyTransforming;

    public BeanDeserializer(BeanDeserializerBuilder builder, BeanDescription.Supplier beanDescRef, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, Set<String> includableProps, boolean hasViews) {
        super(builder, beanDescRef, properties, backRefs, ignorableProps, ignoreAllUnknown, includableProps, hasViews);
    }

    protected BeanDeserializer(BeanDeserializer src) {
        super((BeanDeserializerBase)src, src._ignoreAllUnknown);
        this._propNameMatcher = src._propNameMatcher;
        this._propsByIndex = src._propsByIndex;
    }

    protected BeanDeserializer(BeanDeserializer src, boolean ignoreAllUnknown) {
        super((BeanDeserializerBase)src, ignoreAllUnknown);
        this._propNameMatcher = src._propNameMatcher;
        this._propsByIndex = src._propsByIndex;
    }

    protected BeanDeserializer(BeanDeserializer src, UnwrappedPropertyHandler unwrapHandler, PropertyBasedCreator propertyBasedCreator, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super(src, unwrapHandler, propertyBasedCreator, renamedProperties, ignoreAllUnknown);
        this._propNameMatcher = this._beanProperties.getNameMatcher();
        this._propsByIndex = this._beanProperties.getNameMatcherProperties();
    }

    protected BeanDeserializer(BeanDeserializer src, ObjectIdReader oir) {
        super((BeanDeserializerBase)src, oir);
        this._propNameMatcher = src._propNameMatcher;
        this._propsByIndex = src._propsByIndex;
    }

    protected BeanDeserializer(BeanDeserializer src, Set<String> ignorableProps, Set<String> includableProps) {
        super(src, ignorableProps, includableProps);
        this._propNameMatcher = src._propNameMatcher;
        this._propsByIndex = src._propsByIndex;
    }

    protected BeanDeserializer(BeanDeserializer src, BeanPropertyMap props) {
        super((BeanDeserializerBase)src, props);
        this._propNameMatcher = this._beanProperties.getNameMatcher();
        this._propsByIndex = this._beanProperties.getNameMatcherProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        if (this._currentlyTransforming == transformer) {
            return this;
        }
        this._currentlyTransforming = transformer;
        try {
            PropertyBasedCreator pbCreator;
            UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
            if (uwHandler != null) {
                uwHandler = uwHandler.renameAll(ctxt, transformer);
            }
            if ((pbCreator = this._propertyBasedCreator) != null) {
                pbCreator = pbCreator.renameAll(ctxt, transformer);
            }
            BeanDeserializer beanDeserializer = new BeanDeserializer(this, uwHandler, pbCreator, this._beanProperties.renameAll(ctxt, transformer), true);
            return beanDeserializer;
        }
        finally {
            this._currentlyTransforming = null;
        }
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader oir) {
        return new BeanDeserializer(this, oir);
    }

    @Override
    public BeanDeserializer withByNameInclusion(Set<String> ignorableProps, Set<String> includableProps) {
        return new BeanDeserializer(this, ignorableProps, includableProps);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean ignoreUnknown) {
        return new BeanDeserializer(this, ignoreUnknown);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BeanDeserializer(this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return new BeanAsArrayDeserializer((BeanDeserializerBase)this, this._beanProperties.getPrimaryProperties());
    }

    @Override
    protected void initNameMatcher(DeserializationContext ctxt) {
        this._beanProperties.initMatcher(ctxt.tokenStreamFactory());
        this._propNameMatcher = this._beanProperties.getNameMatcher();
        this._propsByIndex = this._beanProperties.getNameMatcherProperties();
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.isExpectedStartObjectToken()) {
            if (this._vanillaProcessing) {
                return this._vanillaDeserialize(p, ctxt);
            }
            p.nextToken();
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(p, ctxt);
            }
            return this.deserializeFromObject(p, ctxt);
        }
        return this._deserializeOther(p, ctxt, p.currentToken());
    }

    protected final Object _deserializeOther(JsonParser p, DeserializationContext ctxt, JsonToken t) throws JacksonException {
        if (t != null) {
            switch (t) {
                case VALUE_STRING: {
                    return this.deserializeFromString(p, ctxt);
                }
                case VALUE_NUMBER_INT: {
                    return this.deserializeFromNumber(p, ctxt);
                }
                case VALUE_NUMBER_FLOAT: {
                    return this.deserializeFromDouble(p, ctxt);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    return this.deserializeFromEmbedded(p, ctxt);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return this.deserializeFromBoolean(p, ctxt);
                }
                case VALUE_NULL: {
                    return this.deserializeFromNull(p, ctxt);
                }
                case START_ARRAY: {
                    return this._deserializeFromArray(p, ctxt);
                }
                case PROPERTY_NAME: 
                case END_OBJECT: {
                    if (this._vanillaProcessing) {
                        return this._vanillaDeserialize(p, ctxt, t);
                    }
                    if (this._objectIdReader != null) {
                        return this.deserializeWithObjectId(p, ctxt);
                    }
                    return this.deserializeFromObject(p, ctxt);
                }
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        Class<?> view;
        String propName;
        p.assignCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p, ctxt, bean);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, bean);
        }
        if (p.isExpectedStartObjectToken()) {
            propName = p.nextName();
            if (propName == null) {
                return bean;
            }
        } else if (p.hasTokenId(5)) {
            propName = p.currentName();
        } else {
            return bean;
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean, view);
        }
        int ix = this._propNameMatcher.matchName(propName);
        while (ix >= 0) {
            p.nextToken();
            SettableBeanProperty prop = this._propsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        if (ix != -1) {
            if (ix == -2) {
                return this._vanillaDeserializeWithUnknown(p, ctxt, bean, p.currentName());
            }
            return this._handleUnexpectedWithin(p, ctxt, bean);
        }
        return bean;
    }

    private final Object _vanillaDeserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.assignCurrentValue(bean);
        int ix = p.nextNameMatch(this._propNameMatcher);
        while (ix >= 0) {
            p.nextToken();
            SettableBeanProperty prop = this._propsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
            if (ix < 0) break;
            p.nextToken();
            prop = this._propsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
            if (ix < 0) break;
            p.nextToken();
            prop = this._propsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
            if (ix < 0) break;
            p.nextToken();
            prop = this._propsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        if (ix != -1) {
            if (ix == -2) {
                return this._vanillaDeserializeWithUnknown(p, ctxt, bean, p.currentName());
            }
            return this._handleUnexpectedWithin(p, ctxt, bean);
        }
        return bean;
    }

    private final Object _vanillaDeserialize(JsonParser p, DeserializationContext ctxt, JsonToken t) throws JacksonException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (t != JsonToken.PROPERTY_NAME) {
            return bean;
        }
        p.assignCurrentValue(bean);
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (ix >= 0) {
            SettableBeanProperty prop = this._propsByIndex[ix];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
            if (ix < 0) break;
            prop = this._propsByIndex[ix];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        if (ix != -1) {
            if (ix == -2) {
                return this._vanillaDeserializeWithUnknown(p, ctxt, bean, p.currentName());
            }
            return this._handleUnexpectedWithin(p, ctxt, bean);
        }
        return bean;
    }

    private final Object _vanillaDeserializeWithUnknown(JsonParser p, DeserializationContext ctxt, Object bean, String propName) throws JacksonException {
        p.nextToken();
        this.handleUnknownVanilla(p, ctxt, bean, propName);
        while (true) {
            int ix;
            if ((ix = p.nextNameMatch(this._propNameMatcher)) >= 0) {
                p.nextToken();
                try {
                    this._propsByIndex[ix].deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, this._propsByIndex[ix].getName(), ctxt);
                }
                continue;
            }
            if (ix == -1) {
                return bean;
            }
            if (ix != -2) {
                return bean;
            }
            p.nextToken();
            this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
        }
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Class<?> view;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && p.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(p.currentName(), p)) {
            return this.deserializeFromObjectId(p, ctxt);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            return bean;
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (p.canReadObjectId()) {
            Object id = p.getObjectId();
            if (id != null) {
                this._handleTypedObjectId(p, ctxt, bean, id);
            }
        } else if (this._objectIdReader != null && p.hasTokenId(2) && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS)) {
            ctxt.reportUnresolvedObjectId(this._objectIdReader, bean);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (!p.hasTokenId(5)) {
            return bean;
        }
        p.assignCurrentValue(bean);
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean, view);
        }
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                try {
                    this._propsByIndex[ix].deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, bean, this._propsByIndex[ix].getName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return bean;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        creator = this._propertyBasedCreator;
        buffer = this._anySetter != null ? creator.startBuildingWithAnySetter(p, ctxt, this._objectIdReader, this._anySetter) : creator.startBuilding(p, ctxt, this._objectIdReader);
        unknown = null;
        activeView = this._needViewProcesing != false ? ctxt.getActiveView() : null;
        t = p.currentToken();
        referrings = null;
        while (t == JsonToken.PROPERTY_NAME) {
            block32: {
                block33: {
                    propName = p.currentName();
                    p.nextToken();
                    creatorProp = creator.findCreatorProperty(propName);
                    if (buffer.readIdProperty(propName) && creatorProp == null) break block32;
                    if (creatorProp == null) break block33;
                    if (activeView != null && !creatorProp.visibleInView(activeView)) {
                        p.skipChildren();
                    } else {
                        value = this._deserializeWithErrorWrapping(p, ctxt, creatorProp);
                        if (buffer.assignParameter(creatorProp, value)) {
                            p.nextToken();
                            try {
                                bean = creator.build(ctxt, buffer);
                            }
                            catch (Exception e) {
                                bean = this.wrapInstantiationProblem(ctxt, e);
                            }
                            p.assignCurrentValue(bean);
                            if (bean == null) {
                                this._handleNullFromPropsBasedCreator(p, ctxt, unknown, referrings);
                                return null;
                            }
                            if (bean.getClass() != this._beanType.getRawClass()) {
                                return this.handlePolymorphic(p, ctxt, bean, unknown);
                            }
                            if (unknown != null) {
                                bean = this.handleUnknownProperties(ctxt, bean, unknown);
                            }
                            return this.deserialize(p, ctxt, bean);
                        }
                    }
                    break block32;
                }
                ix = this._propNameMatcher.matchName(propName);
                if (ix < 0) ** GOTO lbl-1000
                prop = this._propsByIndex[ix];
                if (!this._beanType.isRecordType() || prop instanceof MethodProperty) {
                    try {
                        buffer.bufferProperty(prop, this._deserializeWithErrorWrapping(p, ctxt, prop));
                    }
                    catch (UnresolvedForwardReference reference) {
                        referring = this.handleUnresolvedReference(ctxt, prop, buffer, reference);
                        if (referrings == null) {
                            referrings = new ArrayList<BeanReferring>();
                        }
                        referrings.add(referring);
                    }
                } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                    this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                } else if (this._anySetter != null) {
                    try {
                        if (this._anySetter.isFieldType() || this._anySetter.isSetterType()) {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                        }
                        buffer.bufferAnyParameterProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                    }
                } else if (this._ignoreAllUnknown) {
                    p.skipChildren();
                } else {
                    if (unknown == null) {
                        unknown = ctxt.bufferForInputBuffering(p);
                    }
                    unknown.writeName(propName);
                    unknown.copyCurrentStructure(p);
                }
            }
            t = p.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(ctxt, e);
        }
        p.assignCurrentValue(bean);
        if (bean == null) {
            this._handleNullFromPropsBasedCreator(null, ctxt, unknown, referrings);
            return null;
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (referrings != null) {
            for (BeanReferring referring : referrings) {
                referring.setBean(bean);
            }
        }
        if (unknown != null) {
            if (bean.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, bean, unknown);
            }
            return this.handleUnknownProperties(ctxt, bean, unknown);
        }
        return bean;
    }

    private BeanReferring handleUnresolvedReference(DeserializationContext ctxt, SettableBeanProperty prop, PropertyValueBuffer buffer, UnresolvedForwardReference reference) throws DatabindException {
        BeanReferring referring = new BeanReferring(ctxt, reference, prop.getType(), buffer, prop);
        reference.getRoid().appendReferring(referring);
        return referring;
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser p, DeserializationContext ctxt, SettableBeanProperty prop) throws DatabindException {
        try {
            return prop.deserialize(p, ctxt);
        }
        catch (Exception e) {
            throw this.wrapAndThrow(e, this._beanType.getRawClass(), prop.getName(), ctxt);
        }
    }

    protected Object deserializeFromNull(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    @Override
    protected Object _deserializeFromArray(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        ValueDeserializer delegateDeser = this._arrayDelegateDeserializer;
        if (delegateDeser != null || (delegateDeser = this._delegateDeserializer) != null) {
            Object bean = this._valueInstantiator.createUsingArrayDelegate(ctxt, delegateDeser.deserialize(p, ctxt));
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        CoercionAction act = this._findCoercionFromEmptyArray(ctxt);
        boolean unwrap = ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (unwrap || act != CoercionAction.Fail) {
            JsonToken unwrappedToken = p.nextToken();
            if (unwrappedToken == JsonToken.END_ARRAY) {
                switch (act) {
                    case AsEmpty: {
                        return this.getEmptyValue(ctxt);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(ctxt);
                    }
                }
                return ctxt.handleUnexpectedToken(this.getValueType(ctxt), JsonToken.START_ARRAY, p, null, new Object[0]);
            }
            if (unwrap) {
                if (unwrappedToken == JsonToken.START_ARRAY) {
                    JavaType targetType = this.getValueType(ctxt);
                    return ctxt.handleUnexpectedToken(targetType, JsonToken.START_ARRAY, p, "Cannot deserialize value of type %s from deeply-nested Array: only single wrapper allowed with `%s`", ClassUtil.getTypeDescription(targetType), "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS");
                }
                Object value = this.deserialize(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return value;
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    protected final Object deserializeWithView(JsonParser p, DeserializationContext ctxt, Object bean, Class<?> activeView) throws JacksonException {
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propsByIndex[ix];
                if (!prop.visibleInView(activeView)) {
                    if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNEXPECTED_VIEW_PROPERTIES)) {
                        ctxt.reportInputMismatch(this.handledType(), String.format("Input mismatch while deserializing %s. Property '%s' is not part of current active view '%s' (disable 'DeserializationFeature.FAIL_ON_UNEXPECTED_VIEW_PROPERTIES' to allow)", ClassUtil.nameOf(this.handledType()), prop.getName(), activeView.getName()), new Object[0]);
                    }
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else if (ix != -1) {
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            } else {
                return bean;
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p, ctxt);
        }
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.assignCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propsByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (this._anySetter == null) {
                    tokens.writeName(propName);
                    tokens.copyCurrentStructure(p);
                } else {
                    TokenBuffer b2 = ctxt.bufferAsCopyOfValue(p);
                    tokens.writeName(propName);
                    tokens.append(b2);
                    try {
                        this._anySetter.deserializeAndSet(b2.asParserOnFirstToken(ctxt), ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propsByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (this._anySetter == null) {
                    tokens.writeName(propName);
                    tokens.copyCurrentStructure(p);
                } else {
                    TokenBuffer b2 = ctxt.bufferAsCopyOfValue(p);
                    tokens.writeName(propName);
                    tokens.append(b2);
                    try {
                        this._anySetter.deserializeAndSet(b2.asParserOnFirstToken(ctxt), ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        JsonToken t = p.currentToken();
        while (t == JsonToken.PROPERTY_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (!buffer.readIdProperty(propName) || creatorProp != null) {
                if (creatorProp != null) {
                    if (buffer.assignParameter(creatorProp, this._deserializeWithErrorWrapping(p, ctxt, creatorProp))) {
                        Object bean2;
                        t = p.nextToken();
                        try {
                            bean2 = creator.build(ctxt, buffer);
                        }
                        catch (Exception e) {
                            bean2 = this.wrapInstantiationProblem(ctxt, e);
                        }
                        p.assignCurrentValue(bean2);
                        if (bean2 == null) {
                            this._handleNullFromPropsBasedCreator(p, ctxt, null, null);
                            return null;
                        }
                        while (t == JsonToken.PROPERTY_NAME) {
                            tokens.copyCurrentStructure(p);
                            t = p.nextToken();
                        }
                        if (t != JsonToken.END_OBJECT) {
                            ctxt.reportWrongTokenException(this, JsonToken.END_OBJECT, "Attempted to unwrap '%s' value", this.handledType().getName());
                        }
                        tokens.writeEndObject();
                        if (bean2.getClass() != this._beanType.getRawClass()) {
                            return ctxt.reportInputMismatch(creatorProp, "Cannot create polymorphic instances with unwrapped values", new Object[0]);
                        }
                        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean2, tokens);
                    }
                } else {
                    int ix = this._propNameMatcher.matchName(propName);
                    if (ix >= 0) {
                        SettableBeanProperty prop = this._propsByIndex[ix];
                        buffer.bufferProperty(prop, this._deserializeWithErrorWrapping(p, ctxt, prop));
                    } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else if (this._anySetter == null) {
                        tokens.writeName(propName);
                        tokens.copyCurrentStructure(p);
                    } else {
                        TokenBuffer b2 = ctxt.bufferAsCopyOfValue(p);
                        tokens.writeName(propName);
                        tokens.append(b2);
                        try {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(b2.asParserOnFirstToken(ctxt), ctxt));
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        }
                    }
                }
            }
            t = p.nextToken();
        }
        buffer = this._unwrappedPropertyHandler.processUnwrappedCreatorProperties(p, ctxt, buffer, tokens);
        try {
            bean = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(ctxt, e);
        }
        if (bean == null) {
            this._handleNullFromPropsBasedCreator(null, ctxt, null, null);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        return this.deserializeWithExternalTypeId(p, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        return this._deserializeWithExternalTypeId(p, ctxt, bean, this._externalTypeIdHandler.start());
    }

    protected Object _deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean, ExternalTypeHandler ext) throws JacksonException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                SettableBeanProperty prop = this._propsByIndex[ix];
                JsonToken t = p.nextToken();
                if (t.isScalarValue()) {
                    ext.handleTypePropertyValue(p, ctxt, p.currentName(), bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (!ext.handlePropertyValue(p, ctxt, propName, bean)) {
                    if (this._anySetter != null) {
                        try {
                            this._anySetter.deserializeAndSet(p, ctxt, bean, propName);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    } else {
                        this.handleUnknownProperty(p, ctxt, bean, p.currentName());
                    }
                }
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        return ext.complete(p, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        JsonToken t = p.currentToken();
        while (t == JsonToken.PROPERTY_NAME) {
            String propName = p.currentName();
            t = p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (!buffer.readIdProperty(propName) || creatorProp != null) {
                if (creatorProp != null) {
                    if (!ext.handlePropertyValue(p, ctxt, propName, null) && buffer.assignParameter(creatorProp, this._deserializeWithErrorWrapping(p, ctxt, creatorProp))) {
                        Object bean;
                        t = p.nextToken();
                        try {
                            bean = creator.build(ctxt, buffer);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        }
                        if (bean.getClass() != this._beanType.getRawClass()) {
                            return ctxt.reportBadDefinition(this._beanType, String.format("Cannot create polymorphic instances with external type ids (%s -> %s)", this._beanType, bean.getClass()));
                        }
                        return this._deserializeWithExternalTypeId(p, ctxt, bean, ext);
                    }
                } else {
                    int ix = this._propNameMatcher.matchName(propName);
                    if (ix >= 0) {
                        SettableBeanProperty prop = this._propsByIndex[ix];
                        if (t.isScalarValue()) {
                            ext.handleTypePropertyValue(p, ctxt, propName, null);
                        }
                        buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                    } else if (!ext.handlePropertyValue(p, ctxt, propName, null)) {
                        if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                            this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                        } else if (this._anySetter != null) {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                        } else {
                            this.handleUnknownProperty(p, ctxt, this._valueClass, propName);
                        }
                    }
                }
            }
            t = p.nextToken();
        }
        try {
            return ext.complete(p, ctxt, buffer, creator);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(ctxt, e);
        }
    }

    protected void _handleNullFromPropsBasedCreator(JsonParser p, DeserializationContext ctxt, TokenBuffer unknown, List<BeanReferring> referrings) {
        if (p != null) {
            JsonToken t = p.currentToken();
            while (t == JsonToken.PROPERTY_NAME) {
                p.nextToken();
                p.skipChildren();
                t = p.nextToken();
            }
        }
        if (unknown != null) {
            this.handleUnknownProperties(ctxt, null, unknown);
        }
        if (referrings != null) {
            for (BeanReferring referring : referrings) {
                referring.setBean(null);
            }
        }
    }

    protected Object _handleUnexpectedWithin(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    static class BeanReferring
    extends ReadableObjectId.Referring {
        private final DeserializationContext _context;
        private final SettableBeanProperty _prop;
        private Object _bean;

        BeanReferring(DeserializationContext ctxt, UnresolvedForwardReference ref, JavaType valueType, PropertyValueBuffer buffer, SettableBeanProperty prop) {
            super(ref, valueType);
            this._context = ctxt;
            this._prop = prop;
        }

        public void setBean(Object bean) {
            this._bean = bean;
        }

        @Override
        public void handleResolvedForwardReference(DeserializationContext ctxt, Object id, Object value) {
            if (this._bean == null) {
                this._context.reportInputMismatch(this._prop, "Cannot resolve ObjectId forward reference using property '%s' (of type %s): Bean not yet resolved", this._prop.getName(), this._prop.getDeclaringClass().getName());
            }
            this._prop.set(ctxt, this._bean, value);
        }
    }
}

