/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.util.ClassUtil;

public abstract class InjectableValues
implements Snapshottable<InjectableValues> {
    public abstract Object findInjectableValue(Object var1, DeserializationContext var2, BeanProperty var3, Object var4, Boolean var5);

    public static class Std
    extends InjectableValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Map<String, Object> _values;

        public Std() {
            this(new HashMap<String, Object>());
        }

        public Std(Map<String, Object> values) {
            this._values = values;
        }

        public Std addValue(String key, Object value) {
            this._values.put(key, value);
            return this;
        }

        public Std addValue(Class<?> classKey, Object value) {
            this._values.put(classKey.getName(), value);
            return this;
        }

        public Std snapshot() {
            if (this._values.isEmpty()) {
                return new Std();
            }
            return new Std(new HashMap<String, Object>(this._values));
        }

        @Override
        public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance, Boolean optional) {
            String key;
            Object ob;
            if (!(valueId instanceof String)) {
                ctxt.reportBadDefinition(ClassUtil.classOf(valueId), String.format("Unrecognized inject value id type (%s), expecting String", ClassUtil.classNameOf(valueId)));
            }
            if ((ob = this._values.get(key = (String)valueId)) == null && !this._values.containsKey(key) && (Boolean.FALSE.equals(optional) || optional == null && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_INJECT_VALUE))) {
                return ctxt.reportBadDefinition(ClassUtil.classOf(valueId), String.format("No injectable value with id '" + key + "' found (for property '" + forProperty.getName() + "')", new Object[0]));
            }
            return ob;
        }
    }
}

