/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.tree.ArrayTreeNode;
import tools.jackson.core.tree.ObjectTreeNode;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.core.type.TypeReference;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.deser.ContextualKeyDeserializer;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.deser.DeserializerCache;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.deser.ReadableObjectId;
import tools.jackson.databind.deser.UnresolvedForwardReference;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.deser.impl.TypeWrappedDeserializer;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.exc.InvalidFormatException;
import tools.jackson.databind.exc.InvalidTypeIdException;
import tools.jackson.databind.exc.MismatchedInputException;
import tools.jackson.databind.exc.UnrecognizedPropertyException;
import tools.jackson.databind.exc.ValueInstantiationException;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.TreeTraversingParser;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.LinkedNode;
import tools.jackson.databind.util.ObjectBuffer;
import tools.jackson.databind.util.TokenBuffer;

public abstract class DeserializationContext
extends DatabindContext
implements ObjectReadContext {
    protected final TokenStreamFactory _streamFactory;
    protected final DeserializerFactory _factory;
    protected final DeserializerCache _cache;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _activeView;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected transient JsonParser _parser;
    protected transient JacksonFeatureSet<StreamReadCapability> _readCapabilities;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;
    protected transient ClassIntrospector _classIntrospector;

    protected DeserializationContext(TokenStreamFactory streamFactory, DeserializerFactory df, DeserializerCache cache, DeserializationConfig config, FormatSchema schema, InjectableValues injectableValues) {
        this._streamFactory = streamFactory;
        this._factory = Objects.requireNonNull(df, "Cannot pass null DeserializerFactory");
        this._cache = cache;
        this._config = config;
        this._featureFlags = config.getDeserializationFeatures();
        this._activeView = config.getActiveView();
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._attributes = config.getAttributes();
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._activeView;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature feature) {
        return this._config.isEnabled(feature);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature feature) {
        return this._config.isEnabled(feature);
    }

    @Override
    public final DatatypeFeatures getDatatypeFeatures() {
        return this._config.getDatatypeFeatures();
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> baseType) {
        return this._config.getDefaultPropertyFormat(baseType);
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public JavaType constructSpecializedType(JavaType baseType, Class<?> subclass) throws IllegalArgumentException {
        if (baseType.hasRawClass(subclass)) {
            return baseType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(baseType, subclass, false);
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object key) {
        return this._attributes.getAttribute(key);
    }

    @Override
    public DeserializationContext setAttribute(Object key, Object value) {
        this._attributes = this._attributes.withPerCallAttribute(key, value);
        return this;
    }

    public JavaType getContextualType() {
        return this._currentType == null ? null : this._currentType.value();
    }

    public TokenStreamFactory tokenStreamFactory() {
        return this._streamFactory;
    }

    public FormatSchema getSchema() {
        return this._schema;
    }

    public StreamReadConstraints streamReadConstraints() {
        return this._streamFactory.streamReadConstraints();
    }

    public int getStreamReadFeatures(int defaults) {
        return this._config.getStreamReadFeatures();
    }

    public int getFormatReadFeatures(int defaults) {
        return this._config.getFormatReadFeatures();
    }

    public ArrayTreeNode createArrayNode() {
        return this.getNodeFactory().arrayNode();
    }

    public ObjectTreeNode createObjectNode() {
        return this.getNodeFactory().objectNode();
    }

    public JsonNode readTree(JsonParser p) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return null;
        }
        if (t == JsonToken.VALUE_NULL) {
            return this.getNodeFactory().nullNode();
        }
        ValueDeserializer<Object> deser = this.findRootValueDeserializer(ObjectReader.JSON_NODE_TYPE);
        return (JsonNode)deser.deserialize(p, this);
    }

    public <T> T readValue(JsonParser p, Class<T> type) throws JacksonException {
        return this.readValue(p, this.getTypeFactory().constructType(type));
    }

    public <T> T readValue(JsonParser p, TypeReference<T> refType) throws JacksonException {
        return this.readValue(p, this.getTypeFactory().constructType(refType));
    }

    public <T> T readValue(JsonParser p, ResolvedType type) throws JacksonException {
        if (!(type instanceof JavaType)) {
            throw new UnsupportedOperationException("Only support `JavaType` implementation of `ResolvedType`, not: " + type.getClass().getName());
        }
        return this.readValue(p, (JavaType)type);
    }

    public <T> T readValue(JsonParser p, JavaType type) throws JacksonException {
        ValueDeserializer<Object> deser = this.findRootValueDeserializer(type);
        if (deser == null) {
            this.reportBadDefinition(type, "Could not find `ValueDeserializer` for type " + ClassUtil.getTypeDescription(type));
        }
        return (T)this._readValue(p, deser);
    }

    private Object _readValue(JsonParser p, ValueDeserializer<Object> deser) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            return deser.getNullValue(this);
        }
        return deser.deserialize(p, this);
    }

    public final boolean isEnabled(DeserializationFeature feat) {
        return (this._featureFlags & feat.getMask()) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasDeserializationFeatures(int featureMask) {
        return (this._featureFlags & featureMask) == featureMask;
    }

    public final boolean hasSomeOfFeatures(int featureMask) {
        return (this._featureFlags & featureMask) != 0;
    }

    public final boolean isEnabled(StreamReadCapability cap) {
        return this._readCapabilities.isEnabled((JacksonFeature)cap);
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional) {
        if (this._injectableValues == null) {
            if (Boolean.TRUE.equals(optional) || optional == null && !this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_INJECT_VALUE)) {
                return JacksonInject.Value.empty();
            }
            return this.reportBadDefinition(ClassUtil.classOf(valueId), String.format("No 'injectableValues' configured, cannot inject value with id '%s'", valueId));
        }
        return this._injectableValues.findInjectableValue(valueId, this, forProperty, beanInstance, optional);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    @Override
    protected ClassIntrospector classIntrospector() {
        if (this._classIntrospector == null) {
            this._classIntrospector = this._config.classIntrospectorInstance();
        }
        return this._classIntrospector;
    }

    @Override
    public BeanDescription introspectBeanDescription(JavaType type, AnnotatedClass ac) {
        return this.classIntrospector().introspectForDeserialization(type, ac);
    }

    public BeanDescription introspectBeanDescriptionForCreation(JavaType type) {
        return this.introspectBeanDescriptionForCreation(type, this.classIntrospector().introspectClassAnnotations(type));
    }

    public BeanDescription introspectBeanDescriptionForCreation(JavaType type, AnnotatedClass ac) {
        return this.classIntrospector().introspectForCreation(type, ac);
    }

    public BeanDescription.Supplier lazyIntrospectBeanDescriptionForCreation(JavaType type) {
        return new BeanDescription.LazySupplier(type){

            @Override
            protected BeanDescription _construct(JavaType forType, AnnotatedClass ac) {
                return DeserializationContext.this.introspectBeanDescriptionForCreation(forType, ac);
            }

            @Override
            protected AnnotatedClass _introspect(JavaType forType) {
                return DeserializationContext.this.introspectClassAnnotations(forType);
            }
        };
    }

    public BeanDescription introspectBeanDescriptionForBuilder(JavaType builderType, BeanDescription valueTypeDesc) {
        return this.classIntrospector().introspectForDeserializationWithBuilder(builderType, valueTypeDesc);
    }

    public BeanDescription.Supplier lazyIntrospectBeanDescriptionForBuilder(JavaType builderType, final BeanDescription valueTypeDesc) {
        return new BeanDescription.LazySupplier(builderType){

            @Override
            protected BeanDescription _construct(JavaType forType, AnnotatedClass ac) {
                return DeserializationContext.this.introspectBeanDescriptionForBuilder(forType, valueTypeDesc);
            }

            @Override
            protected AnnotatedClass _introspect(JavaType forType) {
                return DeserializationContext.this.introspectClassAnnotations(forType);
            }
        };
    }

    @Override
    public PropertyName findRootName(JavaType rootType) {
        return this._config.findRootName((DatabindContext)this, rootType);
    }

    @Override
    public PropertyName findRootName(Class<?> rawRootType) {
        return this._config.findRootName((DatabindContext)this, rawRootType);
    }

    public boolean hasExplicitDeserializerFor(Class<?> valueType) {
        return this._factory.hasExplicitDeserializerFor(this, valueType);
    }

    public CoercionAction findCoercionAction(LogicalType targetType, Class<?> targetClass, CoercionInputShape inputShape) {
        return this._config.findCoercionAction(targetType, targetClass, inputShape);
    }

    public CoercionAction findCoercionFromBlankString(LogicalType targetType, Class<?> targetClass, CoercionAction actionIfBlankNotAllowed) {
        return this._config.findCoercionFromBlankString(targetType, targetClass, actionIfBlankNotAllowed);
    }

    public TokenBuffer bufferForInputBuffering(JsonParser p) {
        return TokenBuffer.forBuffering(p, this);
    }

    public final TokenBuffer bufferForInputBuffering() {
        return this.bufferForInputBuffering(this.getParser());
    }

    public TokenBuffer bufferAsCopyOfValue(JsonParser p) throws JacksonException {
        TokenBuffer buf = this.bufferForInputBuffering(p);
        buf.copyCurrentStructure(p);
        return buf;
    }

    public final ValueDeserializer<Object> findContextualValueDeserializer(JavaType type, BeanProperty prop) {
        ValueDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type);
        if (deser != null) {
            deser = this.handleSecondaryContextualization(deser, prop, type);
        }
        return deser;
    }

    public final ValueDeserializer<Object> findNonContextualValueDeserializer(JavaType type) {
        return this._cache.findValueDeserializer(this, this._factory, type);
    }

    public final ValueDeserializer<Object> findRootValueDeserializer(JavaType type) {
        ValueDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type);
        if (deser == null) {
            return null;
        }
        deser = this.handleSecondaryContextualization(deser, null, type);
        TypeDeserializer typeDeser = this.findTypeDeserializer(type);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(null);
            return new TypeWrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    public TypeDeserializer findTypeDeserializer(JavaType baseType) {
        return this.findTypeDeserializer(baseType, this.introspectClassAnnotations(baseType));
    }

    public TypeDeserializer findTypeDeserializer(JavaType baseType, AnnotatedClass classAnnotations) {
        try {
            return this._config.getTypeResolverProvider().findTypeDeserializer(this, baseType, classAnnotations);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw InvalidDefinitionException.from(this.getParser(), ClassUtil.exceptionMessage(e), baseType).withCause(e);
        }
    }

    public TypeDeserializer findPropertyTypeDeserializer(JavaType baseType, AnnotatedMember accessor) {
        try {
            return this._config.getTypeResolverProvider().findPropertyTypeDeserializer(this, accessor, baseType);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw InvalidDefinitionException.from(this.getParser(), ClassUtil.exceptionMessage(e), baseType).withCause(e);
        }
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(JavaType containerType, AnnotatedMember accessor) {
        try {
            return this._config.getTypeResolverProvider().findPropertyContentTypeDeserializer(this, accessor, containerType);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw InvalidDefinitionException.from(this.getParser(), ClassUtil.exceptionMessage(e), containerType).withCause(e);
        }
    }

    public final KeyDeserializer findKeyDeserializer(JavaType keyType, BeanProperty prop) {
        KeyDeserializer kd;
        try {
            kd = this._cache.findKeyDeserializer(this, this._factory, keyType);
        }
        catch (IllegalArgumentException iae) {
            this.reportBadDefinition(keyType, ClassUtil.exceptionMessage(iae));
            kd = null;
        }
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(this, prop);
        }
        return kd;
    }

    public void flushCachedDeserializers() {
        this._cache.flushCachedDeserializers();
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public abstract void checkUnresolvedObjectId() throws UnresolvedForwardReference;

    public final JavaType constructType(Class<?> cls) {
        return cls == null ? null : this._config.constructType(cls);
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        return this.getTypeFactory().findClass(className);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer buf = this._objectBuffer;
        if (buf == null) {
            buf = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return buf;
    }

    public final void returnObjectBuffer(ObjectBuffer buf) {
        if (this._objectBuffer == null || buf.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = buf;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract ValueDeserializer<Object> deserializerInstance(Annotated var1, Object var2);

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueDeserializer<?> handlePrimaryContextualization(ValueDeserializer<?> deser, BeanProperty prop, JavaType type) {
        if (deser != null) {
            this._currentType = new LinkedNode<JavaType>(type, this._currentType);
            try {
                deser = deser.createContextual(this, prop);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return deser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueDeserializer<?> handleSecondaryContextualization(ValueDeserializer<?> deser, BeanProperty prop, JavaType type) {
        if (deser != null) {
            this._currentType = new LinkedNode<JavaType>(type, this._currentType);
            try {
                deser = deser.createContextual(this, prop);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return deser;
    }

    public Date parseDate(String dateStr) throws IllegalArgumentException {
        try {
            DateFormat df = this._getDateFormat();
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", dateStr, ClassUtil.exceptionMessage(e)));
        }
    }

    public Calendar constructCalendar(Date d) {
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTime(d);
        return c;
    }

    public String extractScalarFromObject(JsonParser p, ValueDeserializer<?> deser, Class<?> scalarType) throws JacksonException {
        return (String)this.handleUnexpectedToken(this.constructType(scalarType), p);
    }

    public <T> T readPropertyValue(JsonParser p, BeanProperty prop, Class<T> type) throws JacksonException {
        return this.readPropertyValue(p, prop, this.getTypeFactory().constructType(type));
    }

    public <T> T readPropertyValue(JsonParser p, BeanProperty prop, JavaType type) throws JacksonException {
        ValueDeserializer<Object> deser = this.findContextualValueDeserializer(type, prop);
        if (deser == null) {
            return this.reportBadDefinition(type, String.format("Could not find `ValueDeserializer` for type %s (via property %s)", ClassUtil.getTypeDescription(type), ClassUtil.nameOf(prop)));
        }
        return (T)this._readValue(p, deser);
    }

    public <T> T readTreeAsValue(JsonNode n, Class<T> targetType) throws JacksonException {
        if (n == null || n.isMissingNode()) {
            return null;
        }
        try (TreeTraversingParser p = this._treeAsTokens(n);){
            T t = this.readValue((JsonParser)p, targetType);
            return t;
        }
    }

    public <T> T readTreeAsValue(JsonNode n, JavaType targetType) throws JacksonException {
        if (n == null || n.isMissingNode()) {
            return null;
        }
        try (TreeTraversingParser p = this._treeAsTokens(n);){
            T t = this.readValue((JsonParser)p, targetType);
            return t;
        }
    }

    private TreeTraversingParser _treeAsTokens(JsonNode n) {
        TreeTraversingParser p = new TreeTraversingParser(n, this);
        p.nextToken();
        return p;
    }

    public boolean handleUnknownProperty(JsonParser p, ValueDeserializer<?> deser, Object instanceOrClass, String propName) throws JacksonException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            if (!h.value().handleUnknownProperty(this, p, deser, instanceOrClass, propName)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            p.skipChildren();
            return true;
        }
        Collection<Object> propIds = deser == null ? null : deser.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, instanceOrClass, propName, propIds);
    }

    public Object handleWeirdKey(Class<?> keyClass, String keyValue, String msg, Object ... msgArgs) throws JacksonException {
        msg = this._format(msg, msgArgs);
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object key = h.value().handleWeirdKey(this, keyClass, keyValue, msg);
            if (key == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (key == null || keyClass.isInstance(key)) {
                return key;
            }
            throw this.weirdStringException(keyValue, keyClass, String.format("DeserializationProblemHandler.handleWeirdKey() for type %s returned value of type %s", ClassUtil.getClassDescription(keyClass), ClassUtil.getClassDescription(key)));
        }
        throw this.weirdKeyException(keyClass, keyValue, msg);
    }

    public Object handleWeirdStringValue(Class<?> targetClass, String value, String msg, Object ... msgArgs) throws JacksonException {
        msg = this._format(msg, msgArgs);
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleWeirdStringValue(this, targetClass, value, msg);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(targetClass, instance)) {
                return instance;
            }
            throw this.weirdStringException(value, targetClass, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", ClassUtil.getClassDescription(targetClass), ClassUtil.getClassDescription(instance)));
        }
        throw this.weirdStringException(value, targetClass, msg);
    }

    public Object handleWeirdNumberValue(Class<?> targetClass, Number value, String msg, Object ... msgArgs) throws JacksonException {
        msg = this._format(msg, msgArgs);
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object key = h.value().handleWeirdNumberValue(this, targetClass, value, msg);
            if (key == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(targetClass, key)) {
                return key;
            }
            throw this.weirdNumberException(value, targetClass, this._format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", ClassUtil.getClassDescription(targetClass), ClassUtil.getClassDescription(key)));
        }
        throw this.weirdNumberException(value, targetClass, msg);
    }

    public Object handleWeirdNativeValue(JavaType targetType, Object badValue, JsonParser p) throws JacksonException {
        Class<?> raw = targetType.getRawClass();
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object goodValue = h.value().handleWeirdNativeValue(this, targetType, badValue, p);
            if (goodValue == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (goodValue == null || raw.isInstance(goodValue)) {
                return goodValue;
            }
            throw DatabindException.from(p, this._format("DeserializationProblemHandler.handleWeirdNativeValue() for type %s returned value of type %s", ClassUtil.getClassDescription(targetType), ClassUtil.getClassDescription(goodValue)));
        }
        throw this.weirdNativeValueException(badValue, raw);
    }

    public Object handleMissingInstantiator(Class<?> instClass, ValueInstantiator valueInst, JsonParser p, String msg, Object ... msgArgs) throws JacksonException {
        if (p == null) {
            p = this.getParser();
        }
        msg = this._format(msg, msgArgs);
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleMissingInstantiator(this, instClass, valueInst, p, msg);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(instClass, instance)) {
                return instance;
            }
            this.reportBadDefinition(this.constructType(instClass), String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", ClassUtil.getClassDescription(instClass), ClassUtil.getClassDescription(instance)));
        }
        if (valueInst == null) {
            msg = String.format("Cannot construct instance of %s: %s", ClassUtil.nameOf(instClass), msg);
            return this.reportBadDefinition(instClass, msg);
        }
        if (!valueInst.canInstantiate()) {
            msg = String.format("Cannot construct instance of %s (no Creators, like default constructor, exist): %s", ClassUtil.nameOf(instClass), msg);
            return this.reportBadDefinition(instClass, msg);
        }
        msg = String.format("Cannot construct instance of %s (although at least one Creator exists): %s", ClassUtil.nameOf(instClass), msg);
        return this.reportInputMismatch(instClass, msg, new Object[0]);
    }

    public Object handleInstantiationProblem(Class<?> instClass, Object argument, Throwable t) throws JacksonException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleInstantiationProblem(this, instClass, argument, t);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(instClass, instance)) {
                return instance;
            }
            this.reportBadDefinition(this.constructType(instClass), String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", ClassUtil.getClassDescription(instClass), ClassUtil.classNameOf(instance)));
        }
        ClassUtil.throwIfJacksonE(t);
        if (!this.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(t);
        }
        throw this.instantiationException(instClass, t);
    }

    public Object handleUnexpectedToken(Class<?> instClass, JsonParser p) throws JacksonException {
        return this.handleUnexpectedToken(this.constructType(instClass), p.currentToken(), p, null, new Object[0]);
    }

    public Object handleUnexpectedToken(JavaType targetType, JsonParser p) throws JacksonException {
        return this.handleUnexpectedToken(targetType, p.currentToken(), p, null, new Object[0]);
    }

    public Object handleUnexpectedToken(JavaType targetType, JsonToken t, JsonParser p, String msg, Object ... msgArgs) throws JacksonException {
        msg = this._format(msg, msgArgs);
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleUnexpectedToken(this, targetType, t, p, msg);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(targetType.getRawClass(), instance)) {
                return instance;
            }
            this.reportBadDefinition(targetType, String.format("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", ClassUtil.getTypeDescription(targetType), ClassUtil.classNameOf(instance)));
        }
        if (msg == null) {
            String targetDesc = ClassUtil.getTypeDescription(targetType);
            msg = t == null ? String.format("Unexpected end-of-input when trying read value of type %s", targetDesc) : String.format("Cannot deserialize value of type %s from %s (token `JsonToken.%s`)", targetDesc, this._shapeForToken(t), t);
        }
        if (t != null && t.isScalarValue()) {
            p.getString();
        }
        this.reportInputMismatch(targetType, msg, new Object[0]);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType baseType, String id, TypeIdResolver idResolver, String extraDesc) throws JacksonException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            JavaType type = h.value().handleUnknownTypeId(this, baseType, id, idResolver, extraDesc);
            if (type == null) continue;
            if (type.hasRawClass(Void.class)) {
                return null;
            }
            if (type.isTypeOrSubTypeOf(baseType.getRawClass())) {
                return type;
            }
            throw this.invalidTypeIdException(baseType, id, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(type));
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.invalidTypeIdException(baseType, id, extraDesc);
    }

    public JavaType handleMissingTypeId(JavaType baseType, TypeIdResolver idResolver, String extraDesc) throws JacksonException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            JavaType type = h.value().handleMissingTypeId(this, baseType, idResolver, extraDesc);
            if (type == null) continue;
            if (type.hasRawClass(Void.class)) {
                return null;
            }
            if (type.isTypeOrSubTypeOf(baseType.getRawClass())) {
                return type;
            }
            throw this.invalidTypeIdException(baseType, null, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(type));
        }
        throw this.missingTypeIdException(baseType, extraDesc);
    }

    public void handleBadMerge(ValueDeserializer<?> deser) throws DatabindException {
        if (!this.isEnabled(MapperFeature.IGNORE_MERGE_FOR_UNMERGEABLE)) {
            JavaType type = this.constructType(deser.handledType());
            String msg = String.format("Invalid configuration: values of type %s cannot be merged", ClassUtil.getTypeDescription(type));
            throw InvalidDefinitionException.from(this.getParser(), msg, type);
        }
    }

    protected boolean _isCompatible(Class<?> target, Object value) {
        if (value == null || target.isInstance(value)) {
            return true;
        }
        return target.isPrimitive() && ClassUtil.wrapperType(target).isInstance(value);
    }

    public void reportWrongTokenException(ValueDeserializer<?> deser, JsonToken expToken, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        throw this.wrongTokenException(this.getParser(), deser.handledType(), expToken, msg);
    }

    public void reportWrongTokenException(JavaType targetType, JsonToken expToken, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        throw this.wrongTokenException(this.getParser(), targetType, expToken, msg);
    }

    public void reportWrongTokenException(Class<?> targetType, JsonToken expToken, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        throw this.wrongTokenException(this.getParser(), targetType, expToken, msg);
    }

    public <T> T reportUnresolvedObjectId(ObjectIdReader oidReader, Object bean) throws DatabindException {
        String msg = String.format("No Object Id found for an instance of %s, to assign to property '%s'", ClassUtil.classNameOf(bean), oidReader.propertyName);
        return this.reportInputMismatch(oidReader.idProperty, msg, new Object[0]);
    }

    public <T> T reportInputMismatch(ValueDeserializer<?> src, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        throw MismatchedInputException.from(this.getParser(), src.handledType(), msg);
    }

    public <T> T reportInputMismatch(Class<?> targetType, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        throw MismatchedInputException.from(this.getParser(), targetType, msg);
    }

    public <T> T reportInputMismatch(JavaType targetType, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        throw MismatchedInputException.from(this.getParser(), targetType, msg);
    }

    public <T> T reportInputMismatch(BeanProperty prop, String msg, Object ... msgArgs) throws DatabindException {
        AnnotatedMember member;
        msg = this._format(msg, msgArgs);
        JavaType type = prop == null ? null : prop.getType();
        MismatchedInputException e = MismatchedInputException.from(this.getParser(), type, msg);
        if (prop != null && (member = prop.getMember()) != null) {
            e.prependPath(member.getDeclaringClass(), prop.getName());
        }
        throw e;
    }

    public <T> T reportPropertyInputMismatch(Class<?> targetType, String propertyName, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        MismatchedInputException e = MismatchedInputException.from(this.getParser(), targetType, msg);
        if (propertyName != null) {
            e.prependPath(targetType, propertyName);
        }
        throw e;
    }

    public <T> T reportPropertyInputMismatch(JavaType targetType, String propertyName, String msg, Object ... msgArgs) throws DatabindException {
        return this.reportPropertyInputMismatch(targetType.getRawClass(), propertyName, msg, msgArgs);
    }

    public <T> T reportBadCoercion(ValueDeserializer<?> src, Class<?> targetType, Object inputValue, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        InvalidFormatException e = InvalidFormatException.from(this.getParser(), msg, inputValue, targetType);
        throw e;
    }

    public <T> T reportTrailingTokens(Class<?> targetType, JsonParser p, JsonToken trailingToken) throws DatabindException {
        if (trailingToken == JsonToken.NOT_AVAILABLE) {
            throw MismatchedInputException.from(p, targetType, "Incomplete content (`JsonToken.NOT_AVAILABLE`) after value (bound as %s): not allowed as per `DeserializationFeature.FAIL_ON_TRAILING_TOKENS` (missing call to `InputFeeder.endOfInput()`?)".formatted(ClassUtil.nameOf(targetType)));
        }
        throw MismatchedInputException.from(p, targetType, "Trailing token (`JsonToken.%s`) found after value (bound as %s): not allowed as per `DeserializationFeature.FAIL_ON_TRAILING_TOKENS`".formatted(trailingToken, ClassUtil.nameOf(targetType)));
    }

    @Override
    public <T> T reportBadTypeDefinition(BeanDescription bean, String msg, Object ... msgArgs) throws DatabindException {
        String beanDesc = ClassUtil.nameOf(bean.getBeanClass());
        msg = String.format("Invalid type definition for type %s: %s", beanDesc, this._format(msg, msgArgs));
        throw InvalidDefinitionException.from(this._parser, msg, bean, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription.Supplier beanDescRef, BeanPropertyDefinition prop, String msg, Object ... msgArgs) throws DatabindException {
        return this.reportBadPropertyDefinition(beanDescRef.get(), prop, msg, msgArgs);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription bean, BeanPropertyDefinition prop, String msg, Object ... msgArgs) throws DatabindException {
        msg = this._format(msg, msgArgs);
        String propName = ClassUtil.nameOf(prop);
        String beanDesc = ClassUtil.nameOf(bean.getBeanClass());
        msg = String.format("Invalid definition for property %s (of type %s): %s", propName, beanDesc, msg);
        throw InvalidDefinitionException.from(this._parser, msg, bean, prop);
    }

    @Override
    public <T> T reportBadDefinition(JavaType type, String msg) throws DatabindException {
        throw InvalidDefinitionException.from(this._parser, msg, type);
    }

    public DatabindException wrongTokenException(JsonParser p, JavaType targetType, JsonToken expToken, String extra) {
        String msg = String.format("Unexpected token (`JsonToken.%s`), expected `JsonToken.%s`", p.currentToken(), expToken);
        msg = this._colonConcat(msg, extra);
        return MismatchedInputException.from(p, targetType, msg);
    }

    public DatabindException wrongTokenException(JsonParser p, Class<?> targetType, JsonToken expToken, String extra) {
        JsonToken t = p == null ? null : p.currentToken();
        String msg = String.format("Unexpected token (`JsonToken.%s`), expected `JsonToken.%s`", t, expToken);
        msg = this._colonConcat(msg, extra);
        return MismatchedInputException.from(p, targetType, msg);
    }

    public DatabindException weirdKeyException(Class<?> keyClass, String keyValue, String msg) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize Map key of type %s from String %s: %s", ClassUtil.nameOf(keyClass), this._quotedString(keyValue), msg), keyValue, keyClass);
    }

    public DatabindException weirdStringException(String value, Class<?> instClass, String msgBase) {
        String msg = String.format("Cannot deserialize value of type %s from String %s: %s", ClassUtil.nameOf(instClass), this._quotedString(value), msgBase);
        return InvalidFormatException.from(this._parser, msg, value, instClass);
    }

    public DatabindException weirdNumberException(Number value, Class<?> instClass, String msg) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from number %s: %s", ClassUtil.nameOf(instClass), String.valueOf(value), msg), value, instClass);
    }

    public DatabindException weirdNativeValueException(Object value, Class<?> instClass) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from native value (`JsonToken.VALUE_EMBEDDED_OBJECT`) of type %s: incompatible types", ClassUtil.nameOf(instClass), ClassUtil.classNameOf(value)), value, instClass);
    }

    public DatabindException instantiationException(Class<?> instClass, Throwable cause) {
        String excMsg;
        if (cause == null) {
            excMsg = "N/A";
        } else {
            excMsg = ClassUtil.exceptionMessage(cause);
            if (excMsg == null) {
                excMsg = ClassUtil.nameOf(cause.getClass());
            }
        }
        String msg = String.format("Cannot construct instance of %s, problem: %s", ClassUtil.nameOf(instClass), excMsg);
        return ValueInstantiationException.from(this._parser, msg, this.constructType(instClass), cause);
    }

    public DatabindException instantiationException(Class<?> instClass, String msg0) {
        return ValueInstantiationException.from(this._parser, String.format("Cannot construct instance of %s: %s", ClassUtil.nameOf(instClass), msg0), this.constructType(instClass));
    }

    @Override
    public DatabindException invalidTypeIdException(JavaType baseType, String typeId, String extraDesc) {
        String msg = String.format("Could not resolve type id '%s' as a subtype of %s", typeId, ClassUtil.getTypeDescription(baseType));
        return InvalidTypeIdException.from(this._parser, this._colonConcat(msg, extraDesc), baseType, typeId);
    }

    public DatabindException missingTypeIdException(JavaType baseType, String extraDesc) {
        String msg = String.format("Could not resolve subtype of %s", baseType);
        return InvalidTypeIdException.from(this._parser, this._colonConcat(msg, extraDesc), baseType, null);
    }

    protected DateFormat _getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }

    protected String _shapeForToken(JsonToken t) {
        return JsonToken.valueDescFor((JsonToken)t);
    }
}

