/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;

public abstract class DatabindContext {
    private static final int MAX_ERROR_STR_LEN = 500;

    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public abstract boolean isEnabled(MapperFeature var1);

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public abstract boolean isEnabled(DatatypeFeature var1);

    public abstract DatatypeFeatures getDatatypeFeatures();

    public abstract boolean canOverrideAccessModifiers();

    public abstract Class<?> getActiveView();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        if (type == null) {
            return null;
        }
        return this.getTypeFactory().constructType(type);
    }

    public abstract JavaType constructSpecializedType(JavaType var1, Class<?> var2);

    public JavaType resolveSubType(JavaType baseType, String subClassName) {
        if (subClassName.indexOf(60) > 0) {
            JavaType t = this.getTypeFactory().constructFromCanonical(subClassName);
            if (t.isTypeOrSubTypeOf(baseType.getRawClass())) {
                return t;
            }
        } else {
            Class<?> cls;
            try {
                cls = this.getTypeFactory().findClass(subClassName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (Exception e) {
                throw this.invalidTypeIdException(baseType, subClassName, String.format("problem: (%s) %s", e.getClass().getName(), ClassUtil.exceptionMessage(e)));
            }
            if (baseType.isTypeOrSuperTypeOf(cls)) {
                return this.getTypeFactory().constructSpecializedType(baseType, cls);
            }
        }
        throw this.invalidTypeIdException(baseType, subClassName, "Not a subtype");
    }

    public JavaType resolveAndValidateSubType(JavaType baseType, String subClass, PolymorphicTypeValidator ptv) {
        Class<?> cls;
        int ltIndex = subClass.indexOf(60);
        if (ltIndex > 0) {
            return this._resolveAndValidateGeneric(baseType, subClass, ptv, ltIndex);
        }
        PolymorphicTypeValidator.Validity vld = ptv.validateSubClassName(this, baseType, subClass);
        if (vld == PolymorphicTypeValidator.Validity.DENIED) {
            return (JavaType)this._throwSubtypeNameNotAllowed(baseType, subClass, ptv);
        }
        try {
            cls = this.getTypeFactory().findClass(subClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw this.invalidTypeIdException(baseType, subClass, String.format("problem: (%s) %s", e.getClass().getName(), ClassUtil.exceptionMessage(e)));
        }
        if (!baseType.isTypeOrSuperTypeOf(cls)) {
            return (JavaType)this._throwNotASubtype(baseType, subClass);
        }
        JavaType subType = this.getTypeFactory().constructSpecializedType(baseType, cls);
        if (vld != PolymorphicTypeValidator.Validity.ALLOWED && ptv.validateSubType(this, baseType, subType) != PolymorphicTypeValidator.Validity.ALLOWED) {
            return (JavaType)this._throwSubtypeClassNotAllowed(baseType, subClass, ptv);
        }
        return subType;
    }

    private JavaType _resolveAndValidateGeneric(JavaType baseType, String subClass, PolymorphicTypeValidator ptv, int ltIndex) {
        PolymorphicTypeValidator.Validity vld = ptv.validateSubClassName(this, baseType, subClass.substring(0, ltIndex));
        if (vld == PolymorphicTypeValidator.Validity.DENIED) {
            return (JavaType)this._throwSubtypeNameNotAllowed(baseType, subClass, ptv);
        }
        JavaType subType = this.getTypeFactory().constructFromCanonical(subClass);
        if (!subType.isTypeOrSubTypeOf(baseType.getRawClass())) {
            return (JavaType)this._throwNotASubtype(baseType, subClass);
        }
        if (vld != PolymorphicTypeValidator.Validity.ALLOWED && ptv.validateSubType(this, baseType, subType) != PolymorphicTypeValidator.Validity.ALLOWED) {
            return (JavaType)this._throwSubtypeClassNotAllowed(baseType, subClass, ptv);
        }
        return subType;
    }

    protected <T> T _throwNotASubtype(JavaType baseType, String subType) throws DatabindException {
        throw this.invalidTypeIdException(baseType, subType, "Not a subtype");
    }

    protected <T> T _throwSubtypeNameNotAllowed(JavaType baseType, String subType, PolymorphicTypeValidator ptv) throws DatabindException {
        throw this.invalidTypeIdException(baseType, subType, "Configured `PolymorphicTypeValidator` (of type " + ClassUtil.classNameOf(ptv) + ") denied resolution");
    }

    protected <T> T _throwSubtypeClassNotAllowed(JavaType baseType, String subType, PolymorphicTypeValidator ptv) throws DatabindException {
        throw this.invalidTypeIdException(baseType, subType, "Configured `PolymorphicTypeValidator` (of type " + ClassUtil.classNameOf(ptv) + ") denied resolution");
    }

    protected abstract DatabindException invalidTypeIdException(JavaType var1, String var2, String var3);

    public abstract TypeFactory getTypeFactory();

    public final BeanDescription introspectBeanDescription(JavaType type) {
        return this.introspectBeanDescription(type, this.introspectClassAnnotations(type));
    }

    public abstract BeanDescription introspectBeanDescription(JavaType var1, AnnotatedClass var2);

    public BeanDescription.Supplier lazyIntrospectBeanDescription(JavaType type) {
        return new BeanDescription.LazySupplier(type){

            @Override
            protected BeanDescription _construct(JavaType forType, AnnotatedClass ac) {
                return DatabindContext.this.introspectBeanDescription(forType);
            }

            @Override
            protected AnnotatedClass _introspect(JavaType forType) {
                return DatabindContext.this.introspectClassAnnotations(forType);
            }
        };
    }

    public AnnotatedClass introspectClassAnnotations(JavaType type) {
        return this.classIntrospector().introspectClassAnnotations(type);
    }

    public AnnotatedClass introspectDirectClassAnnotations(JavaType type) {
        return this.classIntrospector().introspectDirectClassAnnotations(type);
    }

    public AnnotatedClass introspectClassAnnotations(Class<?> rawType) {
        return this.introspectClassAnnotations(this.constructType(rawType));
    }

    protected abstract ClassIntrospector classIntrospector();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        ObjectIdGenerator<?> gen;
        Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
        MapperConfig<?> config = this.getConfig();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator = gen = hi == null ? null : hi.objectIdGeneratorInstance(config, annotated, implClass);
        if (gen == null) {
            gen = ClassUtil.createInstance(implClass, config.canOverrideAccessModifiers());
        }
        return gen.forScope(objectIdInfo.getScope());
    }

    public ObjectIdResolver objectIdResolverInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        ObjectIdResolver resolver;
        Class<? extends ObjectIdResolver> implClass = objectIdInfo.getResolverType();
        MapperConfig<?> config = this.getConfig();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        ObjectIdResolver objectIdResolver = resolver = hi == null ? null : hi.resolverIdGeneratorInstance(config, annotated, implClass);
        if (resolver == null) {
            resolver = ClassUtil.createInstance(implClass, config.canOverrideAccessModifiers());
        }
        return resolver;
    }

    public Converter<Object, Object> converterInstance(Annotated annotated, Object converterDef) {
        Converter conv;
        if (converterDef == null) {
            return null;
        }
        if (converterDef instanceof Converter) {
            return (Converter)converterDef;
        }
        if (!(converterDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + converterDef.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class converterClass = (Class)converterDef;
        if (converterClass == Converter.None.class || ClassUtil.isBogusClass(converterClass)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(converterClass)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + converterClass.getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> config = this.getConfig();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        Converter converter = conv = hi == null ? null : hi.converterInstance(config, annotated, converterClass);
        if (conv == null) {
            conv = (Converter)ClassUtil.createInstance(converterClass, config.canOverrideAccessModifiers());
        }
        return conv;
    }

    public abstract PropertyName findRootName(JavaType var1);

    public abstract PropertyName findRootName(Class<?> var1);

    public abstract <T> T reportBadDefinition(JavaType var1, String var2) throws DatabindException;

    public <T> T reportBadDefinition(Class<?> type, String msg) throws DatabindException {
        return this.reportBadDefinition(this.constructType(type), msg);
    }

    public abstract <T> T reportBadTypeDefinition(BeanDescription var1, String var2, Object ... var3) throws DatabindException;

    public <T> T reportBadTypeDefinition(BeanDescription.Supplier beanDescRef, String msg, Object ... msgArgs) throws DatabindException {
        return this.reportBadTypeDefinition(beanDescRef.get(), msg, msgArgs);
    }

    protected final String _format(String msg, Object ... msgArgs) {
        if (msgArgs.length > 0) {
            return String.format(msg, msgArgs);
        }
        return msg;
    }

    protected final String _truncate(String desc) {
        if (desc == null) {
            return "";
        }
        if (desc.length() <= 500) {
            return desc;
        }
        return desc.substring(0, 500) + "]...[" + desc.substring(desc.length() - 500);
    }

    protected String _quotedString(String desc) {
        if (desc == null) {
            return "[N/A]";
        }
        return String.format("\"%s\"", this._truncate(desc));
    }

    protected String _colonConcat(String msgBase, String extra) {
        if (extra == null) {
            return msgBase;
        }
        return msgBase + ": " + extra;
    }

    protected String _desc(String desc) {
        if (desc == null) {
            return "[N/A]";
        }
        return this._truncate(desc);
    }
}

