/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components.change;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class ChangeLine
extends Component {
    private static final int DEFAULT_WIDTH = 2;
    private static final String DEFAULT_COLOR = "#3D9970";
    private final String color;
    private final int width;

    private ChangeLine(LineBuilder lineBuilder) {
        this.color = lineBuilder.color;
        this.width = lineBuilder.width;
    }

    @Override
    public String asJavascript() {
        return this.asJSON();
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (!this.color.equals(DEFAULT_COLOR)) {
            context.put("color", this.color);
        }
        if (this.width != 2) {
            context.put("width", this.width);
        }
        return context;
    }

    @Override
    protected Map<String, Object> getContext() {
        return this.getJSONContext();
    }

    public static LineBuilder builder() {
        return new LineBuilder();
    }

    public static class LineBuilder {
        private String color = "#3D9970";
        private int width = 2;

        public LineBuilder color(String color) {
            this.color = color;
            return this;
        }

        public LineBuilder width(int width) {
            Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
            this.width = width;
            return this;
        }

        public ChangeLine build() {
            return new ChangeLine(this);
        }
    }
}

