/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Config
extends Component {
    private final Boolean displayModeBar;
    private final Boolean responsive;
    private final Boolean displayLogo;

    private Config(Builder builder) {
        this.displayModeBar = builder.displayModeBar;
        this.responsive = builder.responsive;
        this.displayLogo = builder.displayLogo;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String asJavascript() {
        return "var config = " + this.asJSON();
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        return this.getContext();
    }

    @Override
    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("displayModeBar", this.displayModeBar);
        context.put("responsive", this.responsive);
        context.put("displaylogo", this.displayLogo);
        return context;
    }

    public static class Builder {
        Boolean displayModeBar;
        Boolean responsive;
        Boolean displayLogo;

        private Builder() {
        }

        public Builder displayModeBar(boolean displayModeBar) {
            this.displayModeBar = displayModeBar;
            return this;
        }

        public Builder responsive(boolean responsive) {
            this.responsive = responsive;
            return this;
        }

        public Builder displayLogo(boolean displayLogo) {
            this.displayLogo = displayLogo;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

