/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.serialization;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.rsquared.restapi.Parameter;
import software.rsquared.restapi.RestObject;
import software.rsquared.restapi.exceptions.SerializationException;
import software.rsquared.restapi.serialization.JsonSerializer;

public class ObjectToJsonSerializer
implements JsonSerializer {
    protected final ObjectMapper objectMapper;
    protected final Config config;

    public ObjectToJsonSerializer() {
        this(new Config());
    }

    public ObjectToJsonSerializer(@NonNull Config config) {
        this.config = config;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        this.setupModule(module);
        this.objectMapper.registerModule((Module)module);
        if (!this.config.nullValues) {
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        if (config.disableAutoDetect) {
            this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        }
    }

    public ObjectToJsonSerializer(ObjectMapper objectMapper) {
        this.config = new Config();
        this.objectMapper = objectMapper;
    }

    private static boolean isEmpty(CharSequence text) {
        return text == null || text.length() <= 0;
    }

    @CallSuper
    protected void setupModule(SimpleModule module) {
        module.addSerializer(File.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<File>(){

            public void serialize(File value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString("__file{" + value.getAbsolutePath() + "}");
            }
        });
        if (this.config.intBoolean) {
            module.addSerializer(Boolean.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Boolean>(){

                public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    if (value != null) {
                        gen.writeNumber(value != false ? 1 : 0);
                    }
                }
            });
            module.addSerializer(Boolean.TYPE, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Boolean>(){

                public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    gen.writeNumber(value != null && value != false ? 1 : 0);
                }
            });
            module.addSerializer(boolean[].class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<boolean[]>(){

                public void serialize(boolean[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    if (value == null) {
                        return;
                    }
                    int[] array = new int[value.length];
                    for (int i = 0; i < value.length; ++i) {
                        Boolean aBoolean = value[i];
                        array[i] = aBoolean != false ? 1 : 0;
                    }
                    gen.writeArray(array, 0, array.length);
                }
            });
        }
        if (this.config.timeInSeconds) {
            module.addSerializer(Calendar.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Calendar>(){

                public void serialize(Calendar value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    if (value != null) {
                        gen.writeNumber(value.getTimeInMillis() / 1000L);
                    }
                }
            });
            module.addSerializer(Date.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Date>(){

                public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    if (value != null) {
                        gen.writeNumber(value.getTime() / 1000L);
                    }
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(@NonNull List<Parameter> parameters, @NonNull String name, @Nullable Object object) {
        if (object == null) return;
        JsonNode newNode = this.objectMapper.valueToTree(object);
        if (parameters.isEmpty()) {
            if (ObjectToJsonSerializer.isEmpty(name)) {
                parameters.add(new Parameter(name, newNode));
                return;
            } else {
                ObjectNode objectNode = this.objectMapper.createObjectNode();
                objectNode.replace(name, newNode);
                parameters.add(new Parameter(null, objectNode));
            }
            return;
        } else {
            ObjectNode oldNode = (ObjectNode)parameters.get(0).getValue();
            if (ObjectToJsonSerializer.isEmpty(name)) {
                if (!newNode.isObject()) throw new SerializationException("Unknown property name");
                ObjectNode objectNode = (ObjectNode)newNode;
                Iterator iterator = objectNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)iterator.next();
                    oldNode.replace((String)next.getKey(), (JsonNode)next.getValue());
                }
                return;
            } else {
                oldNode.replace(name, newNode);
            }
        }
    }

    @Override
    public String toJsonString(@NonNull List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return "";
        }
        ObjectNode node = (ObjectNode)parameters.get(0).getValue();
        try {
            return this.objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException(e);
        }
    }

    private <T> String getObjectName(T object) {
        RestObject restObject = object.getClass().getAnnotation(RestObject.class);
        if (!ObjectToJsonSerializer.isEmpty(restObject.value())) {
            return restObject.value();
        }
        return object.getClass().getSimpleName();
    }

    public static class Config {
        private boolean timeInSeconds;
        private boolean intBoolean;
        private boolean nullValues;
        private boolean disableAutoDetect;

        public Config setTimeInSeconds(boolean timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
            return this;
        }

        public Config setIntBoolean(boolean intBoolean) {
            this.intBoolean = intBoolean;
            return this;
        }

        public Config setSerializeNullValues(boolean nonNullValues) {
            this.nullValues = nonNullValues;
            return this;
        }

        public Config setDisableAutoDetect(boolean disable) {
            this.disableAutoDetect = disable;
            return this;
        }
    }
}

