package software.rsquared.restapi;

import android.support.annotation.WorkerThread;

/**
 * @author Rafał Zajfert
 */
public abstract class RequestAuthenticator {


	public RequestAuthenticator() {
	}

	protected boolean isAuthorizable(Request request) {
		return request instanceof Authorizable;
	}

	synchronized Parameters checkAndAdd(Request request, Parameters parameters) {
		if (parameters == null) {
			parameters = new Parameters();
		}
		checkAuthorization(request);
		addAuthorization(request, parameters);
		return parameters;
	}

	@WorkerThread
	protected abstract void checkAuthorization(Request request);

	/**
	 * Add authorization parameters to {@link Parameters parameters}
	 */
	@WorkerThread
	protected abstract void addAuthorization(Request request, Parameters parameters);
}
