/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.exceptions.RequestException;

class SerialPoolRequest
extends PoolRequest {
    private Map<Integer, Object> results = new LinkedHashMap<Integer, Object>();
    private Iterator<Map.Entry<Integer, Request>> executeIterator;
    private boolean notified;

    SerialPoolRequest() {
    }

    @Override
    public void execute() {
        this.executeIterator = this.requestPool.entrySet().iterator();
        this.onPreExecute();
        this.notified = false;
        this.checkAndExecuteNext(false);
    }

    private void checkAndExecuteNext(boolean forceCancel) {
        if (this.cancelled.get() || this.notified) {
            return;
        }
        if (this.results.size() == this.requestPool.size()) {
            this.notified = true;
            this.onSuccess(this.results);
            this.onPostExecute();
        } else if (forceCancel) {
            this.notified = true;
            this.cancel();
            this.onPostExecute();
        } else if (this.executeIterator.hasNext()) {
            this.executeNext();
        } else {
            throw new IllegalStateException("results size != requests size and queue is empty!");
        }
    }

    private void executeNext() {
        Map.Entry<Integer, Request> entry = this.executeIterator.next();
        Integer requestCode = entry.getKey();
        Request request = entry.getValue();
        request.execute(this.api, new PoolRequest.PoolRequestListener((int)requestCode){

            @Override
            public void onSuccess(Object result) {
                int requestCode = this.getRequestCode();
                SerialPoolRequest.this.onTaskSuccess(result, requestCode);
                SerialPoolRequest.this.results.put(requestCode, result);
                SerialPoolRequest.this.checkAndExecuteNext(false);
            }

            @Override
            public void onFailed(RequestException e) {
                int requestCode = this.getRequestCode();
                SerialPoolRequest.this.onFailed(e, requestCode);
                if (SerialPoolRequest.this.canContinueAfterFailed(e, requestCode)) {
                    SerialPoolRequest.this.results.put(requestCode, null);
                    SerialPoolRequest.this.checkAndExecuteNext(false);
                } else {
                    SerialPoolRequest.this.checkAndExecuteNext(true);
                }
            }

            @Override
            public void onCanceled() {
                if (!SerialPoolRequest.this.cancelled.get()) {
                    SerialPoolRequest.this.cancel();
                }
            }
        });
    }
}

