/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RequestFuture;
import software.rsquared.restapi.RestApiConfiguration;
import software.rsquared.restapi.SerialPoolRequest;
import software.rsquared.restapi.ThreadPoolRequest;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;
import software.rsquared.restapi.listeners.SyncRequestListener;

public class RestApi {
    public static final int THREAD_POOL_EXECUTOR = 1;
    public static final int SERIAL_EXECUTOR = 2;
    private static RestApiConfiguration configuration;
    @NonNull
    private static SparseArray<RequestFuture> requests;
    @NonNull
    private static SparseArray<PoolRequest> poolRequests;

    static RestApiConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(@NonNull RestApiConfiguration configuration) {
        RestApi.configuration = configuration;
    }

    public static <E> void execute(@NonNull Request<E> request, @Nullable RequestListener<E> listener) {
        request.execute(listener);
    }

    public static <E> E executeSync(@NonNull Request<E> request) throws RequestException {
        return request.execute().get();
    }

    @Nullable
    public static <E> E executeSync(@NonNull Request<E> request, @Nullable SyncRequestListener<E> listener) {
        try {
            return request.execute(listener).get();
        }
        catch (RequestException e) {
            return null;
        }
    }

    public static <E> void execute(@NonNull Request<E> request, final int requestCode, final @Nullable RequestListener<E> listener) {
        RequestFuture<E> future = request.execute(new RequestListener<E>(){

            @Override
            public void onSuccess(E result) {
                if (listener != null) {
                    listener.onSuccess(result);
                }
            }

            @Override
            public void onFailed(RequestException e) {
                if (listener != null) {
                    listener.onFailed(e);
                }
            }

            @Override
            public void onPreExecute() {
                if (listener != null) {
                    listener.onPreExecute();
                }
            }

            @Override
            public void onPostExecute() {
                requests.delete(requestCode);
                if (listener != null) {
                    listener.onPostExecute();
                }
            }

            @Override
            public void onCanceled() {
                if (listener != null) {
                    listener.onCanceled();
                }
            }
        });
        requests.put(requestCode, future);
    }

    public static PoolBuilder pool(int executor) {
        return new PoolBuilder(executor);
    }

    public static void cancel(int requestCode) {
        RequestFuture future = (RequestFuture)requests.get(requestCode);
        if (future != null) {
            future.cancel(true);
        }
    }

    public static void cancelPool(int requestCode) {
        PoolRequest pool = (PoolRequest)poolRequests.get(requestCode);
        if (pool != null) {
            pool.cancel();
        }
    }

    static {
        requests = new SparseArray();
        poolRequests = new SparseArray();
    }

    public static class PoolBuilder {
        protected Map<Integer, Request> requestPool = new LinkedHashMap<Integer, Request>();
        private int executor;

        public PoolBuilder(int executor) {
            this.executor = executor;
        }

        public PoolRequest build() {
            PoolRequest poolRequest;
            switch (this.executor) {
                case 1: {
                    poolRequest = new ThreadPoolRequest(this.requestPool.size());
                    break;
                }
                default: {
                    poolRequest = new SerialPoolRequest();
                }
            }
            for (Map.Entry<Integer, Request> entry : this.requestPool.entrySet()) {
                poolRequest.addTask(entry.getValue(), entry.getKey());
            }
            return poolRequest;
        }

        public void execute(@Nullable RequestPoolListener listener) {
            PoolRequest poolRequest = this.build();
            poolRequest.execute(listener);
        }

        public void execute(final @Nullable RequestPoolListener listener, final int requestCode) {
            PoolRequest poolRequest = this.build();
            poolRequest.execute(new RequestPoolListener(){

                @Override
                public void onSuccess(@NonNull Map<Integer, Object> result) {
                    if (listener != null) {
                        listener.onSuccess(result);
                    }
                }

                @Override
                public void onFailed(RequestException e, int requestCode2) {
                    if (listener != null) {
                        listener.onFailed(e, requestCode2);
                    }
                }

                @Override
                public boolean canContinueAfterFailed(RequestException e, int requestCode2) {
                    return listener == null || listener.canContinueAfterFailed(e, requestCode2);
                }

                @Override
                public void onPreExecute() {
                    if (listener != null) {
                        listener.onPreExecute();
                    }
                }

                @Override
                public void onTaskSuccess(Object result, int requestCode2) {
                    if (listener != null) {
                        listener.onTaskSuccess(result, requestCode2);
                    }
                }

                @Override
                public void onPostExecute() {
                    if (listener != null) {
                        listener.onPostExecute();
                    }
                    poolRequests.delete(requestCode);
                }

                @Override
                public void onCanceled() {
                    if (listener != null) {
                        listener.onCanceled();
                    }
                }
            });
            poolRequests.put(requestCode, (Object)poolRequest);
        }

        public PoolBuilder add(@NonNull Request request, int requestCode) {
            this.requestPool.put(requestCode, request);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Executor {
    }
}

