/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.Nullable;

class RestApiUtils {
    RestApiUtils() {
    }

    static String getClassCodeLine(String requestClassName) {
        StackTraceElement stackTraceElement = RestApiUtils.getStackTraceElement(requestClassName);
        if (stackTraceElement != null) {
            return "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
        }
        return "(Request:1)";
    }

    @Nullable
    private static StackTraceElement getStackTraceElement(String requestClassName) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements == null || elements.length <= 2) {
            return null;
        }
        for (int i = 2; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            String className = element.getClassName();
            if (RestApiUtils.isExcludedClass(className) || className.equals(requestClassName) && "<init>".equals(element.getMethodName())) continue;
            return element;
        }
        return null;
    }

    private static boolean isExcludedClass(String className) {
        return className.startsWith("software.rsquared.restapi");
    }
}

