package software.rsquared.restapi;

import android.support.annotation.Nullable;


/**
 * @author Rafał Zajfert
 */
class RestApiUtils {

	static String getClassCodeLine() {
		StackTraceElement stackTraceElement = getStackTraceElement();
		if (stackTraceElement != null) {
			return "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
		} else {
			return "(Request:1)";
		}
	}

	@Nullable
	private static StackTraceElement getStackTraceElement() {
		StackTraceElement[] elements = Thread.currentThread().getStackTrace();
		if (elements == null || elements.length <= 2) {
			return null;
		}

		for (int i = 2; i < elements.length; i++) {
			String className = elements[i].getClassName();
			if (!isExcludedClass(className)) {
				return elements[i];
			}
		}
		return null;
	}


	private static boolean isExcludedClass(String className) {
		return className.startsWith("software.rsquared.restapi");
	}
}
